/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.api.planets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.adastra.common.planets.AdAstraData;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public record Planet(ResourceKey<Level> dimension, boolean oxygen, short temperature, float gravity, int solarPower, ResourceLocation solarSystem, Optional<ResourceKey<Level>> orbit, int tier, List<ResourceKey<Level>> additionalLaunchDimensions) {
    public static final ResourceKey<Level> EARTH_ORBIT = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("ad_astra", "earth_orbit"));
    public static final ResourceKey<Level> MOON_ORBIT = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("ad_astra", "moon_orbit"));
    public static final ResourceKey<Level> MARS_ORBIT = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("ad_astra", "mars_orbit"));
    public static final ResourceKey<Level> VENUS_ORBIT = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("ad_astra", "venus_orbit"));
    public static final ResourceKey<Level> MERCURY_ORBIT = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("ad_astra", "mercury_orbit"));
    public static final ResourceKey<Level> GLACIO_ORBIT = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("ad_astra", "glacio_orbit"));
    public static final ResourceKey<Level> MOON = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("ad_astra", "moon"));
    public static final ResourceKey<Level> MARS = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("ad_astra", "mars"));
    public static final ResourceKey<Level> VENUS = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("ad_astra", "venus"));
    public static final ResourceKey<Level> MERCURY = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("ad_astra", "mercury"));
    public static final ResourceKey<Level> GLACIO = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("ad_astra", "glacio"));
    public static final Codec<Planet> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).fieldOf("dimension").forGetter(Planet::dimension), (App)Codec.BOOL.fieldOf("oxygen").forGetter(Planet::oxygen), (App)Codec.SHORT.fieldOf("temperature").forGetter(Planet::temperature), (App)Codec.FLOAT.fieldOf("gravity").forGetter(Planet::gravity), (App)Codec.INT.fieldOf("solar_power").forGetter(Planet::solarPower), (App)ResourceLocation.f_135803_.fieldOf("solar_system").forGetter(Planet::solarSystem), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).optionalFieldOf("orbit").forGetter(Planet::orbit), (App)Codec.INT.fieldOf("tier").forGetter(Planet::tier), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).listOf().optionalFieldOf("additional_launch_dimensions", List.of()).forGetter(Planet::additionalLaunchDimensions)).apply((Applicative)instance, Planet::new));

    public ResourceKey<Level> orbitIfPresent() {
        return this.orbit.orElse(this.dimension);
    }

    public boolean isSpace() {
        return this.orbit.isEmpty();
    }

    public Optional<ResourceKey<Level>> getOrbitPlanet() {
        for (Planet planet : AdAstraData.planets().values()) {
            if (planet.orbit().isEmpty() || !planet.orbit().get().equals(this.dimension)) continue;
            return Optional.of(planet.dimension());
        }
        return Optional.empty();
    }
}

