/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.machines;

import earth.terrarium.adastra.api.systems.OxygenApi;
import earth.terrarium.adastra.api.systems.TemperatureApi;
import earth.terrarium.adastra.client.AdAstraClient;
import earth.terrarium.adastra.client.config.AdAstraConfigClient;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import earth.terrarium.adastra.common.blockentities.machines.OxygenLoaderBlockEntity;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.config.MachineConfig;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.container.BiFluidContainer;
import earth.terrarium.adastra.common.entities.AirVortex;
import earth.terrarium.adastra.common.menus.machines.OxygenDistributorMenu;
import earth.terrarium.adastra.common.recipes.machines.OxygenLoadingRecipe;
import earth.terrarium.adastra.common.registry.ModSoundEvents;
import earth.terrarium.adastra.common.utils.FluidUtils;
import earth.terrarium.adastra.common.utils.TransferUtils;
import earth.terrarium.adastra.common.utils.floodfill.FloodFill3D;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.InsertOnlyEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class OxygenDistributorBlockEntity
extends OxygenLoaderBlockEntity {
    public static final List<ConfigurationEntry> SIDE_CONFIG = List.of(new ConfigurationEntry(ConfigurationType.SLOT, Configuration.NONE, ConstantComponents.SIDE_CONFIG_INPUT_SLOTS), new ConfigurationEntry(ConfigurationType.SLOT, Configuration.NONE, ConstantComponents.SIDE_CONFIG_OUTPUT_SLOTS), new ConfigurationEntry(ConfigurationType.ENERGY, Configuration.NONE, ConstantComponents.SIDE_CONFIG_ENERGY), new ConfigurationEntry(ConfigurationType.FLUID, Configuration.NONE, ConstantComponents.SIDE_CONFIG_INPUT_FLUID), new ConfigurationEntry(ConfigurationType.FLUID, Configuration.NONE, ConstantComponents.SIDE_CONFIG_OUTPUT_FLUID));
    private final Set<BlockPos> lastDistributedBlocks = new HashSet<BlockPos>();
    private long energyPerTick;
    private float fluidPerTick;
    private int distributedBlocksCount;
    private double accumulatedFluid;
    private int shutDownTicks;
    private int limit = MachineConfig.maxDistributionBlocks;
    private boolean shouldSyncPositions;
    private float yRot;
    private float lastYRot;

    public OxygenDistributorBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state, 3);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("LastDistributedBlocks")) {
            this.lastDistributedBlocks.clear();
            for (long pos : tag.m_128467_("LastDistributedBlocks")) {
                this.lastDistributedBlocks.add(BlockPos.m_122022_((long)pos));
            }
        }
        this.energyPerTick = tag.m_128454_("EnergyPerTick");
        this.fluidPerTick = tag.m_128457_("FluidPerTick");
        this.distributedBlocksCount = tag.m_128451_("DistributedBlocksCount");
        this.accumulatedFluid = tag.m_128459_("AccumulatedFluid");
        this.limit = tag.m_128451_("Limit");
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128356_("EnergyPerTick", this.energyPerTick);
        tag.m_128350_("FluidPerTick", this.fluidPerTick);
        tag.m_128405_("DistributedBlocksCount", this.distributedBlocksCount);
        tag.m_128347_("AccumulatedFluid", this.accumulatedFluid);
        tag.m_128405_("Limit", this.limit);
    }

    @Override
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new OxygenDistributorMenu(id, inventory, this);
    }

    @Override
    public WrappedBlockEnergyContainer getEnergyStorage() {
        if (this.energyContainer != null) {
            return this.energyContainer;
        }
        this.energyContainer = new WrappedBlockEnergyContainer((BlockEntity)this, (EnergyContainer)new InsertOnlyEnergyContainer(MachineConfig.deshTierEnergyCapacity, MachineConfig.deshTierMaxEnergyInOut));
        return this.energyContainer;
    }

    @Override
    public void serverTick(ServerLevel level, long time, BlockState state, BlockPos pos) {
        super.serverTick(level, time, state, pos);
        if (this.shutDownTicks > 0) {
            --this.shutDownTicks;
            return;
        }
        long fluidPerTick = this.calculateFluidPerTick();
        boolean canDistribute = this.canCraftDistribution(Math.max(FluidConstants.fromMillibuckets((long)1L), fluidPerTick));
        if (this.canFunction() && canDistribute) {
            this.getEnergyStorage().internalExtract(this.calculateEnergyPerTick(), false);
            this.setLit(true);
            this.accumulatedFluid += (double)fluidPerTick;
            int wholeBuckets = (int)(this.accumulatedFluid / 1000.0);
            if (wholeBuckets > 0) {
                this.consumeDistribution(FluidConstants.fromMillibuckets((long)Math.max(1, wholeBuckets / 1000)));
                this.accumulatedFluid -= (double)wholeBuckets;
            }
            if (time % (long)MachineConfig.distributionRefreshRate == 0L) {
                this.tickOxygen(level, pos);
            }
            if (time % 200L == 0L) {
                level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.OXYGEN_OUTTAKE.get(), SoundSource.BLOCKS, 0.2f, 1.0f);
            } else if (time % 100L == 0L) {
                level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.OXYGEN_INTAKE.get(), SoundSource.BLOCKS, 0.2f, 1.0f);
            }
        } else if (!this.lastDistributedBlocks.isEmpty()) {
            this.clearOxygenBlocks();
            this.shutDownTicks = 60;
            this.setLit(false);
        } else if (time % 10L == 0L) {
            this.setLit(false);
        }
        this.energyPerTick = (long)(this.recipe != null && this.canCraft() ? ((OxygenLoadingRecipe)this.recipe).energy() : 0) + (canDistribute ? this.calculateEnergyPerTick() : 0L);
        this.fluidPerTick = canDistribute ? (float)fluidPerTick : 0.0f;
        this.distributedBlocksCount = canDistribute ? this.lastDistributedBlocks.size() : 0;
    }

    @Override
    public void tickSideInteractions(BlockPos pos, Predicate<Direction> filter, List<ConfigurationEntry> sideConfig) {
        TransferUtils.pullItemsNearby(this, pos, new int[]{1}, sideConfig.get(0), filter);
        TransferUtils.pushItemsNearby(this, pos, new int[]{2}, sideConfig.get(1), filter);
        TransferUtils.pullEnergyNearby(this, pos, this.getEnergyStorage().maxInsert(), sideConfig.get(2), filter);
        TransferUtils.pullFluidNearby(this, pos, this.getFluidContainer(), FluidConstants.fromMillibuckets((long)200L), 0, sideConfig.get(3), filter);
        TransferUtils.pushFluidNearby(this, pos, this.getFluidContainer(), FluidConstants.fromMillibuckets((long)200L), 1, sideConfig.get(4), filter);
    }

    @Override
    public void onRemoved() {
        this.clearOxygenBlocks();
    }

    private boolean canCraftDistribution(long fluidAmount) {
        long energy = this.calculateEnergyPerTick();
        if (this.getEnergyStorage().internalExtract(energy, true) < energy) {
            return false;
        }
        return ((BiFluidContainer)this.getFluidContainer().container()).output().internalExtract(((FluidHolder)this.getFluidContainer().getFluids().get(1)).copyWithAmount(fluidAmount), true).getFluidAmount() >= fluidAmount;
    }

    protected void consumeDistribution(long fluidAmount) {
        ((BiFluidContainer)this.getFluidContainer().container()).output().internalExtract(((FluidHolder)this.getFluidContainer().getFluids().get(1)).copyWithAmount(fluidAmount), false);
    }

    protected void tickOxygen(ServerLevel level, BlockPos pos) {
        this.limit = MachineConfig.maxDistributionBlocks;
        Set<BlockPos> positions = FloodFill3D.run((Level)level, pos.m_7494_(), this.limit, FloodFill3D.TEST_FULL_SEAL, true);
        OxygenApi.API.setOxygen((Level)level, positions, true);
        TemperatureApi.API.setTemperature((Level)level, positions, (short)22);
        HashSet<BlockPos> lastPositionsCopy = new HashSet<BlockPos>(this.lastDistributedBlocks);
        this.resetLastDistributedBlocks(positions);
        if (AdAstraConfig.disableAirVortexes) {
            return;
        }
        if (positions.size() < this.limit) {
            return;
        }
        if (lastPositionsCopy.size() >= this.limit) {
            return;
        }
        if (OxygenApi.API.hasOxygen((Level)level)) {
            return;
        }
        positions.removeAll(lastPositionsCopy);
        BlockPos target = positions.stream().skip(1L).findFirst().orElse(positions.stream().findFirst().orElse(null));
        if (target == null) {
            return;
        }
        AirVortex vortex = new AirVortex((Level)level, pos, lastPositionsCopy);
        vortex.m_146884_(Vec3.m_82512_((Vec3i)target));
        level.m_7967_((Entity)vortex);
    }

    protected void resetLastDistributedBlocks(Set<BlockPos> positions) {
        this.lastDistributedBlocks.removeAll(positions);
        this.clearOxygenBlocks();
        this.lastDistributedBlocks.addAll(positions);
        this.shouldSyncPositions = true;
    }

    protected void clearOxygenBlocks() {
        OxygenApi.API.removeOxygen(this.f_58857_, this.lastDistributedBlocks);
        TemperatureApi.API.removeTemperature(this.f_58857_, this.lastDistributedBlocks);
        this.lastDistributedBlocks.clear();
    }

    @Override
    public void updateSlots() {
        FluidUtils.moveItemToContainer(this, (FluidContainer)this.getFluidContainer(), 1, 2, 0);
        this.sync();
    }

    @Override
    public void clientTick(ClientLevel level, long time, BlockState state, BlockPos pos) {
        if (time % 40L == 0L) {
            if (AdAstraConfigClient.showOxygenDistributorArea) {
                AdAstraClient.OXYGEN_OVERLAY_RENDERER.removePositions(pos);
                if (AdAstraClient.OXYGEN_OVERLAY_RENDERER.canAdd(pos) && this.canFunction() && this.canCraftDistribution(FluidConstants.fromMillibuckets((long)Math.max(1L, this.calculateFluidPerTick() / 1000L)))) {
                    AdAstraClient.OXYGEN_OVERLAY_RENDERER.addPositions(pos, this.lastDistributedBlocks);
                }
            } else {
                AdAstraClient.OXYGEN_OVERLAY_RENDERER.clearPositions();
            }
        }
        this.lastYRot = this.yRot;
        if (this.isLit()) {
            this.yRot += 10.0f;
        }
    }

    @Override
    public boolean shouldAutomaticallyUpdateLitState() {
        return false;
    }

    public int distributedBlocksCount() {
        return this.canFunction() ? this.distributedBlocksCount : 0;
    }

    public int distributedBlocksLimit() {
        return this.limit;
    }

    public long energyPerTick() {
        return this.canFunction() ? this.energyPerTick : 0L;
    }

    public float fluidPerTick() {
        return this.canFunction() ? this.fluidPerTick : 0.0f;
    }

    public float yRot() {
        return this.yRot;
    }

    public float lastYRot() {
        return this.lastYRot;
    }

    private long calculateEnergyPerTick() {
        return Math.max(1, this.lastDistributedBlocks.size() / 50);
    }

    private long calculateFluidPerTick() {
        return FluidConstants.fromMillibuckets((long)Math.max(1, this.lastDistributedBlocks.size() / 1500));
    }

    @Override
    public List<ConfigurationEntry> getDefaultConfig() {
        return SIDE_CONFIG;
    }

    @Override
    public int @NotNull [] m_7071_(@NotNull Direction side) {
        return new int[]{1, 2};
    }

    @Override
    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        if (this.shouldSyncPositions) {
            tag.m_128388_("LastDistributedBlocks", this.lastDistributedBlocks.stream().mapToLong(BlockPos::m_121878_).toArray());
            this.shouldSyncPositions = false;
        }
        return tag;
    }
}

