/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blocks.base;

import com.teamresourceful.resourcefullib.common.caches.CacheableFunction;
import com.teamresourceful.resourcefullib.common.registry.RegistryEntry;
import earth.terrarium.adastra.common.blockentities.base.TickableBlockEntity;
import earth.terrarium.adastra.common.registry.ModBlockEntityTypes;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public abstract class BasicEntityBlock
extends BaseEntityBlock {
    private static final CacheableFunction<Block, BlockEntityType<?>> BLOCK_TO_ENTITY = new CacheableFunction(block -> ModBlockEntityTypes.BLOCK_ENTITY_TYPES.stream().map(RegistryEntry::get).filter(type -> type.m_155262_(block.m_49966_())).findFirst().orElse(null));
    private BlockEntityType<?> entity;
    private final boolean shouldTick;

    public BasicEntityBlock(BlockBehaviour.Properties properties, boolean shouldTick) {
        super(properties);
        this.shouldTick = shouldTick;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.entity(state).m_155264_(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntityType<?> entity(BlockState state) {
        if (this.entity == null) {
            this.entity = (BlockEntityType)BLOCK_TO_ENTITY.apply((Object)state.m_60734_());
        }
        return this.entity;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return !this.shouldTick ? null : (entityLevel, pos, blockState, blockEntity) -> {
            if (blockEntity instanceof TickableBlockEntity) {
                TickableBlockEntity tickable = (TickableBlockEntity)blockEntity;
                long time = level.m_46467_() - (long)pos.hashCode();
                tickable.tick(entityLevel, time, blockState, pos);
                if (level.m_5776_()) {
                    tickable.clientTick((ClientLevel)level, time, state, pos);
                } else {
                    tickable.serverTick((ServerLevel)level, time, state, pos);
                    tickable.internalServerTick((ServerLevel)level, time, state, pos);
                }
                if (!tickable.isInitialized()) {
                    tickable.firstTick(level, pos, state);
                }
            }
        };
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof TickableBlockEntity) {
                TickableBlockEntity tickable = (TickableBlockEntity)blockEntity;
                tickable.onRemoved();
            }
            super.m_6810_(state, level, pos, newState, moved);
        }
    }

    public static void preventCreativeDropFromBottomPart(Level level, BlockPos pos, BlockState state, Player player) {
        if (state.m_61143_((Property)BlockStateProperties.f_61401_) != DoubleBlockHalf.UPPER) {
            return;
        }
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = level.m_8055_(belowPos);
        if (belowState.m_60713_(state.m_60734_()) && belowState.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER) {
            BlockState blockState2 = belowState.m_60819_().m_192917_((Fluid)Fluids.f_76193_) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            level.m_7731_(belowPos, blockState2, 35);
            level.m_5898_(player, 2001, belowPos, Block.m_49956_((BlockState)belowState));
        }
    }
}

