/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.entities.vehicles;

import earth.terrarium.adastra.api.systems.OxygenApi;
import earth.terrarium.adastra.client.utils.SoundUtils;
import earth.terrarium.adastra.common.blocks.LaunchPadBlock;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.entities.vehicles.Vehicle;
import earth.terrarium.adastra.common.menus.PlanetsMenu;
import earth.terrarium.adastra.common.menus.base.PlanetsMenuProvider;
import earth.terrarium.adastra.common.menus.vehicles.RocketMenu;
import earth.terrarium.adastra.common.planets.AdAstraData;
import earth.terrarium.adastra.common.registry.ModDamageSources;
import earth.terrarium.adastra.common.registry.ModEntityTypes;
import earth.terrarium.adastra.common.registry.ModItems;
import earth.terrarium.adastra.common.registry.ModParticleTypes;
import earth.terrarium.adastra.common.registry.ModSoundEvents;
import earth.terrarium.adastra.common.tags.ModFluidTags;
import earth.terrarium.adastra.common.utils.FluidUtils;
import earth.terrarium.botarium.common.fluid.FluidApi;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.SimpleFluidContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import earth.terrarium.botarium.common.menu.ExtraDataMenuProvider;
import earth.terrarium.botarium.common.menu.MenuHooks;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Rocket
extends Vehicle {
    private static final RocketProperties TIER_1_PROPERTIES = new RocketProperties(1, (Item)ModItems.TIER_1_ROCKET.get(), 1.0f, ModFluidTags.TIER_1_ROCKET_FUEL);
    private static final RocketProperties TIER_2_PROPERTIES = new RocketProperties(2, (Item)ModItems.TIER_2_ROCKET.get(), 1.0f, ModFluidTags.TIER_2_ROCKET_FUEL);
    private static final RocketProperties TIER_3_PROPERTIES = new RocketProperties(3, (Item)ModItems.TIER_3_ROCKET.get(), 1.0f, ModFluidTags.TIER_3_ROCKET_FUEL);
    private static final RocketProperties TIER_4_PROPERTIES = new RocketProperties(4, (Item)ModItems.TIER_4_ROCKET.get(), 1.7f, ModFluidTags.TIER_4_ROCKET_FUEL);
    public static final Map<EntityType<?>, RocketProperties> ROCKET_TO_PROPERTIES = Map.of((EntityType)ModEntityTypes.TIER_1_ROCKET.get(), TIER_1_PROPERTIES, (EntityType)ModEntityTypes.TIER_2_ROCKET.get(), TIER_2_PROPERTIES, (EntityType)ModEntityTypes.TIER_3_ROCKET.get(), TIER_3_PROPERTIES, (EntityType)ModEntityTypes.TIER_4_ROCKET.get(), TIER_4_PROPERTIES);
    public static final int COUNTDOWN_LENGTH = 200;
    public static final EntityDataAccessor<Boolean> IS_LAUNCHING = SynchedEntityData.m_135353_(Rocket.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> LAUNCH_TICKS = SynchedEntityData.m_135353_(Rocket.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> HAS_LAUNCHED = SynchedEntityData.m_135353_(Rocket.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_IN_VALID_DIMENSION = SynchedEntityData.m_135353_(Rocket.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Long> FUEL = SynchedEntityData.m_135353_(Rocket.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    public static final EntityDataAccessor<String> FUEL_TYPE = SynchedEntityData.m_135353_(Rocket.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final SimpleFluidContainer fluidContainer;
    private final RocketProperties properties;
    private boolean launchpadBound;
    private float speed = 0.05f;
    private float angle;
    public boolean startedRocketSound;
    private boolean showFuelMessage = true;

    public Rocket(EntityType<?> type, Level level) {
        this(type, level, ROCKET_TO_PROPERTIES.get(type));
    }

    public Rocket(EntityType<?> type, Level level, RocketProperties properties) {
        super(type, level);
        this.properties = properties;
        this.fluidContainer = new SimpleFluidContainer(FluidConstants.fromMillibuckets((long)3000L), 1, (amount, fluid) -> fluid.is(properties.fuel));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_LAUNCHING, (Object)false);
        this.f_19804_.m_135372_(LAUNCH_TICKS, (Object)-1);
        this.f_19804_.m_135372_(HAS_LAUNCHED, (Object)false);
        this.f_19804_.m_135372_(IS_IN_VALID_DIMENSION, (Object)(AdAstraConfig.launchFromAnywhere || AdAstraData.canLaunchFrom((ResourceKey<Level>)this.m_9236_().m_46472_()) ? 1 : 0));
        this.f_19804_.m_135372_(FUEL, (Object)0L);
        this.f_19804_.m_135372_(FUEL_TYPE, (Object)"air");
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(IS_LAUNCHING, (Object)compound.m_128471_("Launching"));
        this.f_19804_.m_135381_(LAUNCH_TICKS, (Object)compound.m_128451_("launchTicks"));
        this.f_19804_.m_135381_(HAS_LAUNCHED, (Object)compound.m_128471_("HasLaunched"));
        this.speed = compound.m_128457_("Speed");
        this.angle = compound.m_128457_("Angle");
        this.fluidContainer.deserialize(compound);
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Launching", this.isLaunching());
        compound.m_128405_("LaunchTicks", this.launchTicks());
        compound.m_128379_("HasLaunched", this.hasLaunched());
        compound.m_128350_("Speed", this.speed);
        compound.m_128350_("Angle", this.angle);
        this.fluidContainer.serialize(compound);
    }

    public FluidContainer fluidContainer() {
        return this.fluidContainer;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.isLaunching() && !this.hasLaunched()) {
            super.m_6469_(source, amount);
        }
        return false;
    }

    @Override
    public ItemStack getDropStack() {
        ItemStackHolder stack = new ItemStackHolder(this.properties.item.m_7968_());
        ItemFluidContainer container = FluidContainer.of((ItemStackHolder)stack);
        if (container == null) {
            return stack.getStack();
        }
        FluidApi.moveFluid((FluidContainer)this.fluidContainer, (FluidContainer)container, (FluidHolder)this.fluidContainer.getFirstFluid(), (boolean)false);
        return stack.getStack();
    }

    public int tier() {
        return this.properties.tier;
    }

    public double m_6048_() {
        return this.properties.ridingOffset;
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        Vec3 location = super.m_7688_(passenger).m_82549_(passenger.m_20154_().m_82542_(2.0, 0.0, 2.0).m_82541_());
        for (int i = 0; i < 6 && this.m_9236_().m_8055_(BlockPos.m_274446_((Position)location)).m_60795_(); ++i) {
            location = location.m_82492_(0.0, 1.0, 0.0);
        }
        return location;
    }

    @Override
    public boolean isSafeToDismount(Player player) {
        return !this.isLaunching() && !this.hasLaunched();
    }

    @Override
    public boolean shouldSit() {
        return false;
    }

    @Override
    public boolean zoomOutCameraInThirdPerson() {
        return true;
    }

    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        passenger.m_146922_(this.m_146908_());
        passenger.m_5616_(this.m_6080_());
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        super.m_19956_(passenger, callback);
        passenger.m_146922_(passenger.m_146908_() + this.angle);
        passenger.m_5616_(passenger.m_6080_() + this.angle);
    }

    @Override
    @NotNull
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.equals((Object)this.m_6688_())) {
            return InteractionResult.PASS;
        }
        return super.m_6096_(player, hand);
    }

    @Override
    public void m_8119_() {
        LivingEntity livingEntity;
        super.m_8119_();
        this.launchPadTick();
        if (this.canLaunch()) {
            this.initiateLaunchSequence();
            this.showFuelMessage = false;
        } else if (this.showFuelMessage && !this.m_9236_().m_5776_() && this.passengerHasSpaceDown() && (livingEntity = this.m_6688_()) instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_5661_(ConstantComponents.NOT_ENOUGH_FUEL, true);
        }
        if (this.isLaunching()) {
            this.f_19804_.m_135381_(LAUNCH_TICKS, (Object)(this.launchTicks() - 1));
            if (this.launchTicks() <= 0) {
                this.launch();
            }
            this.spawnSmokeParticles();
        } else if (this.hasLaunched()) {
            this.flightTick();
        }
        if (!this.m_9236_().m_5776_()) {
            FluidUtils.moveItemToContainer((Container)this.inventory, (FluidContainer)this.fluidContainer, 0, 1, 0);
            FluidUtils.moveContainerToItem((Container)this.inventory, (FluidContainer)this.fluidContainer, 0, 1, 0);
            FluidHolder fluidHolder = this.fluidContainer.getFirstFluid();
            this.f_19804_.m_135381_(FUEL, (Object)fluidHolder.getFluidAmount());
            this.f_19804_.m_135381_(FUEL_TYPE, (Object)BuiltInRegistries.f_257020_.m_7981_((Object)fluidHolder.getFluid()).toString());
        }
    }

    private void launchPadTick() {
        if (this.m_9236_().m_5776_() || this.f_19797_ % 5 != 0) {
            return;
        }
        if (this.isLaunching() || this.hasLaunched()) {
            return;
        }
        BlockState state = this.m_9236_().m_8055_(this.m_20183_());
        if (!state.m_61138_(LaunchPadBlock.PART)) {
            if (this.launchpadBound) {
                this.drop();
                this.m_216990_(SoundEvents.f_12198_);
                this.m_146870_();
            }
        } else {
            this.launchpadBound = true;
            if (((Boolean)state.m_61143_((Property)LaunchPadBlock.POWERED)).booleanValue() && this.hasEnoughFuel()) {
                this.initiateLaunchSequence();
            }
        }
    }

    private void flightTick() {
        if (!this.m_9236_().m_5776_() && this.m_20186_() >= (double)AdAstraConfig.atmosphereLeave) {
            LivingEntity livingEntity = this.m_6688_();
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                if (!(player.f_36096_ instanceof PlanetsMenu)) {
                    this.openPlanetsScreen(player);
                }
            } else {
                this.explode();
            }
            return;
        }
        float xxa = -this.xxa();
        this.angle = xxa != 0.0f ? (this.angle += xxa * 1.0f) : (this.angle *= 0.9f);
        if (this.speed < 1.0f) {
            this.speed += 0.005f;
        }
        this.angle = Mth.m_14036_((float)this.angle, (float)-3.0f, (float)3.0f);
        this.m_146922_(this.m_146908_() + this.angle);
        Vec3 delta = this.m_20184_();
        this.m_20334_(delta.m_7096_(), this.speed, delta.m_7094_());
        if (this.m_9236_().m_5776_() && !this.startedRocketSound) {
            this.startedRocketSound = true;
            SoundUtils.playRocketSound(this);
        }
        this.spawnRocketParticles();
        this.burnEntitiesUnderRocket();
        if (this.isObstructed()) {
            this.explode();
        }
    }

    public boolean canLaunch() {
        if (this.isLaunching() || this.hasLaunched()) {
            return false;
        }
        if (!AdAstraConfig.launchFromAnywhere && !((Boolean)this.f_19804_.m_135370_(IS_IN_VALID_DIMENSION)).booleanValue()) {
            LivingEntity livingEntity = this.m_6688_();
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                player.m_5661_(ConstantComponents.INVALID_LAUNCHING_DIMENSION, true);
            }
            this.showFuelMessage = false;
            return false;
        }
        if (!this.hasEnoughFuel()) {
            return false;
        }
        return this.passengerHasSpaceDown();
    }

    public void initiateLaunchSequence() {
        this.f_19804_.m_135381_(IS_LAUNCHING, (Object)true);
        this.f_19804_.m_135381_(LAUNCH_TICKS, (Object)200);
        this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ModSoundEvents.ROCKET_LAUNCH.get(), SoundSource.AMBIENT, 10.0f, 1.0f);
        this.consumeFuel(false);
    }

    public void launch() {
        this.f_19804_.m_135381_(HAS_LAUNCHED, (Object)true);
        this.f_19804_.m_135381_(IS_LAUNCHING, (Object)false);
        this.f_19804_.m_135381_(LAUNCH_TICKS, (Object)-1);
    }

    public boolean isLaunching() {
        return (Boolean)this.f_19804_.m_135370_(IS_LAUNCHING);
    }

    public int launchTicks() {
        return (Integer)this.f_19804_.m_135370_(LAUNCH_TICKS);
    }

    public boolean hasLaunched() {
        return (Boolean)this.f_19804_.m_135370_(HAS_LAUNCHED);
    }

    public void spawnSmokeParticles() {
        if (!this.m_9236_().m_5776_()) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_(), this.m_20186_(), this.m_20189_(), Mth.m_216263_((RandomSource)this.m_9236_().f_46441_, (double)-0.05, (double)0.05), Mth.m_216263_((RandomSource)this.m_9236_().f_46441_, (double)-0.05, (double)0.05), Mth.m_216263_((RandomSource)this.m_9236_().f_46441_, (double)-0.05, (double)0.05));
        }
    }

    public void spawnRocketParticles() {
        int i;
        if (!this.m_9236_().m_5776_()) {
            return;
        }
        for (i = 0; i < 20; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.LARGE_FLAME.get(), this.m_20185_(), this.m_20186_() - 0.75, this.m_20189_(), Mth.m_216263_((RandomSource)this.m_9236_().f_46441_, (double)-0.05, (double)0.05), Mth.m_216263_((RandomSource)this.m_9236_().f_46441_, (double)-0.05, (double)0.05), Mth.m_216263_((RandomSource)this.m_9236_().f_46441_, (double)-0.05, (double)0.05));
        }
        for (i = 0; i < 5; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.LARGE_SMOKE.get(), this.m_20185_(), this.m_20186_() - 0.75, this.m_20189_(), Mth.m_216263_((RandomSource)this.m_9236_().f_46441_, (double)-0.05, (double)0.05), Mth.m_216263_((RandomSource)this.m_9236_().f_46441_, (double)-0.05, (double)0.05), Mth.m_216263_((RandomSource)this.m_9236_().f_46441_, (double)-0.05, (double)0.05));
        }
    }

    public void burnEntitiesUnderRocket() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        for (LivingEntity entity : this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82377_(2.0, 30.0, 2.0).m_82386_(0.0, -37.0, 0.0), e -> true)) {
            if (entity.equals((Object)this.m_6688_())) continue;
            entity.m_20254_(10);
            entity.m_6469_(ModDamageSources.create(this.m_9236_(), ModDamageSources.ROCKET_FLAMES), 10.0f);
        }
    }

    public boolean isObstructed() {
        return false;
    }

    public void explode() {
        this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)(7 + this.tier() * 2), OxygenApi.API.hasOxygen(this.m_9236_()), Level.ExplosionInteraction.TNT);
        this.m_146870_();
    }

    public boolean consumeFuel(boolean simulate) {
        if (this.m_9236_().m_5776_()) {
            return false;
        }
        long buckets = FluidConstants.fromMillibuckets((long)(this.fluidContainer.getFirstFluid().is(ModFluidTags.EFFICIENT_FUEL) ? 1000L : 3000L));
        return this.fluidContainer.extractFluid(this.fluidContainer.getFirstFluid().copyWithAmount(buckets), simulate).getFluidAmount() >= buckets;
    }

    public boolean hasEnoughFuel() {
        return this.consumeFuel(true);
    }

    @Override
    public int getInventorySize() {
        return 10;
    }

    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new RocketMenu(containerId, inventory, this);
    }

    public FluidHolder fluid() {
        return FluidHolder.of((Fluid)((Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation((String)this.f_19804_.m_135370_(FUEL_TYPE)))), (long)((Long)this.f_19804_.m_135370_(FUEL)));
    }

    public void openPlanetsScreen(ServerPlayer player) {
        MenuHooks.openMenu((ServerPlayer)player, (ExtraDataMenuProvider)new PlanetsMenuProvider());
        ClientboundStopSoundPacket packet = new ClientboundStopSoundPacket(BuiltInRegistries.f_256894_.m_7981_((Object)((SoundEvent)ModSoundEvents.ROCKET.get())), SoundSource.AMBIENT);
        player.f_8906_.m_9829_((Packet)packet);
    }

    public record RocketProperties(int tier, Item item, float ridingOffset, TagKey<Fluid> fuel) {
    }
}

