/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import earth.terrarium.ad_astra.client.screen.GuiUtil;
import earth.terrarium.ad_astra.common.config.AdAstraConfig;
import earth.terrarium.ad_astra.common.config.VehiclesConfig;
import earth.terrarium.ad_astra.common.util.ModUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class PlayerOverlayScreen {
    private static final ResourceLocation OXYGEN_TANK_EMPTY_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/overlay/oxygen_tank_empty.png");
    private static final ResourceLocation OXYGEN_TANK_FULL_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/overlay/oxygen_tank_full.png");
    private static final ResourceLocation EARTH_PLANET_BAR_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/planet_bar/earth_planet_bar.png");
    private static final ResourceLocation MOON_PLANET_BAR_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/planet_bar/moon_planet_bar.png");
    private static final ResourceLocation MARS_PLANET_BAR_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/planet_bar/mars_planet_bar.png");
    private static final ResourceLocation VENUS_PLANET_BAR_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/planet_bar/venus_planet_bar.png");
    private static final ResourceLocation MERCURY_PLANET_BAR_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/planet_bar/mercury_planet_bar.png");
    private static final ResourceLocation GLACIO_PLANET_BAR_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/planet_bar/glacio_planet_bar.png");
    private static final ResourceLocation ORBIT_PLANET_BAR_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/planet_bar/orbit_planet_bar.png");
    private static final ResourceLocation ROCKET_PLANET_BAR_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/planet_bar/rocket.png");
    private static final Component WARNING_TEXT = Component.m_237115_((String)"gui.ad_astra.text.warning");
    private static final ResourceLocation BATTERY_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/overlay/battery.png");
    private static final ResourceLocation BATTERY_EMPTY_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/overlay/battery_empty.png");
    public static boolean shouldRenderOxygen;
    public static double oxygenRatio;
    public static boolean doesNotNeedOxygen;
    public static int countdownSeconds;
    public static boolean shouldRenderBar;
    public static boolean shouldRenderWarning;
    public static double speed;
    public static boolean shouldRenderBattery;
    public static double batteryRatio;

    public static void render(GuiGraphics graphics, float delta) {
        int textWidth;
        Component text;
        int textureHeight;
        int textureWidth;
        int y;
        int x;
        PoseStack poseStack = graphics.m_280168_();
        Minecraft minecraft = Minecraft.m_91087_();
        int screenWidth = minecraft.m_91268_().m_85445_();
        int screenHeight = minecraft.m_91268_().m_85446_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        if (player.m_5833_()) {
            return;
        }
        if (shouldRenderOxygen && !minecraft.f_91066_.f_92063_) {
            poseStack.m_85836_();
            poseStack.m_85841_(AdAstraConfig.oxygenBarScale, AdAstraConfig.oxygenBarScale, AdAstraConfig.oxygenBarScale);
            x = 5 + AdAstraConfig.oxygenBarXOffset;
            y = 25 + AdAstraConfig.oxygenBarYOffset;
            textureWidth = 62;
            textureHeight = 52;
            GuiUtil.drawVerticalReverse(graphics, x, y, textureWidth, textureHeight, OXYGEN_TANK_EMPTY_TEXTURE, oxygenRatio);
            GuiUtil.drawVertical(graphics, x, y, textureWidth, textureHeight, OXYGEN_TANK_FULL_TEXTURE, oxygenRatio);
            double oxygen = (double)Math.round(oxygenRatio * 1000.0) / 10.0;
            text = Component.m_130674_((String)(oxygen + "%"));
            textWidth = minecraft.f_91062_.m_92852_((FormattedText)text);
            if (doesNotNeedOxygen) {
                graphics.m_280430_(minecraft.f_91062_, text, (int)((float)x + (float)(textureWidth - textWidth) / 2.0f), y + textureHeight + 3, 0x7FFF00);
            } else {
                graphics.m_280430_(minecraft.f_91062_, text, (int)((float)x + (float)(textureWidth - textWidth) / 2.0f), y + textureHeight + 3, oxygen <= 0.0 ? 14423100 : 0xFFFFFF);
            }
            poseStack.m_85849_();
        }
        if (shouldRenderBattery && !minecraft.f_91066_.f_92063_) {
            poseStack.m_85836_();
            poseStack.m_85841_(AdAstraConfig.energyBarScale, AdAstraConfig.energyBarScale, AdAstraConfig.energyBarScale);
            x = screenWidth - 75 - AdAstraConfig.energyBarXOffset;
            y = 25 + AdAstraConfig.energyBarYOffset;
            textureWidth = 68;
            textureHeight = 37;
            GuiUtil.drawHorizontal(graphics, x, y, textureWidth, textureHeight, BATTERY_EMPTY_TEXTURE, 1.0);
            GuiUtil.drawHorizontal(graphics, x, y, textureWidth, textureHeight, BATTERY_TEXTURE, batteryRatio);
            double energy = (double)Math.round(batteryRatio * 1000.0) / 10.0;
            text = Component.m_130674_((String)(energy + "%"));
            textWidth = minecraft.f_91062_.m_92852_((FormattedText)text);
            graphics.m_280430_(minecraft.f_91062_, text, (int)((float)x + (float)(textureWidth - textWidth) / 2.0f), y + textureHeight + 3, 6324918);
            poseStack.m_85849_();
        }
        if (countdownSeconds > 0) {
            poseStack.m_85836_();
            poseStack.m_85837_((double)((float)screenWidth / 2.0f), (double)((float)screenHeight / 2.0f), 0.0);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            poseStack.m_85836_();
            poseStack.m_85841_(4.0f, 4.0f, 4.0f);
            int m = minecraft.f_91062_.m_92895_("" + countdownSeconds);
            graphics.m_280488_(minecraft.f_91062_, "" + countdownSeconds, -m / 2, -10, 15020627);
            poseStack.m_85849_();
            RenderSystem.disableBlend();
            poseStack.m_85849_();
        }
        if (shouldRenderBar && !minecraft.f_91066_.f_92063_) {
            float rocketHeight = (float)(player.m_20186_() / (double)((float)VehiclesConfig.RocketConfig.atmosphereLeave / 113.0f));
            rocketHeight = Mth.m_14036_((float)rocketHeight, (float)0.0f, (float)113.0f);
            int x2 = 0;
            int y2 = screenHeight / 2 - 64;
            ResourceKey currentWorld = player.m_9236_().m_46472_();
            ResourceLocation planet = currentWorld.equals(Level.f_46428_) ? EARTH_PLANET_BAR_TEXTURE : (currentWorld.equals(ModUtils.MOON_KEY) ? MOON_PLANET_BAR_TEXTURE : (currentWorld.equals(ModUtils.MARS_KEY) ? MARS_PLANET_BAR_TEXTURE : (currentWorld.equals(ModUtils.VENUS_KEY) ? VENUS_PLANET_BAR_TEXTURE : (currentWorld.equals(ModUtils.MERCURY_KEY) ? MERCURY_PLANET_BAR_TEXTURE : (currentWorld.equals(ModUtils.GLACIO_KEY) ? GLACIO_PLANET_BAR_TEXTURE : ORBIT_PLANET_BAR_TEXTURE)))));
            graphics.m_280163_(planet, x2, y2, 0.0f, 0.0f, 16, 128, 16, 128);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ROCKET_PLANET_BAR_TEXTURE);
            GuiUtil.FloatGuiComponent.drawTexture(graphics, 4.0f, (float)screenHeight / 2.0f + 51.5f - rocketHeight, 0.0f, 0.0f, 8, 11, 8, 11);
        }
        if (shouldRenderWarning) {
            poseStack.m_85836_();
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::m_172817_);
            float sine = (float)Math.sin(((float)minecraft.f_91073_.m_46467_() + (minecraft.m_91104_() ? 0.0f : minecraft.m_91296_())) / 5.0f);
            sine = Mth.m_14036_((float)sine, (float)0.0f, (float)1.0f);
            RenderSystem.setShaderColor((float)sine, (float)sine, (float)sine, (float)sine);
            poseStack.m_85836_();
            poseStack.m_85837_((double)((float)screenWidth / 2.0f), (double)((float)screenHeight / 2.0f / 1.5f), 0.0);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            poseStack.m_85836_();
            poseStack.m_85841_(4.0f, 4.0f, 4.0f);
            int m = minecraft.f_91062_.m_92852_((FormattedText)WARNING_TEXT);
            graphics.m_280430_(minecraft.f_91062_, WARNING_TEXT, -m / 2, -10, FastColor.ARGB32.m_13660_((int)((int)(sine * 255.0f)), (int)((int)(sine * 255.0f)), (int)((int)(sine * 255.0f)), (int)((int)(sine * 255.0f))));
            poseStack.m_85849_();
            RenderSystem.disableBlend();
            poseStack.m_85849_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void disableAllOverlays() {
        shouldRenderOxygen = false;
        shouldRenderBattery = false;
        shouldRenderBar = false;
        shouldRenderWarning = false;
    }

    public static void disableAllVehicleOverlays() {
        shouldRenderBar = false;
        countdownSeconds = 0;
        shouldRenderWarning = false;
    }
}

