/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.screen.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import com.teamresourceful.resourcefullib.common.color.Color;
import earth.terrarium.ad_astra.client.screen.util.PlanetSelectionScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ScreenUtils {
    public static Component createText(String text) {
        return Component.m_237115_((String)("gui.ad_astra.text." + text));
    }

    public static Component createText(ResourceLocation text) {
        return Component.m_237115_((String)("gui." + text.m_135827_() + ".text." + text.m_135815_()));
    }

    public static void addTexture(GuiGraphics graphics, int x, int y, int width, int height, ResourceLocation texture) {
        graphics.m_280163_(texture, x, y, 0.0f, 0.0f, width, height, width, height);
    }

    public static void addRotatingTexture(PlanetSelectionScreen screen, GuiGraphics graphics, int x, int y, int width, int height, ResourceLocation texture, float speed) {
        double scale = (double)Minecraft.m_91087_().m_91268_().m_85446_() / 400.0;
        x = (int)((double)x * scale);
        y = (int)((double)y * scale);
        ++x;
        ++y;
        width = (int)((double)width * scale);
        height = (int)((double)height * scale);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)screen.f_96543_ / 2.0f, (float)screen.f_96544_ / 2.0f, 0.0f);
        graphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(screen.getGuiTime() * (speed / 3.0f)));
        ScreenUtils.addTexture(graphics, x, y, width, height, texture);
        graphics.m_280168_().m_85849_();
    }

    public static void drawCircle(double x, double y, double radius, int sides, Color ringColour) {
        double width;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        double scale = (double)Minecraft.m_91087_().m_91268_().m_85446_() / 400.0;
        for (double i = width = (radius *= scale) - 0.6; i < radius - 0.5 + 1.0; i += 0.1) {
            bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
            for (int j = 0; j <= sides; ++j) {
                double angle = Math.PI * 2 * (double)j / (double)sides + Math.toRadians(180.0);
                bufferBuilder.m_5483_(x + Math.sin(angle) * i, y + Math.cos(angle) * i, 0.0).m_6122_(ringColour.getIntRed(), ringColour.getIntGreen(), ringColour.getIntBlue(), ringColour.getIntAlpha()).m_5752_();
            }
            tessellator.m_85914_();
        }
    }

    public static void drawLine(int x1, int x2, int y1, int y2, int colour) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_5483_((double)x1, (double)y1, 0.0).m_85950_((float)(colour >> 16 & 0xFF) / 255.0f, (float)(colour >> 8 & 0xFF) / 255.0f, (float)(colour & 0xFF) / 255.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_((double)x2, (double)y2, 0.0).m_85950_((float)(colour >> 16 & 0xFF) / 255.0f, (float)(colour >> 8 & 0xFF) / 255.0f, (float)(colour & 0xFF) / 255.0f, 1.0f).m_5752_();
        tessellator.m_85914_();
    }
}

