/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.block.machine;

import com.teamresourceful.resourcefullib.common.caches.CacheableFunction;
import com.teamresourceful.resourcefullib.common.registry.RegistryEntry;
import earth.terrarium.ad_astra.common.block.machine.entity.AbstractMachineBlockEntity;
import earth.terrarium.ad_astra.common.block.machine.entity.FluidMachineBlockEntity;
import earth.terrarium.ad_astra.common.block.machine.entity.OxygenDistributorBlockEntity;
import earth.terrarium.ad_astra.common.registry.ModBlockEntityTypes;
import earth.terrarium.ad_astra.common.registry.ModTags;
import earth.terrarium.botarium.common.energy.base.PlatformEnergyManager;
import earth.terrarium.botarium.common.energy.util.EnergyHooks;
import earth.terrarium.botarium.common.menu.ExtraDataMenuProvider;
import earth.terrarium.botarium.common.menu.MenuHooks;
import java.util.Optional;
import java.util.function.ToIntFunction;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

@MethodsReturnNonnullByDefault
public abstract class AbstractMachineBlock
extends BaseEntityBlock {
    private static final CacheableFunction<Block, BlockEntityType<?>> BLOCK_TO_ENTITY = new CacheableFunction(block -> ModBlockEntityTypes.BLOCK_ENTITY_TYPES.getEntries().stream().map(RegistryEntry::get).filter(type -> type.m_155262_(block.m_49966_())).findFirst().orElse(null));
    private BlockEntityType<?> entity;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public AbstractMachineBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60953_(AbstractMachineBlock.getLuminance()));
        this.m_49959_(this.buildDefaultState());
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (this.entity == null) {
            this.entity = (BlockEntityType)BLOCK_TO_ENTITY.apply((Object)state.m_60734_());
        }
        return this.entity.m_155264_(pos, state);
    }

    private static ToIntFunction<BlockState> getLuminance() {
        return blockState -> blockState.m_61138_((Property)LIT) ? (((Boolean)blockState.m_61143_((Property)LIT)).booleanValue() ? ((AbstractMachineBlock)blockState.m_60734_()).getBrightness() : 0) : 0;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return (entityWorld, pos, entityState, blockEntity) -> {
            if (blockEntity instanceof AbstractMachineBlockEntity) {
                AbstractMachineBlockEntity machine = (AbstractMachineBlockEntity)blockEntity;
                machine.tick();
            }
        };
    }

    protected BlockState buildDefaultState() {
        BlockState state = (BlockState)this.f_49792_.m_61090_();
        state = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
        if (this.useFacing()) {
            state = (BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.NORTH);
        }
        if (this.useLit()) {
            state = (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    protected boolean useFacing() {
        return false;
    }

    protected boolean useLit() {
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        ItemStack item = player.m_21120_(hand);
        if (item.m_204117_(ModTags.WRENCHES) && this.useFacing()) {
            level.m_7731_(pos, this.m_6843_(state, Rotation.CLOCKWISE_90), 3);
            return InteractionResult.SUCCESS;
        }
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof AbstractMachineBlockEntity) {
            AbstractMachineBlockEntity machineBlock = (AbstractMachineBlockEntity)blockEntity;
            MenuHooks.openMenu((ServerPlayer)((ServerPlayer)player), (ExtraDataMenuProvider)machineBlock);
        }
        return InteractionResult.SUCCESS;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        if (this.useFacing()) {
            return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
        }
        return state;
    }

    public int getBrightness() {
        return 12;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60734_() != newState.m_60734_()) {
            AbstractMachineBlockEntity machineBlock;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof AbstractMachineBlockEntity && (machineBlock = (AbstractMachineBlockEntity)blockEntity).getInventorySize() > 0) {
                if (this.removeOutput()) {
                    machineBlock.m_8016_(machineBlock.getInventorySize() - 1);
                }
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)machineBlock);
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, moved);
        }
    }

    public boolean removeOutput() {
        return false;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        if (this.useFacing()) {
            builder.m_61104_(new Property[]{FACING});
        }
        builder.m_61104_(new Property[]{POWERED});
        if (this.useLit()) {
            builder.m_61104_(new Property[]{LIT});
        }
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
        return this.useFacing() ? (BlockState)state.m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_()) : state;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean doRedstoneCheck() {
        return true;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        super.m_6861_(state, level, pos, block, fromPos, notify);
        if (this.doRedstoneCheck() && !level.f_46443_) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(level.m_276867_(pos))));
        }
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        return blockEntity instanceof AbstractMachineBlockEntity ? AbstractContainerMenu.m_38918_((BlockEntity)blockEntity) : 0;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        ItemStack stack = super.m_7397_(level, pos, state);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AbstractMachineBlockEntity) {
            AbstractMachineBlockEntity machineBlock = (AbstractMachineBlockEntity)blockEntity;
            CompoundTag tag = stack.m_41784_();
            ContainerHelper.m_18973_((CompoundTag)tag, machineBlock.getItems());
            Optional platformEnergyManager = EnergyHooks.safeGetBlockEnergyManager((BlockEntity)machineBlock, null);
            platformEnergyManager.ifPresent(energyManager -> tag.m_128356_("Energy", ((PlatformEnergyManager)platformEnergyManager.get()).getStoredEnergy()));
            if (machineBlock instanceof FluidMachineBlockEntity) {
                FluidMachineBlockEntity fluidMachine = (FluidMachineBlockEntity)machineBlock;
                tag.m_128365_("InputFluid", (Tag)fluidMachine.getInputTank().serialize());
                tag.m_128365_("OutputFluid", (Tag)fluidMachine.getOutputTank().serialize());
                if (machineBlock instanceof OxygenDistributorBlockEntity) {
                    OxygenDistributorBlockEntity oxygenDistributorMachine = (OxygenDistributorBlockEntity)machineBlock;
                    tag.m_128379_("ShowOxygen", oxygenDistributorMachine.shouldShowOxygen());
                }
            }
        }
        return stack;
    }
}

