/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.block.machine.entity;

import earth.terrarium.ad_astra.common.block.machine.entity.ProcessingMachineBlockEntity;
import earth.terrarium.ad_astra.common.config.CoalGeneratorConfig;
import earth.terrarium.ad_astra.common.registry.ModBlockEntityTypes;
import earth.terrarium.ad_astra.common.screen.menu.CoalGeneratorMenu;
import earth.terrarium.botarium.common.energy.base.BotariumEnergyBlock;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.ExtractOnlyEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import earth.terrarium.botarium.common.energy.util.EnergyHooks;
import earth.terrarium.botarium.util.CommonHooks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoalGeneratorBlockEntity
extends ProcessingMachineBlockEntity
implements BotariumEnergyBlock<WrappedBlockEnergyContainer> {
    private WrappedBlockEnergyContainer energyContainer;

    public CoalGeneratorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntityTypes.COAL_GENERATOR.get(), blockPos, blockState);
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, @NotNull Inventory inv, @NotNull Player player) {
        return new CoalGeneratorMenu(syncId, inv, this);
    }

    @Override
    public int getInventorySize() {
        return 1;
    }

    @Override
    public boolean m_7155_(int slot, ItemStack stack, Direction dir) {
        return slot == 0;
    }

    @Override
    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return false;
    }

    @Override
    public void tick() {
        if (!this.f_58857_.m_5776_()) {
            ItemStack input = (ItemStack)this.getItems().get(0);
            if (this.cookTime > 0) {
                --this.cookTime;
                this.getEnergyStorage().internalInsert(this.getEnergyPerTick(), false);
                this.setActive(true);
            } else if (this.getEnergyStorage().internalInsert(this.getEnergyPerTick(), true) > 0L && !input.m_41619_() && !(input.m_41720_() instanceof BucketItem)) {
                int burnTime = Math.min(20000, CommonHooks.getBurnTime((ItemStack)input));
                if (burnTime > 0) {
                    input.m_41774_(1);
                    this.cookTimeTotal = burnTime;
                    this.cookTime = burnTime;
                }
            } else {
                this.setActive(false);
            }
            EnergyHooks.distributeEnergyNearby((BlockEntity)this, (long)this.getEnergyPerTick());
        }
    }

    public long getEnergyPerTick() {
        return CoalGeneratorConfig.energyPerTick;
    }

    public long getMaxCapacity() {
        return this.getEnergyStorage().getMaxCapacity();
    }

    public WrappedBlockEnergyContainer getEnergyStorage() {
        return this.energyContainer == null ? (this.energyContainer = new WrappedBlockEnergyContainer((BlockEntity)this, (EnergyContainer)new ExtractOnlyEnergyContainer(CoalGeneratorConfig.maxEnergy))) : this.energyContainer;
    }
}

