/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.block.machine.entity;

import earth.terrarium.ad_astra.common.block.machine.entity.AbstractMachineBlockEntity;
import earth.terrarium.ad_astra.common.config.CryoFreezerConfig;
import earth.terrarium.ad_astra.common.recipe.CryoFuelConversionRecipe;
import earth.terrarium.ad_astra.common.registry.ModBlockEntityTypes;
import earth.terrarium.ad_astra.common.screen.menu.CryoFreezerMenu;
import earth.terrarium.ad_astra.common.util.FluidUtils;
import earth.terrarium.botarium.common.energy.base.BotariumEnergyBlock;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.InsertOnlyEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import earth.terrarium.botarium.common.fluid.base.BotariumFluidBlock;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.impl.ExtractOnlyFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.WrappedBlockFluidContainer;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CryoFreezerBlockEntity
extends AbstractMachineBlockEntity
implements BotariumFluidBlock<WrappedBlockFluidContainer>,
BotariumEnergyBlock<WrappedBlockEnergyContainer> {
    private WrappedBlockEnergyContainer energyContainer;
    protected int cookTime;
    protected int cookTimeTotal;
    protected ItemStack inputStack = ItemStack.f_41583_;
    @Nullable
    protected Fluid outputFluid;
    private WrappedBlockFluidContainer tank;

    public CryoFreezerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntityTypes.CRYO_FREEZER.get(), blockPos, blockState);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.cookTime = nbt.m_128451_("CookTime");
        this.cookTimeTotal = nbt.m_128451_("CookTimeTotal");
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("CookTime", this.cookTime);
        nbt.m_128405_("CookTimeTotal", this.cookTimeTotal);
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public int getCookTimeTotal() {
        return this.cookTimeTotal;
    }

    public void finishCooking() {
        CryoFuelConversionRecipe recipe;
        if (this.outputFluid != null && (recipe = this.createRecipe(this.m_8020_(0), false)) != null) {
            FluidHolder outputFluid = FluidHooks.newFluidHolder((Fluid)recipe.getFluidOutput(), (long)((long)((double)FluidHooks.buckets((double)1.0) * recipe.getConversionRatio())), null);
            this.getFluidContainer().internalInsert(outputFluid, false);
        }
        this.stopCooking();
    }

    public void stopCooking() {
        this.cookTime = 0;
        this.cookTimeTotal = 0;
        this.outputFluid = null;
        this.inputStack = ItemStack.f_41583_;
        this.m_6596_();
    }

    @Override
    public int getInventorySize() {
        return 3;
    }

    @Override
    public boolean m_7155_(int slot, ItemStack stack, Direction dir) {
        return slot == 0;
    }

    @Override
    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return slot == 2;
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, @NotNull Inventory inv, @NotNull Player player) {
        return new CryoFreezerMenu(syncId, inv, this);
    }

    public CryoFuelConversionRecipe createRecipe(ItemStack testStack, boolean checkOutput) {
        this.stopCooking();
        CryoFuelConversionRecipe recipe = CryoFuelConversionRecipe.findFirst(this.f_58857_, f -> f.test(testStack));
        if (recipe != null) {
            if (checkOutput) {
                ItemStack outputSlot = this.m_8020_(1);
                ItemStack output = recipe.m_8043_(this.f_58857_.m_9598_());
                if (!outputSlot.m_41619_() && !outputSlot.m_41720_().equals(recipe.m_8043_(this.f_58857_.m_9598_()).m_41720_()) || outputSlot.m_41613_() + output.m_41613_() > outputSlot.m_41741_()) {
                    return null;
                }
            }
            this.outputFluid = recipe.getFluidOutput();
            this.inputStack = testStack;
        }
        return recipe;
    }

    @Override
    public void tick() {
        if (!this.m_58904_().f_46443_) {
            ItemStack input = this.m_8020_(0);
            ItemStack outputInsertSlot = this.m_8020_(1);
            ItemStack outputExtractSlot = this.m_8020_(2);
            if (!outputInsertSlot.m_41619_() && outputExtractSlot.m_41613_() < outputExtractSlot.m_41741_()) {
                FluidUtils.extractTankFluidToItem((FluidContainer)this.getFluidContainer(), this, 1, 2, 0, f -> true);
            }
            if (this.getEnergyStorage().internalExtract(this.getEnergyPerTick(), true) > 0L) {
                if (!input.m_41619_() && (ItemStack.m_41656_((ItemStack)input, (ItemStack)this.inputStack) || this.inputStack.m_41619_()) && ((FluidHolder)this.getFluidContainer().getFluids().get(0)).getFluidAmount() < this.getFluidContainer().getTankCapacity(0)) {
                    if (this.cookTime < this.cookTimeTotal) {
                        ++this.cookTime;
                        this.getEnergyStorage().internalExtract(this.getEnergyPerTick(), false);
                        this.setActive(true);
                    } else if (this.outputFluid != null) {
                        this.finishCooking();
                        input.m_41774_(1);
                    } else {
                        CryoFuelConversionRecipe recipe = this.createRecipe(input, false);
                        if (recipe != null) {
                            this.cookTimeTotal = 25;
                            this.cookTime = 0;
                        }
                    }
                } else if (this.outputFluid != null) {
                    this.stopCooking();
                    this.setActive(false);
                } else {
                    this.setActive(false);
                }
            }
        }
    }

    public long getEnergyPerTick() {
        return CryoFreezerConfig.energyPerTick;
    }

    public long getMaxCapacity() {
        return this.getEnergyStorage().getMaxCapacity();
    }

    public WrappedBlockEnergyContainer getEnergyStorage() {
        return this.energyContainer == null ? (this.energyContainer = new WrappedBlockEnergyContainer((BlockEntity)this, (EnergyContainer)new InsertOnlyEnergyContainer(CryoFreezerConfig.maxEnergy))) : this.energyContainer;
    }

    public WrappedBlockFluidContainer getFluidContainer() {
        return this.tank == null ? (this.tank = new WrappedBlockFluidContainer((BlockEntity)this, (FluidContainer)new ExtractOnlyFluidContainer(i -> CryoFreezerConfig.tankSize, 1, (amount, fluid) -> true))) : this.tank;
    }
}

