/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.block.machine.entity;

import earth.terrarium.ad_astra.common.block.machine.AbstractMachineBlock;
import earth.terrarium.ad_astra.common.block.machine.EnergizerBlock;
import earth.terrarium.ad_astra.common.block.machine.entity.AbstractMachineBlockEntity;
import earth.terrarium.ad_astra.common.config.EnergizerConfig;
import earth.terrarium.ad_astra.common.registry.ModBlockEntityTypes;
import earth.terrarium.ad_astra.common.util.ModUtils;
import earth.terrarium.botarium.common.energy.base.BotariumEnergyBlock;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.SimpleEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import earth.terrarium.botarium.common.energy.util.EnergyHooks;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class EnergizerBlockEntity
extends AbstractMachineBlockEntity
implements BotariumEnergyBlock<WrappedBlockEnergyContainer> {
    private WrappedBlockEnergyContainer energyContainer;

    public EnergizerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntityTypes.ENERGIZER.get(), blockPos, blockState);
    }

    @Override
    public int getInventorySize() {
        return 1;
    }

    @Override
    public boolean m_7155_(int slot, ItemStack stack, Direction dir) {
        return slot == 0;
    }

    @Override
    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return slot == 0;
    }

    @Override
    public void tick() {
        if (!this.m_58904_().m_5776_()) {
            if (!((Boolean)this.m_58900_().m_61143_((Property)AbstractMachineBlock.POWERED)).booleanValue()) {
                ItemStackHolder stack = new ItemStackHolder(this.m_8020_(0));
                this.setActive(true);
                if (!stack.getStack().m_41619_()) {
                    long moved;
                    if (this.getEnergyStorage().internalExtract(this.getEnergyPerTick(), true) > 0L && (moved = EnergyHooks.safeMoveBlockToItemEnergy((BlockEntity)this, null, (ItemStackHolder)stack, (long)this.getEnergyPerTick())) > 0L) {
                        if (stack.isDirty()) {
                            this.m_6836_(0, stack.getStack());
                        }
                        BlockPos pos = this.m_58899_();
                        ModUtils.spawnForcedParticles((ServerLevel)this.f_58857_, ParticleTypes.f_175830_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.8, (double)pos.m_123343_() + 0.5, 2, 0.1, 0.1, 0.1, 0.1);
                    }
                } else {
                    this.setActive(false);
                }
            }
            float ratio = (float)this.getEnergyStorage().getStoredEnergy() / (float)this.getMaxCapacity();
            int level = (int)(ratio * 4.0f);
            if (ratio > 2.0E-4f) {
                ++level;
            }
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)EnergizerBlock.POWER, (Comparable)Integer.valueOf(level)));
            EnergyHooks.distributeEnergyNearby((BlockEntity)this, (long)this.getEnergyPerTick());
        }
    }

    public long getEnergyPerTick() {
        return EnergizerConfig.energyPerTick;
    }

    public long getMaxCapacity() {
        return this.getEnergyStorage().getMaxCapacity();
    }

    public WrappedBlockEnergyContainer getEnergyStorage() {
        return this.energyContainer == null ? (this.energyContainer = new WrappedBlockEnergyContainer((BlockEntity)this, (EnergyContainer)new SimpleEnergyContainer(EnergizerConfig.maxEnergy))) : this.energyContainer;
    }
}

