/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.compat.jei.category;

import earth.terrarium.ad_astra.client.ClientPlatformUtils;
import earth.terrarium.ad_astra.client.screen.GuiUtil;
import earth.terrarium.ad_astra.common.compat.jei.EnergyBarDrawable;
import earth.terrarium.ad_astra.common.compat.jei.FluidBarDrawable;
import earth.terrarium.ad_astra.common.compat.jei.category.BaseCategory;
import earth.terrarium.ad_astra.common.config.CryoFreezerConfig;
import earth.terrarium.ad_astra.common.recipe.CryoFuelConversionRecipe;
import earth.terrarium.ad_astra.common.registry.ModItems;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

public class CryoFuelConversionCategory
extends BaseCategory<CryoFuelConversionRecipe> {
    public static final ResourceLocation ID = new ResourceLocation("ad_astra", "cryo_fuel_conversion");
    public static final RecipeType<CryoFuelConversionRecipe> RECIPE = new RecipeType(ID, CryoFuelConversionRecipe.class);
    private final IDrawable slot;
    private final IDrawableAnimated arrow;

    public CryoFuelConversionCategory(IGuiHelper guiHelper) {
        super(guiHelper, RECIPE, (Component)Component.m_237115_((String)((Item)ModItems.CRYO_FREEZER.get()).m_5524_()), (IDrawable)guiHelper.createBlankDrawable(144, 90), guiHelper.createDrawableItemStack(((Item)ModItems.CRYO_FREEZER.get()).m_7968_()));
        this.slot = guiHelper.getSlotDrawable();
        this.arrow = guiHelper.drawableBuilder(GuiUtil.ARROW_TEXTURE, 0, 0, 24, 17).setTextureSize(24, 17).buildAnimated(100, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CryoFuelConversionRecipe recipe, IFocusGroup focuses) {
        builder.addInvisibleIngredients(RecipeIngredientRole.CATALYST).addIngredients(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CRYO_FREEZER.get()}));
        builder.addSlot(RecipeIngredientRole.INPUT, 11, 31).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addFluidStack(recipe.getFluidOutput(), FluidHooks.buckets((double)1.0));
    }

    public void draw(CryoFuelConversionRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.slot.draw(graphics, 10, 30);
        new FluidBarDrawable(FluidHooks.newFluidHolder((Fluid)recipe.getFluidOutput(), (long)FluidHooks.buckets((double)1.0), null), true, 10000).draw(graphics, 80, 15);
        new EnergyBarDrawable(false, 10000).draw(graphics, 120, 15);
        this.arrow.draw(graphics, 35, 30);
        MutableComponent ratioText = Component.m_237110_((String)"rei.text.ad_astra.amount", (Object[])new Object[]{1000.0 * recipe.getConversionRatio()});
        Font font = Minecraft.m_91087_().f_91062_;
        graphics.m_280430_(font, (Component)ratioText, (int)(70.0f - (float)font.m_92852_((FormattedText)ratioText) / 2.0f), 80, 0x404040);
    }

    public List<Component> getTooltipStrings(CryoFuelConversionRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        if (mouseX > 118.0 && mouseY > 13.0 && mouseX < 131.0 && mouseY < 59.0) {
            tooltips.add((Component)Component.m_237110_((String)"rei.tooltip.ad_astra.energy_using", (Object[])new Object[]{CryoFreezerConfig.energyPerTick}));
        }
        if (mouseX > 80.0 && mouseY > 13.0 && mouseX < 94.0 && mouseY < 61.0) {
            tooltips.add(ClientPlatformUtils.getFluidTranslation(recipe.getFluidOutput()));
        }
        return tooltips;
    }
}

