/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.entity.system;

import earth.terrarium.ad_astra.common.config.AdAstraConfig;
import earth.terrarium.ad_astra.common.entity.system.EntityOxygenStatus;
import earth.terrarium.ad_astra.common.item.armor.SpaceSuit;
import earth.terrarium.ad_astra.common.registry.ModDamageSources;
import earth.terrarium.ad_astra.common.registry.ModTags;
import earth.terrarium.ad_astra.common.util.ModUtils;
import earth.terrarium.ad_astra.common.util.OxygenUtils;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class EntityOxygenSystem {
    @NotNull
    public static EntityOxygenStatus getOxygenStatus(LivingEntity entity, Level level) {
        boolean hasOxygenatedSpaceSuit;
        if (!AdAstraConfig.doOxygen) {
            return EntityOxygenStatus.IGNORE;
        }
        if (entity.m_21222_()) {
            return EntityOxygenStatus.IGNORE;
        }
        if (ModUtils.checkTag((Entity)entity, ModTags.LIVES_WITHOUT_OXYGEN)) {
            return EntityOxygenStatus.IGNORE;
        }
        if (OxygenUtils.levelHasOxygen(level) && !entity.m_5842_()) {
            return EntityOxygenStatus.IGNORE;
        }
        boolean entityHasOxygen = OxygenUtils.entityHasOxygen(level, entity);
        boolean bl = hasOxygenatedSpaceSuit = SpaceSuit.hasOxygenatedSpaceSuit(entity) && SpaceSuit.hasFullSet(entity);
        if (entityHasOxygen && hasOxygenatedSpaceSuit && entity.m_5842_() && !entity.m_6040_() && !entity.m_21023_(MobEffects.f_19608_)) {
            return EntityOxygenStatus.CONSUME;
        }
        if (!entityHasOxygen) {
            if (hasOxygenatedSpaceSuit) {
                return EntityOxygenStatus.CONSUME;
            }
            if (!ModUtils.armourIsOxygenated(entity)) {
                return EntityOxygenStatus.DAMAGE;
            }
        }
        return EntityOxygenStatus.IGNORE;
    }

    public static void oxygenTick(LivingEntity entity, ServerLevel level) {
        EntityOxygenStatus status = EntityOxygenSystem.getOxygenStatus(entity, (Level)level);
        if (status == EntityOxygenStatus.CONSUME) {
            EntityOxygenSystem.consumeOxygen(entity);
        } else if (status == EntityOxygenStatus.DAMAGE) {
            entity.m_6469_(ModDamageSources.of((Level)level, ModDamageSources.OXYGEN), (float)AdAstraConfig.oxygenDamage);
            entity.m_20301_(-40);
        }
    }

    private static void consumeOxygen(LivingEntity entity) {
        if (entity.m_9236_().m_46467_() % 3L == 0L) {
            entity.m_20301_(Math.min(entity.m_6062_(), entity.m_20146_() + 40));
            SpaceSuit.consumeSpaceSuitOxygen(entity, FluidHooks.buckets((double)1.0) / 1000L);
        }
    }
}

