/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.entity.vehicle;

import earth.terrarium.ad_astra.common.config.VehiclesConfig;
import earth.terrarium.ad_astra.common.entity.vehicle.Vehicle;
import earth.terrarium.ad_astra.common.registry.ModItems;
import earth.terrarium.ad_astra.common.screen.LargeVehicleMenuProvider;
import earth.terrarium.ad_astra.common.util.ModKeyBindings;
import earth.terrarium.ad_astra.common.util.ModUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Rover
extends Vehicle {
    protected static final EntityDataAccessor<Float> TURN_SPEED = SynchedEntityData.m_135353_(Rover.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public double wheelPitch;
    public double prevWheelPitch;

    public Rover(EntityType<?> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
    }

    @Override
    public int getInventorySize() {
        return 18;
    }

    @Override
    public void openInventory(Player player) {
        this.openInventory(player, new LargeVehicleMenuProvider(this));
    }

    @Override
    public long getTankSize() {
        return VehiclesConfig.RoverConfig.tankSize;
    }

    @Override
    public long getFuelPerTick() {
        return VehiclesConfig.RoverConfig.fuelPerSecond;
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        super.m_6096_(player, hand);
        this.openInventory(player);
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TURN_SPEED, (Object)Float.valueOf(0.0f));
    }

    @Override
    public double m_6048_() {
        super.m_6048_();
        return super.m_6048_() + (double)0.6f;
    }

    @Override
    public ItemStack getDropStack() {
        return ((Item)ModItems.TIER_1_ROVER.get()).m_7968_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.travel();
        if (VehiclesConfig.RoverConfig.explodeRoverInLava && this.m_204029_(FluidTags.f_13132_)) {
            this.explode(0.35f);
        }
    }

    public void m_19890_(double x, double y, double z, float yaw, float pitch) {
        super.m_19890_(x, y, z, yaw, pitch);
    }

    private void travel() {
        this.prevWheelPitch = this.wheelPitch;
        this.previousYaw = this.m_146908_();
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.getTankHolder().getFluidAmount() > 0L) {
                boolean shouldConsumeFuel = false;
                if (ModKeyBindings.forwardKeyDown(player)) {
                    shouldConsumeFuel = true;
                    this.setSpeed(this.getSpeed() + 0.1f);
                }
                if (ModKeyBindings.backKeyDown(player)) {
                    shouldConsumeFuel = true;
                    this.setSpeed(this.getSpeed() + (this.m_20069_() || this.m_20077_() ? -0.01f : -0.05f));
                }
                if (ModKeyBindings.leftKeyDown(player)) {
                    this.setTurnSpeed(this.getTurnSpeed() - VehiclesConfig.RoverConfig.turnSpeed * this.getSpeed());
                    this.m_20256_(new Vec3(this.m_20184_().m_7096_() / 1.1, this.m_20184_().m_7098_(), this.m_20184_().m_7094_() / 1.1));
                }
                if (ModKeyBindings.rightKeyDown(player)) {
                    this.setTurnSpeed(this.getTurnSpeed() + VehiclesConfig.RoverConfig.turnSpeed * this.getSpeed());
                    this.m_20256_(new Vec3(this.m_20184_().m_7096_() / 1.1, this.m_20184_().m_7098_(), this.m_20184_().m_7094_() / 1.1));
                }
                if (shouldConsumeFuel) {
                    this.consumeFuel();
                }
            }
        }
        this.setTurnSpeed(Mth.m_14036_((float)this.getTurnSpeed(), (float)(-VehiclesConfig.RoverConfig.maxTurnSpeed), (float)VehiclesConfig.RoverConfig.maxTurnSpeed));
        this.setTurnSpeed(this.getTurnSpeed() * VehiclesConfig.RoverConfig.deceleration);
        if ((double)this.getTurnSpeed() < 0.1 && (double)this.getTurnSpeed() > -0.1) {
            this.setTurnSpeed(0.0f);
        }
        ModUtils.rotateVehicleYaw(this, this.m_146908_() + this.getTurnSpeed());
        for (Entity passenger : this.m_20197_()) {
            passenger.m_146922_(passenger.m_146908_() + this.getTurnSpeed());
        }
        this.wheelPitch += (double)(this.getSpeed() * 7.0f);
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction positionUpdater) {
        this.copyEntityData(passenger);
        if (!this.m_20363_(passenger)) {
            return;
        }
        double d = this.m_20186_() + this.m_6048_() + passenger.m_6049_();
        if (passenger.equals((Object)this.m_146895_())) {
            double xRotator = Math.cos((double)(this.m_146908_() - 50.0f) * Math.PI / 180.0) * (double)0.85f;
            double zRotator = Math.sin((double)(this.m_146908_() - 50.0f) * Math.PI / 180.0) * (double)0.85f;
            positionUpdater.m_20372_(passenger, this.m_20185_() + xRotator, d, this.m_20189_() + zRotator);
        } else {
            double xRotator = Math.cos((double)(this.m_146908_() + 50.0f) * Math.PI / 180.0) * (double)-0.85f;
            double zRotator = Math.sin((double)(this.m_146908_() + 50.0f) * Math.PI / 180.0) * (double)-0.85f;
            positionUpdater.m_20372_(passenger, this.m_20185_() + xRotator, d, this.m_20189_() + zRotator);
        }
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        Vec3 pos = passenger.m_20182_();
        if (this.m_20197_().size() == 0) {
            double xRotator = Math.cos((double)this.m_146908_() * Math.PI / 180.0) * (double)0.9f;
            double zRotator = Math.sin((double)this.m_146908_() * Math.PI / 180.0) * (double)0.9f;
            passenger.m_20256_(this.m_20184_());
            return new Vec3(pos.m_7096_() + xRotator, pos.m_7098_(), pos.m_7094_() + zRotator);
        }
        double xRotator = Math.cos((double)this.m_146908_() * Math.PI / 180.0) * -1.0;
        double zRotator = Math.sin((double)this.m_146908_() * Math.PI / 180.0) * -1.0;
        passenger.m_20256_(this.m_20184_());
        return new Vec3(pos.m_7096_() + xRotator, pos.m_7098_(), pos.m_7094_() + zRotator);
    }

    @Override
    public int getMaxPassengers() {
        return 2;
    }

    @Override
    public float getMinSpeed() {
        return VehiclesConfig.RoverConfig.minSpeed;
    }

    @Override
    public float getMaxSpeed() {
        return VehiclesConfig.RoverConfig.maxSpeed;
    }

    public float getTurnSpeed() {
        return ((Float)this.f_19804_.m_135370_(TURN_SPEED)).floatValue();
    }

    public void setTurnSpeed(float value) {
        this.f_19804_.m_135381_(TURN_SPEED, (Object)Float.valueOf(value));
    }

    protected void copyEntityData(Entity entity) {
        entity.m_5618_(this.m_146908_());
        float deg = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
        float lookAroundFreedom = Mth.m_14036_((float)deg, (float)-105.0f, (float)105.0f);
        entity.f_19859_ += lookAroundFreedom - deg;
        entity.m_146922_(entity.m_146908_() + lookAroundFreedom - deg);
        entity.m_5616_(entity.m_146908_());
    }

    public void m_7340_(Entity passenger) {
        this.copyEntityData(passenger);
    }
}

