/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.networking.packet.messages;

import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import earth.terrarium.ad_astra.common.recipe.SpaceStationRecipe;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public record ServerboundCreateSpaceStationPacket(ResourceLocation targetWorld) implements Packet<ServerboundCreateSpaceStationPacket>
{
    public static final ResourceLocation ID = new ResourceLocation("ad_astra", "create_space_station");
    public static final Handler HANDLER = new Handler();

    public ResourceLocation getID() {
        return ID;
    }

    public PacketHandler<ServerboundCreateSpaceStationPacket> getHandler() {
        return HANDLER;
    }

    private static class Handler
    implements PacketHandler<ServerboundCreateSpaceStationPacket> {
        private Handler() {
        }

        private static boolean hasItem(Player player, Ingredient ingredient, int count) {
            int found = 0;
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (!ingredient.test(stack)) continue;
                found += stack.m_41613_();
            }
            return found >= count;
        }

        public void encode(ServerboundCreateSpaceStationPacket packet, FriendlyByteBuf buf) {
            buf.m_130085_(packet.targetWorld());
        }

        public ServerboundCreateSpaceStationPacket decode(FriendlyByteBuf buf) {
            return new ServerboundCreateSpaceStationPacket(buf.m_130281_());
        }

        public PacketContext handle(ServerboundCreateSpaceStationPacket packet) {
            return (player, level) -> {
                if (!player.m_7500_() && !player.m_5833_()) {
                    for (SpaceStationRecipe recipe2 : SpaceStationRecipe.getRecipes(player.m_9236_())) {
                        for (int i = 0; i < recipe2.m_7527_().size(); ++i) {
                            if (Handler.hasItem(player, (Ingredient)recipe2.m_7527_().get(i), recipe2.getHolders().get(i).count())) continue;
                            return;
                        }
                    }
                    Inventory inventory = player.m_150109_();
                    SpaceStationRecipe.getRecipes(player.m_9236_()).forEach(recipe -> {
                        for (int i = 0; i < recipe.m_7527_().size(); ++i) {
                            inventory.m_36022_((Predicate)recipe.m_7527_().get(i), recipe.getHolders().get(i).count(), (Container)inventory);
                        }
                    });
                }
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    ServerLevel targetWorld = serverWorld.m_7654_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)packet.targetWorld));
                    if (targetWorld == null) {
                        return;
                    }
                    StructureTemplate structure = targetWorld.m_215082_().m_230359_(new ResourceLocation("ad_astra", "space_station"));
                    BlockPos pos = BlockPos.m_274561_((double)(player.m_20185_() - (double)((float)structure.m_163801_().m_123341_() / 2.0f)), (double)100.0, (double)(player.m_20189_() - (double)((float)structure.m_163801_().m_123343_() / 2.0f)));
                    targetWorld.m_7726_().m_8387_(TicketType.f_9447_, new ChunkPos(pos), 1, (Object)pos);
                    structure.m_230328_((ServerLevelAccessor)targetWorld, pos, pos, new StructurePlaceSettings(), targetWorld.f_46441_, 2);
                }
            };
        }
    }
}

