/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.util;

import earth.terrarium.ad_astra.common.container.DoubleFluidTank;
import earth.terrarium.ad_astra.common.recipe.ConversionRecipe;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.PlatformFluidItemHandler;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;

public class FluidUtils {
    public static <T extends ConversionRecipe> boolean convertFluid(DoubleFluidTank tanks, List<T> recipes, long transferPerTick) {
        FluidHolder inputHolder = (FluidHolder)tanks.getInput().getFluids().get(0);
        FluidHolder fluidToTransfer = FluidHooks.newFluidHolder((Fluid)inputHolder.getFluid(), (long)transferPerTick, null);
        for (ConversionRecipe recipe : recipes) {
            long outputAmount;
            FluidHolder convertedFluid;
            long extracted;
            double conversionRatio = recipe.getConversionRatio();
            Fluid recipeOutputFluid = recipe.getFluidOutput();
            if (!recipe.matches(inputHolder.getFluid()) || (extracted = tanks.getInput().extractFluid(fluidToTransfer, true).getFluidAmount()) <= 0L || (convertedFluid = FluidHooks.newFluidHolder((Fluid)recipeOutputFluid, (long)(outputAmount = (long)((double)extracted * conversionRatio)), null)).isEmpty() || fluidToTransfer.isEmpty() || tanks.getOutput().insertFluid(convertedFluid, true) <= 0L) continue;
            tanks.getInput().extractFluid(fluidToTransfer, false);
            tanks.getOutput().insertFluid(convertedFluid, false);
            return true;
        }
        return false;
    }

    public static boolean insertItemFluidToTank(FluidContainer tank, Container inventory, int inputSlot, int outputSlot, int container, Predicate<Fluid> filter) {
        PlatformFluidItemHandler itemFluidHandler;
        FluidHolder itemHolder;
        ItemStack stack = inventory.m_8020_(inputSlot).m_41777_();
        if (stack.m_41619_()) {
            return false;
        }
        int originalCount = stack.m_41613_();
        stack.m_41764_(1);
        Optional possibleItemFluidContainer = FluidHooks.safeGetItemFluidManager((ItemStack)stack);
        if (possibleItemFluidContainer.isPresent() && filter.test((itemHolder = (itemFluidHandler = (PlatformFluidItemHandler)possibleItemFluidContainer.get()).getFluidInTank(container)).getFluid())) {
            FluidHolder fluidToTransfer = FluidHooks.newFluidHolder((Fluid)itemHolder.getFluid(), (long)itemHolder.getFluidAmount(), null);
            if (fluidToTransfer.isEmpty()) {
                return false;
            }
            ItemStackHolder item = new ItemStackHolder(inventory.m_8020_(inputSlot).m_41777_());
            FluidHolder extracted = itemFluidHandler.extractFluid(item, fluidToTransfer, true);
            if (extracted.isEmpty()) {
                return false;
            }
            long l = tank.insertFluid(extracted, true);
            extracted.setAmount(l);
            if (l == itemFluidHandler.extractFluid(item, fluidToTransfer, true).getFluidAmount()) {
                fluidToTransfer.setAmount(l);
                itemFluidHandler.extractFluid(item, fluidToTransfer, false);
                tank.insertFluid(fluidToTransfer, false);
                if (item.isDirty()) {
                    ItemStack copy = item.getStack().m_41777_();
                    ItemStack stack1 = inventory.m_8020_(outputSlot);
                    if (stack1.m_41619_() && (!copy.m_41782_() || !ItemStack.m_150942_((ItemStack)copy, (ItemStack)inventory.m_8020_(inputSlot))) || ItemStack.m_150942_((ItemStack)copy, (ItemStack)stack1) && ItemStack.m_41656_((ItemStack)copy, (ItemStack)stack1) && copy.m_41613_() + stack1.m_41613_() <= copy.m_41741_()) {
                        copy.m_41764_(copy.m_41613_() + stack1.m_41613_());
                        inventory.m_6836_(outputSlot, copy);
                        inventory.m_8020_(inputSlot).m_41764_(originalCount - 1);
                    } else {
                        itemFluidHandler.insertFluid(item, fluidToTransfer, false);
                        tank.extractFluid(fluidToTransfer, false);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean extractTankFluidToItem(FluidContainer tank, Container inventory, int inputSlot, int outputSlot, int container, Predicate<Fluid> filter) {
        ItemStack stack = inventory.m_8020_(inputSlot).m_41777_();
        if (stack.m_41619_()) {
            return false;
        }
        int originalCount = stack.m_41613_();
        stack.m_41764_(1);
        Optional possibleItemFluidContainer = FluidHooks.safeGetItemFluidManager((ItemStack)stack);
        if (possibleItemFluidContainer.isPresent()) {
            PlatformFluidItemHandler itemFluidHandler = (PlatformFluidItemHandler)possibleItemFluidContainer.get();
            FluidHolder tankHolder = (FluidHolder)tank.getFluids().get(container);
            if (filter.test(tankHolder.getFluid())) {
                FluidHolder fluidToTransfer = FluidHooks.newFluidHolder((Fluid)tankHolder.getFluid(), (long)tankHolder.getFluidAmount(), null);
                if (fluidToTransfer.isEmpty()) {
                    return false;
                }
                ItemStackHolder item = new ItemStackHolder(inventory.m_8020_(inputSlot).m_41777_());
                FluidHolder extracted = tank.extractFluid(fluidToTransfer, true);
                if (extracted.isEmpty()) {
                    return false;
                }
                long l = itemFluidHandler.insertFluid(item, extracted, true);
                extracted.setAmount(l);
                if (l > 0L && tank.extractFluid(extracted, true).getFluidAmount() == itemFluidHandler.insertFluid(item, fluidToTransfer, true)) {
                    fluidToTransfer.setAmount(l);
                    tank.extractFluid(fluidToTransfer, false);
                    itemFluidHandler.insertFluid(item, fluidToTransfer, false);
                    if (item.isDirty()) {
                        ItemStack copy = item.getStack().m_41777_();
                        ItemStack stack1 = inventory.m_8020_(outputSlot);
                        if (stack1.m_41619_() && (!copy.m_41782_() || !ItemStack.m_150942_((ItemStack)copy, (ItemStack)inventory.m_8020_(inputSlot))) || ItemStack.m_150942_((ItemStack)copy, (ItemStack)stack1) && ItemStack.m_41656_((ItemStack)copy, (ItemStack)stack1) && copy.m_41613_() + stack1.m_41613_() <= copy.m_41741_()) {
                            copy.m_41764_(copy.m_41613_() + stack1.m_41613_());
                            inventory.m_6836_(outputSlot, copy);
                            inventory.m_8020_(inputSlot).m_41764_(originalCount - 1);
                        } else {
                            itemFluidHandler.extractFluid(item, fluidToTransfer, false);
                            tank.insertFluid(fluidToTransfer, false);
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

