/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.cumulus.client.CumulusClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;

public class WorldDisplayHelper {
    public static boolean menuActive = false;
    @Nullable
    private static LevelSummary loadedSummary = null;

    public static void toggleWorldPreview() {
        if (((Boolean)AetherConfig.CLIENT.enable_world_preview.get()).booleanValue()) {
            WorldDisplayHelper.enableWorldPreview();
        } else {
            WorldDisplayHelper.disableWorldPreview();
        }
    }

    public static void enableWorldPreview() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null) {
            WorldDisplayHelper.loadLevel();
        }
    }

    public static void loadLevel() {
        Minecraft minecraft = Minecraft.m_91087_();
        LevelSummary summary = WorldDisplayHelper.getLevelSummary();
        if (summary != null && minecraft.m_91392_().m_78255_(summary.m_78358_())) {
            WorldDisplayHelper.setActive();
            minecraft.m_91346_((Screen)new GenericDirtMessageScreen((Component)Component.m_237115_((String)"selectWorld.data_read")));
            minecraft.m_231466_().m_233133_(minecraft.f_91080_, summary.m_78358_());
        } else {
            WorldDisplayHelper.resetActive();
            WorldDisplayHelper.resetConfig();
        }
    }

    public static void enterLoadedLevel() {
        Minecraft minecraft = Minecraft.m_91087_();
        LevelSummary summary = WorldDisplayHelper.getLevelSummary();
        if (summary != null && minecraft.m_91392_().m_78255_(summary.m_78358_()) && minecraft.m_91092_() != null) {
            WorldDisplayHelper.resetStates();
            minecraft.m_91346_(null);
        }
    }

    public static void disableWorldPreview() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ != null) {
            WorldDisplayHelper.stopLevel((Screen)new GenericDirtMessageScreen((Component)Component.m_237113_((String)"")));
            WorldDisplayHelper.setMenu();
        }
    }

    public static void stopLevel(@Nullable Screen screen) {
        WorldDisplayHelper.resetStates();
        Minecraft minecraft = Minecraft.m_91087_();
        IntegratedServer server = minecraft.m_91092_();
        if (minecraft.f_91073_ != null) {
            if (server != null) {
                server.m_7570_(false);
            }
            if (screen != null) {
                minecraft.m_91320_(screen);
            } else {
                minecraft.m_91399_();
            }
        }
    }

    public static void setMenu() {
        CumulusClient.MENU_HELPER.setShouldFade(false);
        TitleScreen screen = CumulusClient.MENU_HELPER.applyMenu(CumulusClient.MENU_HELPER.getActiveMenu());
        if (screen != null) {
            Minecraft.m_91087_().m_91346_((Screen)screen);
        }
    }

    @Nullable
    public static LevelSummary getLevelSummary() {
        if (loadedSummary == null) {
            WorldDisplayHelper.findLevelSummary();
        }
        return loadedSummary;
    }

    public static void findLevelSummary() {
        Minecraft minecraft = Minecraft.m_91087_();
        LevelStorageSource source = minecraft.m_91392_();
        try {
            ArrayList summaryList = new ArrayList((Collection)source.m_230813_(source.m_230833_()).get());
            Collections.sort(summaryList);
            if (summaryList.size() > 0) {
                LevelSummary summary = null;
                for (int i = summaryList.size() - 1; i >= 0; --i) {
                    LevelSummary s = (LevelSummary)summaryList.get(i);
                    if (s.m_78375_() || s.m_164916_()) continue;
                    summary = s;
                }
                if (summary != null) {
                    loadedSummary = summary;
                }
            }
        }
        catch (InterruptedException | UnsupportedOperationException | ExecutionException e) {
            WorldDisplayHelper.resetActive();
            WorldDisplayHelper.resetConfig();
            e.printStackTrace();
        }
    }

    public static boolean sameSummaries(LevelSummary summary) {
        return WorldDisplayHelper.getLevelSummary().m_78358_().equals(summary.m_78358_());
    }

    public static void resetStates() {
        WorldDisplayHelper.resetPlayerState();
        WorldDisplayHelper.resetActive();
    }

    public static void resetPlayerState() {
        Minecraft.m_91087_().f_91066_.f_92062_ = false;
        Minecraft.m_91087_().f_91066_.m_92157_(CameraType.FIRST_PERSON);
    }

    public static void resetConfig() {
        AetherConfig.CLIENT.enable_world_preview.set((Object)false);
        AetherConfig.CLIENT.enable_world_preview.save();
    }

    public static void resetActive() {
        menuActive = false;
    }

    public static void setActive() {
        menuActive = true;
    }

    public static boolean isActive() {
        return menuActive;
    }

    public static void setupLevelForDisplay() {
        Minecraft minecraft = Minecraft.m_91087_();
        IntegratedServer server = minecraft.m_91092_();
        if (server != null) {
            Minecraft.m_91087_().f_91066_.f_92062_ = true;
            Minecraft.m_91087_().f_91066_.m_92157_(CameraType.THIRD_PERSON_BACK);
            WorldDisplayHelper.setMenu();
        }
    }
}

