/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.entity.model;

import com.aetherteam.aether.entity.passive.MountableAnimal;
import com.aetherteam.aether.entity.passive.WingedAnimal;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class QuadrupedWingsModel<T extends WingedAnimal>
extends EntityModel<T> {
    public final ModelPart leftWingInner;
    public final ModelPart leftWingOuter;
    public final ModelPart rightWingInner;
    public final ModelPart rightWingOuter;

    public QuadrupedWingsModel(ModelPart root) {
        this.leftWingInner = root.m_171324_("left_wing_inner");
        this.leftWingOuter = this.leftWingInner.m_171324_("left_wing_outer");
        this.rightWingInner = root.m_171324_("right_wing_inner");
        this.rightWingOuter = this.rightWingInner.m_171324_("right_wing_outer");
    }

    public static LayerDefinition createMainLayer(float offset) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition leftWingInnerDef = partDefinition.m_171599_("left_wing_inner", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171481_(-1.0f, -16.0f, 0.0f, 2.0f, 16.0f, 8.0f), PartPose.m_171419_((float)-4.0f, (float)(2.0f + offset), (float)-4.0f));
        leftWingInnerDef.m_171599_("left_wing_outer", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171480_().m_171481_(-1.0f, -16.0f, 0.0f, 2.0f, 16.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)-16.0f, (float)0.0f));
        PartDefinition rightWingInnerDef = partDefinition.m_171599_("right_wing_inner", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, -16.0f, 0.0f, 2.0f, 16.0f, 8.0f), PartPose.m_171419_((float)4.0f, (float)(2.0f + offset), (float)-4.0f));
        rightWingInnerDef.m_171599_("right_wing_outer", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171481_(-1.0f, -16.0f, 0.0f, 2.0f, 16.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)-16.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!Minecraft.m_91087_().m_91104_()) {
            float aimingForFold = ((MountableAnimal)entity).isEntityOnGround() ? 0.1f : 1.0f;
            ((WingedAnimal)entity).setWingAngle(((WingedAnimal)entity).getWingFold() * Mth.m_14031_((float)(ageInTicks / 15.9f)));
            ((WingedAnimal)entity).setWingFold(((WingedAnimal)entity).getWingFold() + (aimingForFold - ((WingedAnimal)entity).getWingFold()) / 37.5f);
            float wingBend = -((float)Math.acos(((WingedAnimal)entity).getWingFold()));
            this.leftWingInner.f_104205_ = -(((WingedAnimal)entity).getWingAngle() + wingBend + 1.5707964f);
            this.leftWingOuter.f_104205_ = -(((WingedAnimal)entity).getWingAngle() - wingBend + 1.5707964f) - this.leftWingInner.f_104205_;
            this.rightWingInner.f_104205_ = -this.leftWingInner.f_104205_;
            this.rightWingOuter.f_104205_ = -this.leftWingOuter.f_104205_;
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.leftWingInner.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightWingInner.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

