/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.data.providers;

import com.aetherteam.aether.block.AetherBlockStateProperties;
import com.aetherteam.aether.block.construction.AetherFarmBlock;
import com.aetherteam.aether.block.dungeon.DoorwayBlock;
import com.aetherteam.aether.block.miscellaneous.AetherFrostedIceBlock;
import com.aetherteam.aether.block.miscellaneous.FacingPillarBlock;
import com.aetherteam.aether.block.miscellaneous.UnstableObsidianBlock;
import com.aetherteam.nitrogen.data.providers.NitrogenBlockStateProvider;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public abstract class AetherBlockStateProvider
extends NitrogenBlockStateProvider {
    public AetherBlockStateProvider(PackOutput output, String id, ExistingFileHelper helper) {
        super(output, id, helper);
    }

    public void grass(Block block, Block dirtBlock) {
        this.grassBlock(block, block, dirtBlock);
    }

    public void enchantedGrass(Block block, Block grassBlock, Block dirtBlock) {
        this.grassBlock(block, grassBlock, dirtBlock);
    }

    public void grassBlock(Block baseBlock, Block blockForSnow, Block blockForDirt) {
        ModelFile grass = this.grassBlock(baseBlock, blockForDirt);
        ModelFile grassSnowed = this.cubeBottomTop(this.name(blockForSnow) + "_snow", this.extend(this.texture(this.name(blockForSnow), "natural/"), "_snow"), this.texture(this.name(blockForDirt), "natural/"), this.extend(this.texture(this.name(baseBlock), "natural/"), "_top"));
        this.getVariantBuilder(baseBlock).forAllStatesExcept(state -> {
            boolean snowy = (Boolean)state.m_61143_((Property)SnowyDirtBlock.f_56637_);
            return ConfiguredModel.allYRotations((ModelFile)(snowy ? grassSnowed : grass), (int)0, (boolean)false);
        }, new Property[]{AetherBlockStateProperties.DOUBLE_DROPS});
    }

    public ModelFile grassBlock(Block block, Block dirtBlock) {
        return this.cubeBottomTop(this.name(block), this.extend(this.texture(this.name(block), "natural/"), "_side"), this.texture(this.name(dirtBlock), "natural/"), this.extend(this.texture(this.name(block), "natural/"), "_top"));
    }

    public void dirtPath(Block block, Block dirtBlock) {
        ModelBuilder path = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("block/dirt_path"))).texture("particle", this.modLoc("block/natural/" + this.name(dirtBlock)))).texture("top", this.modLoc("block/construction/" + this.name(block) + "_top"))).texture("side", this.modLoc("block/construction/" + this.name(block) + "_side"))).texture("bottom", this.modLoc("block/natural/" + this.name(dirtBlock)));
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> AetherBlockStateProvider.lambda$dirtPath$1((ModelFile)path, arg_0), new Property[]{AetherBlockStateProperties.DOUBLE_DROPS});
    }

    public void farmland(Block block, Block dirtBlock) {
        ModelBuilder farmland = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("block/template_farmland"))).texture("dirt", this.modLoc("block/natural/" + this.name(dirtBlock)))).texture("top", this.modLoc("block/construction/" + this.name(block)));
        ModelBuilder moist = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_moist", this.mcLoc("block/template_farmland"))).texture("dirt", this.modLoc("block/natural/" + this.name(dirtBlock)))).texture("top", this.modLoc("block/construction/" + this.name(block) + "_moist"));
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> AetherBlockStateProvider.lambda$farmland$2((ModelFile)farmland, (ModelFile)moist, arg_0), new Property[]{AetherBlockStateProperties.DOUBLE_DROPS});
    }

    public void randomBlockDoubleDrops(Block block, String location) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.allYRotations((ModelFile)this.cubeAll(block, location), (int)0, (boolean)false), new Property[]{AetherBlockStateProperties.DOUBLE_DROPS});
    }

    public void blockDoubleDrops(Block block, String location) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile(this.cubeAll(block, location)).build(), new Property[]{AetherBlockStateProperties.DOUBLE_DROPS});
    }

    public void enchantedLog(RotatedPillarBlock block, RotatedPillarBlock baseBlock) {
        this.axisBlock(block, this.texture(this.name((Block)block), "natural/"), this.extend(this.texture(this.name((Block)baseBlock), "natural/"), "_top"));
    }

    public void altar(Block block) {
        ModelFile altar = this.cubeBottomTop(this.name(block), this.extend(this.texture(this.name(block), "utility/"), "_side"), this.extend(this.texture(this.name(block), "utility/"), "_bottom"), this.extend(this.texture(this.name(block), "utility/"), "_bottom"));
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel(altar)});
    }

    public void freezer(Block block) {
        ModelFile freezer = this.utility(block);
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel(freezer)});
    }

    public void incubator(Block block) {
        ModelFile incubator = this.utility(block);
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel(incubator)});
    }

    public ModelFile utility(Block block) {
        return this.cubeBottomTop(this.name(block), this.extend(this.texture(this.name(block), "utility/"), "_side"), this.extend(this.texture("altar", "utility/"), "_bottom"), this.extend(this.texture(this.name(block), "utility/"), "_top"));
    }

    public void hangingSignBlock(CeilingHangingSignBlock signBlock, WallHangingSignBlock wallSignBlock, ResourceLocation texture) {
        ModelBuilder sign = this.models().sign(this.name((Block)signBlock), texture);
        this.simpleBlock((Block)signBlock, (ModelFile)sign);
        this.simpleBlock((Block)wallSignBlock, (ModelFile)sign);
    }

    public void berryBush(Block block, Block stem) {
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel(this.bush(block, stem))});
    }

    public ModelFile bush(Block block, Block stem) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("block/block"))).texture("particle", this.texture(this.name(block), "natural/"))).texture("bush", this.texture(this.name(block), "natural/"))).texture("stem", this.texture(this.name(stem), "natural/"))).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).shade(true).allFaces((direction, builder) -> builder.texture("#bush").end()).end()).element().from(0.8f, 0.0f, 8.0f).to(15.2f, 16.0f, 8.0f).rotation().origin(8.0f, 8.0f, 8.0f).axis(Direction.Axis.Y).angle(45.0f).rescale(true).end().shade(true).face(Direction.NORTH).texture("#stem").end().face(Direction.SOUTH).texture("#stem").end().end()).element().from(8.0f, 0.0f, 0.8f).to(8.0f, 16.0f, 15.2f).rotation().origin(8.0f, 8.0f, 8.0f).axis(Direction.Axis.Y).angle(45.0f).rescale(true).end().shade(true).face(Direction.WEST).texture("#stem").end().face(Direction.EAST).texture("#stem").end().end()).renderType(new ResourceLocation("cutout"));
    }

    public BlockModelBuilder pottedStemModel(Block block, Block stem, String location) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("block/block"))).texture("particle", this.mcLoc("block/flower_pot"))).texture("stem", this.modLoc("block/" + location + this.name(stem)))).texture("dirt", this.mcLoc("block/dirt"))).texture("flowerpot", this.mcLoc("block/flower_pot"))).element().from(5.0f, 0.0f, 5.0f).to(6.0f, 6.0f, 11.0f).face(Direction.NORTH).uvs(10.0f, 10.0f, 11.0f, 16.0f).texture("#flowerpot").end().face(Direction.EAST).uvs(5.0f, 10.0f, 11.0f, 16.0f).texture("#flowerpot").end().face(Direction.SOUTH).uvs(5.0f, 10.0f, 6.0f, 16.0f).texture("#flowerpot").end().face(Direction.WEST).uvs(5.0f, 10.0f, 11.0f, 16.0f).texture("#flowerpot").end().face(Direction.UP).uvs(5.0f, 5.0f, 6.0f, 11.0f).texture("#flowerpot").end().face(Direction.DOWN).uvs(5.0f, 5.0f, 6.0f, 11.0f).texture("#flowerpot").cullface(Direction.DOWN).end().end()).element().from(10.0f, 0.0f, 5.0f).to(11.0f, 6.0f, 11.0f).face(Direction.NORTH).uvs(5.0f, 10.0f, 6.0f, 16.0f).texture("#flowerpot").end().face(Direction.EAST).uvs(5.0f, 10.0f, 11.0f, 16.0f).texture("#flowerpot").end().face(Direction.SOUTH).uvs(10.0f, 10.0f, 11.0f, 16.0f).texture("#flowerpot").end().face(Direction.WEST).uvs(5.0f, 10.0f, 11.0f, 16.0f).texture("#flowerpot").end().face(Direction.UP).uvs(10.0f, 5.0f, 11.0f, 11.0f).texture("#flowerpot").end().face(Direction.DOWN).uvs(10.0f, 5.0f, 11.0f, 11.0f).texture("#flowerpot").cullface(Direction.DOWN).end().end()).element().from(6.0f, 0.0f, 5.0f).to(10.0f, 6.0f, 6.0f).face(Direction.NORTH).uvs(6.0f, 10.0f, 10.0f, 16.0f).texture("#flowerpot").end().face(Direction.SOUTH).uvs(6.0f, 10.0f, 10.0f, 16.0f).texture("#flowerpot").end().face(Direction.UP).uvs(6.0f, 5.0f, 10.0f, 6.0f).texture("#flowerpot").end().face(Direction.DOWN).uvs(6.0f, 10.0f, 10.0f, 11.0f).texture("#flowerpot").cullface(Direction.DOWN).end().end()).element().from(6.0f, 0.0f, 10.0f).to(10.0f, 6.0f, 11.0f).face(Direction.NORTH).uvs(6.0f, 10.0f, 10.0f, 16.0f).texture("#flowerpot").end().face(Direction.SOUTH).uvs(6.0f, 10.0f, 10.0f, 16.0f).texture("#flowerpot").end().face(Direction.UP).uvs(6.0f, 10.0f, 10.0f, 11.0f).texture("#flowerpot").end().face(Direction.DOWN).uvs(6.0f, 5.0f, 10.0f, 6.0f).texture("#flowerpot").cullface(Direction.DOWN).end().end()).element().from(6.0f, 0.0f, 6.0f).to(10.0f, 4.0f, 10.0f).face(Direction.UP).uvs(6.0f, 6.0f, 10.0f, 10.0f).texture("#dirt").end().face(Direction.DOWN).uvs(6.0f, 12.0f, 10.0f, 16.0f).texture("#flowerpot").cullface(Direction.DOWN).end().end()).element().from(1.0f, 4.0f, 8.0f).to(15.0f, 16.0f, 8.0f).rotation().angle(45.0f).axis(Direction.Axis.Y).origin(8.0f, 8.0f, 8.0f).end().face(Direction.NORTH).uvs(0.0f, 4.0f, 16.0f, 16.0f).texture("#stem").end().face(Direction.SOUTH).uvs(0.0f, 4.0f, 16.0f, 16.0f).texture("#stem").end().end()).element().from(8.0f, 4.0f, 1.0f).to(8.0f, 16.0f, 15.0f).rotation().angle(45.0f).axis(Direction.Axis.Y).origin(8.0f, 8.0f, 8.0f).end().face(Direction.EAST).uvs(0.0f, 4.0f, 16.0f, 16.0f).texture("#stem").end().face(Direction.WEST).uvs(0.0f, 4.0f, 16.0f, 16.0f).texture("#stem").end().end();
    }

    public void pottedStem(Block stem, String location) {
        ModelBuilder pot = this.pottedStemModel(stem, stem, location).renderType(new ResourceLocation("cutout"));
        this.getVariantBuilder(stem).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)pot)});
    }

    public void pottedBush(Block bush, Block stem, String location) {
        ModelBuilder pot = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.pottedStemModel(bush, stem, location).texture("stem", this.modLoc("block/" + location + this.name(stem)))).texture("bush", this.modLoc("block/" + location + this.name(bush)))).element().from(3.0f, 6.0f, 3.0f).to(13.0f, 16.0f, 13.0f).face(Direction.NORTH).uvs(3.0f, 3.0f, 13.0f, 13.0f).texture("#bush").end().face(Direction.EAST).uvs(3.0f, 3.0f, 13.0f, 13.0f).texture("#bush").end().face(Direction.SOUTH).uvs(3.0f, 3.0f, 13.0f, 13.0f).texture("#bush").end().face(Direction.WEST).uvs(3.0f, 3.0f, 13.0f, 13.0f).texture("#bush").end().face(Direction.UP).uvs(3.0f, 3.0f, 13.0f, 13.0f).texture("#bush").end().face(Direction.DOWN).uvs(3.0f, 3.0f, 13.0f, 13.0f).texture("#bush").end().end()).renderType(new ResourceLocation("cutout"));
        this.getVariantBuilder(bush).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)pot)});
    }

    public void dungeonBlock(Block block, Block baseBlock) {
        ConfiguredModel dungeonBlock = new ConfiguredModel((ModelFile)this.models().cubeAll(this.name(baseBlock), this.texture(this.name(baseBlock), "dungeon/")));
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{dungeonBlock});
    }

    public void invisibleBlock(Block block, Block baseBlock) {
        ModelBuilder visible = this.models().cubeAll(this.name(baseBlock), this.texture(this.name(baseBlock), "dungeon/"));
        ModelBuilder invisible = this.models().getBuilder(this.name(block));
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> AetherBlockStateProvider.lambda$invisibleBlock$6((ModelFile)visible, (ModelFile)invisible, arg_0), new Property[0]);
    }

    public void chestMimic(Block block, Block dummyBlock) {
        ModelBuilder chest = this.models().cubeAll(this.name(block), this.mcLoc("block/" + this.name(dummyBlock)));
        this.chest(block, (ModelFile)chest);
    }

    public void treasureChest(Block block, Block dummyBlock) {
        ModelBuilder chest = this.models().cubeAll(this.name(block), this.texture(this.name(dummyBlock), "dungeon/"));
        this.chest(block, (ModelFile)chest);
    }

    public void pillar(RotatedPillarBlock block) {
        this.axisBlock(block, this.extend(this.texture(this.name((Block)block), "dungeon/"), "_side"), this.extend(this.texture(this.name((Block)block), "dungeon/"), "_top"));
    }

    public void pillarTop(FacingPillarBlock block) {
        ResourceLocation side = this.texture("pillar_carved", "dungeon/");
        ResourceLocation end = this.texture(this.name((Block)block), "dungeon/");
        ModelBuilder vertical = this.models().cubeColumn(this.name((Block)block), side, end);
        ModelBuilder horizontal = this.models().cubeColumnHorizontal(this.name((Block)block) + "_horizontal", side, end);
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block).partialState().with((Property)FacingPillarBlock.f_52588_, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)vertical).rotationX(180).addModel()).partialState().with((Property)FacingPillarBlock.f_52588_, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)horizontal).rotationX(90).rotationY(90).addModel()).partialState().with((Property)FacingPillarBlock.f_52588_, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)horizontal).rotationX(90).addModel()).partialState().with((Property)FacingPillarBlock.f_52588_, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)horizontal).rotationX(90).rotationY(180).addModel()).partialState().with((Property)FacingPillarBlock.f_52588_, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)vertical).addModel()).partialState().with((Property)FacingPillarBlock.f_52588_, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)horizontal).rotationX(90).rotationY(270).addModel();
    }

    public void present(Block block) {
        ModelFile present = this.cubeBottomTop(this.name(block), this.extend(this.texture(this.name(block), "miscellaneous/"), "_side"), this.extend(this.texture(this.name(block), "miscellaneous/"), "_top"), this.extend(this.texture(this.name(block), "miscellaneous/"), "_top"));
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel(present)});
    }

    public void sunAltar(Block block) {
        ModelFile sunAltar = this.cubeBottomTop(this.name(block), this.extend(this.texture(this.name(block), "utility/"), "_side"), this.texture("hellfire_stone", "dungeon/"), this.extend(this.texture(this.name(block), "utility/"), "_top"));
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel(sunAltar)});
    }

    public void bed(Block block, Block dummyBlock) {
        ModelBuilder head = this.models().cubeAll(this.name(block) + "_head", this.texture(this.name(dummyBlock), "construction/"));
        ModelBuilder foot = this.models().cubeAll(this.name(block) + "_foot", this.texture(this.name(dummyBlock), "construction/"));
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> AetherBlockStateProvider.lambda$bed$7((ModelFile)head, (ModelFile)foot, arg_0), new Property[]{BedBlock.f_49441_});
    }

    public void frostedIce(Block block, Block base) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int age = (Integer)state.m_61143_((Property)AetherFrostedIceBlock.f_53561_);
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cubeAll(this.name(block) + "_" + age, this.mcLoc("block/" + this.name(base) + "_" + age))).renderType(new ResourceLocation("translucent"))).build();
        });
    }

    public void unstableObsidian(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int age = (Integer)state.m_61143_((Property)UnstableObsidianBlock.AGE);
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeAll(this.name(block) + "_" + age, this.texture(this.name(block) + "_" + age, "miscellaneous/"))).build();
        });
    }

    private static /* synthetic */ ConfiguredModel[] lambda$bed$7(ModelFile head, ModelFile foot, BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        BedPart part = (BedPart)state.m_61143_((Property)BlockStateProperties.f_61391_);
        return ConfiguredModel.builder().modelFile(part == BedPart.HEAD ? head : foot).rotationY(((int)dir.m_122435_() + 180) % 360).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$invisibleBlock$6(ModelFile visible, ModelFile invisible, BlockState state) {
        if (!((Boolean)state.m_61143_((Property)DoorwayBlock.INVISIBLE)).booleanValue()) {
            return ConfiguredModel.builder().modelFile(visible).build();
        }
        return ConfiguredModel.builder().modelFile(invisible).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$farmland$2(ModelFile farmland, ModelFile moist, BlockState state) {
        int moisture = (Integer)state.m_61143_((Property)AetherFarmBlock.f_53243_);
        return ConfiguredModel.builder().modelFile(moisture < 7 ? farmland : moist).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$dirtPath$1(ModelFile path, BlockState state) {
        return ConfiguredModel.allYRotations((ModelFile)path, (int)0, (boolean)false);
    }
}

