/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster.dungeon.boss;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.client.gui.screen.ValkyrieQueenDialogueScreen;
import com.aetherteam.aether.data.resources.registries.AetherStructures;
import com.aetherteam.aether.entity.AetherBossMob;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.NpcDialogue;
import com.aetherteam.aether.entity.ai.AetherBlockPathTypes;
import com.aetherteam.aether.entity.ai.goal.NpcDialogueGoal;
import com.aetherteam.aether.entity.monster.dungeon.AbstractValkyrie;
import com.aetherteam.aether.entity.monster.dungeon.boss.BossNameGenerator;
import com.aetherteam.aether.entity.projectile.crystal.ThunderCrystal;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.clientbound.QueenDialoguePacket;
import com.aetherteam.aether.network.packet.serverbound.BossInfoPacket;
import com.aetherteam.nitrogen.entity.BossRoomTracker;
import com.aetherteam.nitrogen.network.PacketRelay;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.commons.lang3.tuple.Pair;

public class ValkyrieQueen
extends AbstractValkyrie
implements AetherBossMob<ValkyrieQueen>,
NpcDialogue,
IEntityAdditionalSpawnData {
    private static final EntityDataAccessor<Boolean> DATA_IS_READY = SynchedEntityData.m_135353_(ValkyrieQueen.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Component> DATA_BOSS_NAME = SynchedEntityData.m_135353_(ValkyrieQueen.class, (EntityDataSerializer)EntityDataSerializers.f_135031_);
    private final ServerBossEvent bossFight = new ServerBossEvent(this.getBossName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
    @Nullable
    private BossRoomTracker<ValkyrieQueen> dungeon;
    @Nullable
    private AABB dungeonBounds;
    @Nullable
    private Player conversingPlayer;

    public ValkyrieQueen(EntityType<? extends ValkyrieQueen> type, Level level) {
        super(type, level);
        this.setBossFight(false);
        this.f_21364_ = 50;
        this.m_21441_(AetherBlockPathTypes.BOSS_DOORWAY, -1.0f);
        this.m_21530_();
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        this.setBossName((Component)BossNameGenerator.generateValkyrieName(this.m_217043_()));
        if (tag != null && tag.m_128441_("Dungeon")) {
            StructureManager manager = level.m_6018_().m_215010_();
            manager.m_220521_().m_6632_(Registries.f_256944_).ifPresent(registry -> {
                StructureStart start;
                Structure temple = (Structure)registry.m_6246_(AetherStructures.SILVER_DUNGEON);
                if (temple != null && (start = manager.m_220494_(this.m_20183_(), temple)) != StructureStart.f_73561_) {
                    BoundingBox box = start.m_73601_();
                    AABB dungeonBounds = new AABB((double)box.m_162395_(), (double)box.m_162396_(), (double)box.m_162398_(), (double)(box.m_162399_() + 1), (double)(box.m_162400_() + 1), (double)(box.m_162401_() + 1));
                    this.setDungeonBounds(dungeonBounds);
                }
            });
        }
        return spawnData;
    }

    @Override
    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, new NpcDialogueGoal<ValkyrieQueen>(this));
        this.f_21345_.m_25352_(1, (Goal)new GetUnstuckGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new ThunderCrystalAttackGoal((Mob)this, 450, 28.0f));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, livingEntity -> this.isBossFight()));
    }

    public static AttributeSupplier.Builder m_21552_() {
        return AbstractValkyrie.createAttributes().m_22268_(Attributes.f_22277_, 28.0).m_22268_(Attributes.f_22281_, 13.5).m_22268_(Attributes.f_22276_, 500.0);
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_IS_READY, (Object)false);
        this.m_20088_().m_135372_(DATA_BOSS_NAME, (Object)Component.m_237113_((String)"Valkyrie Queen"));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.breakBlocks();
        this.evaporate();
    }

    private void breakBlocks() {
        LivingEntity target = this.m_5448_();
        if (!this.m_9236_().m_5776_() && target != null && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
            for (int i = 0; i < 2; ++i) {
                Vec3i vector = i == 0 ? this.m_6374_().m_122436_() : Vec3i.f_123288_;
                BlockPos upperPosition = BlockPos.m_274446_((Position)this.m_146892_()).m_121955_(vector);
                BlockPos lowerPosition = this.m_20183_().m_121955_(vector);
                BlockState upperState = this.m_9236_().m_8055_(upperPosition);
                BlockState lowerState = this.m_9236_().m_8055_(lowerPosition);
                if (this.isBreakable(upperState) && (upperState.m_60808_((BlockGetter)this.m_9236_(), upperPosition).equals(Shapes.m_83144_()) || !upperState.m_60812_((BlockGetter)this.m_9236_(), upperPosition).m_83281_()) && (this.getDungeon() == null || this.getDungeon().roomBounds().m_82390_(upperPosition.m_252807_()))) {
                    this.m_9236_().m_46953_(upperPosition, true, (Entity)this);
                    this.m_6674_(InteractionHand.MAIN_HAND);
                    continue;
                }
                if (!this.isBreakable(lowerState) || !lowerState.m_60808_((BlockGetter)this.m_9236_(), lowerPosition).equals(Shapes.m_83144_()) && lowerState.m_60812_((BlockGetter)this.m_9236_(), lowerPosition).m_83281_() || this.getDungeon() != null && !this.getDungeon().roomBounds().m_82390_(lowerPosition.m_252807_())) continue;
                this.m_9236_().m_46953_(lowerPosition, true, (Entity)this);
                this.m_6674_(InteractionHand.MAIN_HAND);
            }
        }
    }

    private boolean isBreakable(BlockState blockState) {
        return !blockState.m_60795_() && !blockState.m_204336_(AetherTags.Blocks.VALKYRIE_QUEEN_UNBREAKABLE) && blockState.m_60734_().m_155943_() >= 0.0f && blockState.m_60734_().m_155943_() < 100.0f;
    }

    private void evaporate() {
        Pair minMax = this.getDefaultBounds((Mob)this);
        AetherBossMob.super.evaporate(this, (BlockPos)minMax.getLeft(), (BlockPos)minMax.getRight(), blockState -> !blockState.m_204336_(AetherTags.Blocks.VALKYRIE_QUEEN_UNBREAKABLE));
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossFight.m_142711_(this.m_21223_() / this.m_21233_());
        this.trackDungeon();
    }

    @Override
    protected boolean teleportAroundTarget(Entity target) {
        Vec2 targetVec = new Vec2(this.m_217043_().m_188501_() - 0.5f, this.m_217043_().m_188501_() - 0.5f).m_165902_();
        double x = target.m_20185_() + (double)(targetVec.f_82470_ * 7.0f);
        double y = target.m_20186_();
        double z = target.m_20189_() + (double)(targetVec.f_82471_ * 7.0f);
        if (this.getDungeon() != null) {
            AABB room = this.getDungeon().roomBounds();
            x = Mth.m_14008_((double)x, (double)(room.f_82288_ + 1.0), (double)(room.f_82291_ - 1.0));
            y = Mth.m_14008_((double)y, (double)(room.f_82289_ + 1.0), (double)(room.f_82292_ - 1.0));
            z = Mth.m_14008_((double)z, (double)(room.f_82290_ + 1.0), (double)(room.f_82293_ - 1.0));
        }
        return this.teleport(x, y, z);
    }

    protected void teleportUnstuck(Entity target) {
        this.teleport(target.m_20185_(), target.m_20186_(), target.m_20189_());
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && !this.isBossFight() && !this.m_9236_().m_5776_()) {
            if (!this.isReady()) {
                this.m_21391_((Entity)player, 180.0f, 180.0f);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (this.getConversingPlayer() == null) {
                        PacketRelay.sendToPlayer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new QueenDialoguePacket(this.m_19879_()), (ServerPlayer)serverPlayer);
                        this.setConversingPlayer((Player)serverPlayer);
                    }
                }
            } else {
                this.chatWithNearby((Component)Component.m_237115_((String)"gui.aether.queen.dialog.ready"));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void openDialogueScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new ValkyrieQueenDialogueScreen(this));
    }

    @Override
    public void handleNpcInteraction(Player player, byte interactionID) {
        block0 : switch (interactionID) {
            case 0: {
                this.chat(player, (Component)Component.m_237115_((String)"gui.aether.queen.dialog.answer"));
                break;
            }
            case 1: {
                if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
                    this.chat(player, (Component)Component.m_237115_((String)"gui.aether.queen.dialog.peaceful"));
                    break;
                }
                if (player.m_150109_().m_18947_((Item)AetherItems.VICTORY_MEDAL.get()) >= 10) {
                    this.readyUp();
                    int count = 10;
                    for (ItemStack item : player.f_36095_.m_38927_()) {
                        if (item.m_150930_((Item)AetherItems.VICTORY_MEDAL.get())) {
                            if (item.m_41613_() > count) {
                                item.m_41774_(count);
                                break block0;
                            }
                            count -= item.m_41613_();
                            item.m_41764_(0);
                        }
                        if (count > 0) continue;
                        break block0;
                    }
                    break;
                }
                this.chat(player, (Component)Component.m_237115_((String)"gui.aether.queen.dialog.no_medals"));
                break;
            }
            case 2: {
                this.chat(player, (Component)Component.m_237115_((String)"gui.aether.queen.dialog.deny_fight"));
                break;
            }
            default: {
                this.chat(player, (Component)Component.m_237115_((String)"gui.aether.queen.dialog.goodbye"));
            }
        }
        this.setConversingPlayer(null);
    }

    public void readyUp() {
        MutableComponent message = Component.m_237115_((String)"gui.aether.queen.dialog.begin");
        this.chatWithNearby((Component)message);
        this.setReady(true);
    }

    protected void chatWithNearby(Component message) {
        AABB room = this.dungeon == null ? this.m_20191_().m_82400_(16.0) : this.dungeon.roomBounds();
        this.m_9236_().m_45955_(NON_COMBAT, (LivingEntity)this, room).forEach(player -> this.chat((Player)player, message));
    }

    @Override
    protected void chat(Player player, Component message) {
        player.m_213846_((Component)Component.m_237113_((String)"[").m_7220_((Component)this.getBossName().m_6881_().m_130940_(ChatFormatting.YELLOW)).m_130946_("]: ").m_7220_(message));
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity;
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            return super.m_6469_(source, amount);
        }
        if (this.isReady() && (entity = source.m_7640_()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (this.m_9236_().m_46791_() != Difficulty.PEACEFUL) {
                if (this.getDungeon() == null || this.getDungeon().isPlayerWithinRoomInterior((Entity)attacker)) {
                    if (super.m_6469_(source, amount) && this.m_21223_() > 0.0f) {
                        if (!this.m_9236_().m_5776_() && !this.isBossFight()) {
                            this.chatWithNearby((Component)Component.m_237115_((String)"gui.aether.queen.dialog.fight"));
                            this.setBossFight(true);
                            if (this.getDungeon() != null) {
                                this.closeRoom();
                            }
                        }
                        return true;
                    }
                } else if (!this.m_9236_().m_5776_() && attacker instanceof Player) {
                    Player player = (Player)attacker;
                    this.displayTooFarMessage(player);
                    return false;
                }
            }
        }
        return false;
    }

    public boolean m_7327_(Entity entity) {
        ServerPlayer player;
        boolean result = super.m_7327_(entity);
        if (entity instanceof ServerPlayer && (player = (ServerPlayer)entity).m_21223_() <= 0.0f) {
            this.chat((Player)player, (Component)Component.m_237115_((String)"gui.aether.queen.dialog.playerdeath"));
        }
        return result;
    }

    public void reset() {
        this.setBossFight(false);
        this.m_6710_(null);
        this.m_21153_(this.m_21233_());
        if (this.getDungeon() != null) {
            this.openRoom();
        }
    }

    public void m_6667_(DamageSource source) {
        if (!this.m_9236_().f_46443_) {
            this.bossFight.m_142711_(this.m_21223_() / this.m_21233_());
            this.chatWithNearby((Component)Component.m_237115_((String)"gui.aether.queen.dialog.defeated"));
            this.spawnExplosionParticles();
            if (this.getDungeon() != null) {
                this.getDungeon().grantAdvancements(source);
                this.tearDownRoom();
            }
        }
        super.m_6667_(source);
    }

    public void tearDownRoom() {
        for (BlockPos pos : BlockPos.m_121976_((int)((int)this.dungeonBounds.f_82288_), (int)((int)this.dungeonBounds.f_82289_), (int)((int)this.dungeonBounds.f_82290_), (int)((int)this.dungeonBounds.f_82291_), (int)((int)this.dungeonBounds.f_82292_), (int)((int)this.dungeonBounds.f_82293_))) {
            BlockState state = this.m_9236_().m_8055_(pos);
            BlockState newState = this.convertBlock(state);
            if (newState == null) continue;
            this.m_9236_().m_7731_(pos, newState, 3);
        }
    }

    public void m_6043_() {
    }

    @Nullable
    public BlockState convertBlock(BlockState state) {
        if (state.m_60713_((Block)AetherBlocks.LOCKED_ANGELIC_STONE.get()) || state.m_60713_((Block)AetherBlocks.TRAPPED_ANGELIC_STONE.get())) {
            return ((Block)AetherBlocks.ANGELIC_STONE.get()).m_49966_();
        }
        if (state.m_60713_((Block)AetherBlocks.LOCKED_LIGHT_ANGELIC_STONE.get()) || state.m_60713_((Block)AetherBlocks.TRAPPED_LIGHT_ANGELIC_STONE.get())) {
            return ((Block)AetherBlocks.LIGHT_ANGELIC_STONE.get()).m_49966_();
        }
        if (state.m_60713_((Block)AetherBlocks.BOSS_DOORWAY_ANGELIC_STONE.get())) {
            return Blocks.f_50016_.m_49966_();
        }
        if (state.m_60713_((Block)AetherBlocks.TREASURE_DOORWAY_ANGELIC_STONE.get())) {
            return (BlockState)((TrapDoorBlock)AetherBlocks.SKYROOT_TRAPDOOR.get()).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
        }
        return null;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        PacketRelay.sendToPlayer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new BossInfoPacket.Display(this.bossFight.m_18860_(), this.m_19879_()), (ServerPlayer)player);
        if (this.getDungeon() == null || this.getDungeon().isPlayerTracked((Player)player)) {
            this.bossFight.m_6543_(player);
        }
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        PacketRelay.sendToPlayer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new BossInfoPacket.Remove(this.bossFight.m_18860_(), this.m_19879_()), (ServerPlayer)player);
        this.bossFight.m_6539_(player);
    }

    public void onDungeonPlayerAdded(@Nullable Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.bossFight.m_6543_(serverPlayer);
        }
    }

    public void onDungeonPlayerRemoved(@Nullable Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.bossFight.m_6539_(serverPlayer);
        }
    }

    public boolean isReady() {
        return (Boolean)this.m_20088_().m_135370_(DATA_IS_READY);
    }

    public void setReady(boolean ready) {
        this.m_20088_().m_135381_(DATA_IS_READY, (Object)ready);
    }

    public Component getBossName() {
        return (Component)this.m_20088_().m_135370_(DATA_BOSS_NAME);
    }

    public void setBossName(Component component) {
        this.m_20088_().m_135381_(DATA_BOSS_NAME, (Object)component);
        this.bossFight.m_6456_(component);
    }

    @Nullable
    public BossRoomTracker<ValkyrieQueen> getDungeon() {
        return this.dungeon;
    }

    public void setDungeon(@Nullable BossRoomTracker<ValkyrieQueen> dungeon) {
        this.dungeon = dungeon;
        if (this.dungeonBounds == null) {
            this.dungeonBounds = dungeon.roomBounds();
        }
    }

    public boolean isBossFight() {
        return this.bossFight.m_8323_();
    }

    public void setBossFight(boolean isFighting) {
        this.bossFight.m_8321_(isFighting);
    }

    @Override
    @Nullable
    public ResourceLocation getBossBarTexture() {
        return new ResourceLocation("aether", "textures/gui/boss_bar_valkyrie_queen.png");
    }

    public void setDungeonBounds(@Nullable AABB dungeonBounds) {
        this.dungeonBounds = dungeonBounds;
    }

    @Override
    @Nullable
    public Player getConversingPlayer() {
        return this.conversingPlayer;
    }

    @Override
    public void setConversingPlayer(@Nullable Player player) {
        this.conversingPlayer = player;
    }

    public int getDeathScore() {
        return this.f_20897_;
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.setBossName(pName);
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AetherSoundEvents.ENTITY_VALKYRIE_QUEEN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_VALKYRIE_QUEEN_DEATH.get();
    }

    protected boolean m_6129_() {
        return this.f_20899_;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.addBossSaveData(tag);
        if (this.dungeonBounds != null) {
            tag.m_128347_("DungeonBoundsMinX", this.dungeonBounds.f_82288_);
            tag.m_128347_("DungeonBoundsMinY", this.dungeonBounds.f_82289_);
            tag.m_128347_("DungeonBoundsMinZ", this.dungeonBounds.f_82290_);
            tag.m_128347_("DungeonBoundsMaxX", this.dungeonBounds.f_82291_);
            tag.m_128347_("DungeonBoundsMaxY", this.dungeonBounds.f_82292_);
            tag.m_128347_("DungeonBoundsMaxZ", this.dungeonBounds.f_82293_);
        }
        tag.m_128379_("Ready", this.isReady());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.readBossSaveData(tag);
        if (tag.m_128441_("DungeonBoundsMinX")) {
            double minX = tag.m_128459_("DungeonBoundsMinX");
            double minY = tag.m_128459_("DungeonBoundsMinY");
            double minZ = tag.m_128459_("DungeonBoundsMinZ");
            double maxX = tag.m_128459_("DungeonBoundsMaxX");
            double maxY = tag.m_128459_("DungeonBoundsMaxY");
            double maxZ = tag.m_128459_("DungeonBoundsMaxZ");
            this.dungeonBounds = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
        }
        if (tag.m_128441_("Ready")) {
            this.setReady(tag.m_128471_("Ready"));
        }
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        CompoundTag tag = new CompoundTag();
        this.addBossSaveData(tag);
        buffer.m_130079_(tag);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        CompoundTag tag = additionalData.m_130260_();
        if (tag != null) {
            this.readBossSaveData(tag);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static class GetUnstuckGoal
    extends Goal {
        private final ValkyrieQueen valkyrie;
        protected int stuckTimer;

        public GetUnstuckGoal(ValkyrieQueen valkyrie) {
            this.valkyrie = valkyrie;
        }

        public boolean m_8036_() {
            LivingEntity target = this.valkyrie.m_5448_();
            if (target == null) {
                return false;
            }
            if (target.m_20186_() > this.valkyrie.m_20186_()) {
                if (this.stuckTimer++ >= 75) {
                    this.stuckTimer = 0;
                    return true;
                }
            } else {
                this.stuckTimer = 0;
            }
            return false;
        }

        public void m_8056_() {
            if (this.valkyrie.m_5448_() != null) {
                this.valkyrie.teleportUnstuck((Entity)this.valkyrie.m_5448_());
            }
        }
    }

    public static class ThunderCrystalAttackGoal
    extends Goal {
        private final Mob mob;
        private final int attackInterval;
        private final float attackRadius;
        private int attackTime = 0;

        public ThunderCrystalAttackGoal(Mob mob, int attackInterval, float attackRadius) {
            this.mob = mob;
            this.attackInterval = attackInterval;
            this.attackRadius = attackRadius;
        }

        public boolean m_8036_() {
            LivingEntity target = this.mob.m_5448_();
            if (target != null && target.m_6084_()) {
                return this.mob.m_9236_().m_46791_() != Difficulty.PEACEFUL;
            }
            return false;
        }

        public void m_8037_() {
            double distance;
            if (this.mob.m_5448_() != null && (distance = (double)this.mob.m_20270_((Entity)this.mob.m_5448_())) < (double)this.attackRadius && ++this.attackTime >= this.attackInterval) {
                ThunderCrystal thunderCrystal = new ThunderCrystal((EntityType<? extends ThunderCrystal>)((EntityType)AetherEntityTypes.THUNDER_CRYSTAL.get()), this.mob.m_9236_(), (Entity)this.mob, (Entity)this.mob.m_5448_());
                this.mob.m_9236_().m_7967_((Entity)thunderCrystal);
                this.attackTime = this.mob.m_217043_().m_188503_(40);
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }
}

