/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.projectile.crystal;

import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.client.particle.AetherParticleTypes;
import com.aetherteam.aether.data.resources.registries.AetherDamageTypes;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.projectile.crystal.AbstractCrystal;
import com.aetherteam.aether.entity.projectile.crystal.WeaknessDamage;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class IceCrystal
extends AbstractCrystal
implements WeaknessDamage {
    private double xPower;
    private double zPower;
    private boolean attacked = false;

    public IceCrystal(EntityType<? extends IceCrystal> entityType, Level level) {
        super(entityType, level);
    }

    public IceCrystal(Level level, Entity shooter) {
        this((EntityType<? extends IceCrystal>)((EntityType)AetherEntityTypes.ICE_CRYSTAL.get()), level);
        this.m_5602_(shooter);
        this.m_6034_(shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_());
        float rotation = this.f_19796_.m_188501_() * 360.0f;
        this.xPower = (double)Mth.m_14031_((float)rotation) * 0.2;
        this.zPower = (double)(-Mth.m_14089_((float)rotation)) * 0.2;
        this.m_20334_(this.xPower, 0.0, this.zPower);
    }

    protected void m_5790_(EntityHitResult result) {
        this.doDamage(result.m_82443_());
    }

    protected void m_8060_(BlockHitResult result) {
        if (this.attacked) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getImpactExplosionSoundEvent(), SoundSource.HOSTILE, 2.0f, this.f_19796_.m_188501_() - this.f_19796_.m_188501_() * 0.2f + 1.2f);
            if (!this.m_9236_().m_5776_()) {
                this.m_146870_();
            }
        } else {
            this.m_5834_();
            switch (result.m_82434_()) {
                case NORTH: 
                case SOUTH: {
                    this.zPower = -this.zPower;
                    break;
                }
                case WEST: 
                case EAST: {
                    this.xPower = -this.xPower;
                }
            }
            this.m_20334_(this.xPower, 0.0, this.zPower);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        this.m_5834_();
        Entity entity = source.m_7639_();
        if (entity != null) {
            if (!this.m_9236_().m_5776_()) {
                Vec3 vec3 = entity.m_20154_();
                this.xPower = vec3.m_7096_() * 2.5;
                this.zPower = vec3.m_7094_() * 2.5;
                this.m_20334_(this.xPower, 0.0, this.zPower);
                this.m_5602_(entity);
                this.attacked = true;
            }
            return true;
        }
        return false;
    }

    public void doDamage(Entity entity) {
        LivingEntity livingEntity;
        if (this.m_19749_() != entity && entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6469_(AetherDamageTypes.indirectEntityDamageSource(this.m_9236_(), AetherDamageTypes.ICE_CRYSTAL, (Entity)this, this.m_19749_()), 7.0f)) {
            WeaknessDamage.super.damageWithWeakness(this, livingEntity, this.f_19796_);
        }
    }

    @Override
    protected ParticleOptions getExplosionParticle() {
        return (ParticleOptions)AetherParticleTypes.FROZEN.get();
    }

    @Override
    @Nullable
    public SoundEvent getImpactExplosionSoundEvent() {
        return (SoundEvent)AetherSoundEvents.ENTITY_ICE_CRYSTAL_EXPLODE.get();
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128347_("XSpeed", this.xPower);
        tag.m_128347_("ZSpeed", this.zPower);
        tag.m_128379_("Attacked", this.attacked);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.xPower = tag.m_128459_("XSpeed");
        this.zPower = tag.m_128459_("ZSpeed");
        this.attacked = tag.m_128471_("Attacked");
    }
}

