/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.network.packet.serverbound;

import com.aetherteam.aether.perk.data.ServerPerkData;
import com.aetherteam.aether.perk.types.MoaData;
import com.aetherteam.nitrogen.network.BasePacket;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public abstract class ServerMoaSkinPacket {

    public record Remove(UUID playerUUID) implements BasePacket
    {
        public void encode(FriendlyByteBuf buf) {
            buf.m_130077_(this.playerUUID());
        }

        public static Remove decode(FriendlyByteBuf buf) {
            UUID uuid = buf.m_130259_();
            return new Remove(uuid);
        }

        public void execute(@Nullable Player playerEntity) {
            if (playerEntity != null && playerEntity.m_20194_() != null && this.playerUUID() != null) {
                ServerPerkData.MOA_SKIN_INSTANCE.removePerk(playerEntity.m_20194_(), this.playerUUID());
            }
        }
    }

    public record Apply(UUID playerUUID, MoaData moaSkinData) implements BasePacket
    {
        public void encode(FriendlyByteBuf buf) {
            buf.m_130077_(this.playerUUID());
            MoaData.write(buf, this.moaSkinData());
        }

        public static Apply decode(FriendlyByteBuf buf) {
            UUID uuid = buf.m_130259_();
            MoaData moaSkinData = MoaData.read(buf);
            return new Apply(uuid, moaSkinData);
        }

        public void execute(@Nullable Player playerEntity) {
            if (playerEntity != null && playerEntity.m_20194_() != null && this.playerUUID() != null && this.moaSkinData() != null) {
                ServerPerkData.MOA_SKIN_INSTANCE.applyPerkWithVerification(playerEntity.m_20194_(), this.playerUUID(), this.moaSkinData());
            }
        }
    }
}

