/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.items.elementium;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.melanx.aiotbotania.items.ItemTiers;
import de.melanx.aiotbotania.items.base.ItemAIOTBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.entity.GaiaGuardianEntity;
import vazkii.botania.common.handler.PixieHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemElementiumAIOT
extends ItemAIOTBase {
    private static final int MANA_PER_DAMAGE = 66;
    private static final float DAMAGE = 6.0f;
    private static final float SPEED = -2.2f;

    public ItemElementiumAIOT() {
        super(ItemTiers.ELEMENTIUM_AIOT_ITEM_TIER, 6.0f, -2.2f, 66, true);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityDrops);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment.f_44672_.m_7454_(BotaniaItems.elementiumSword);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap ret = super.m_7167_(slot);
        if (slot == EquipmentSlot.MAINHAND) {
            ret = HashMultimap.create((Multimap)ret);
            ret.put((Object)PixieHandler.PIXIE_SPAWN_CHANCE, (Object)PixieHandler.makeModifier((EquipmentSlot)slot, (String)"AIOT modifier", (double)0.1));
        }
        return ret;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        Level level = player.m_9236_();
        if (this.m_8102_(stack, level.m_8055_(pos)) <= 1.0f) {
            return false;
        }
        Block block = level.m_8055_(pos).m_60734_();
        if (block instanceof FallingBlock) {
            ToolCommons.removeBlocksInIteration((Player)player, (ItemStack)stack, (Level)level, (BlockPos)pos, (Vec3i)new Vec3i(0, -12, 0), (Vec3i)new Vec3i(1, 12, 1), state -> state.m_60734_() == block);
        }
        return false;
    }

    private void onEntityDrops(LivingDropsEvent event) {
        ItemStack weapon;
        if (event.isRecentlyHit() && event.getSource().m_7639_() != null && event.getSource().m_7639_() instanceof Player && !(weapon = ((Player)event.getSource().m_7639_()).m_21205_()).m_41619_() && weapon.m_41720_() == this) {
            RandomSource rand = event.getEntity().m_9236_().f_46441_;
            int looting = weapon.getEnchantmentLevel(Enchantments.f_44987_);
            if (event.getEntity() instanceof AbstractSkeleton && rand.m_188503_(26) <= 3 + looting) {
                this.addDrop(event, new ItemStack((ItemLike)(event.getEntity() instanceof WitherSkeleton ? Items.f_42679_ : Items.f_42678_)));
            } else if (event.getEntity() instanceof Zombie && !(event.getEntity() instanceof ZombifiedPiglin) && rand.m_188503_(26) <= 2 + 2 * looting) {
                this.addDrop(event, new ItemStack((ItemLike)Items.f_42681_));
            } else if (event.getEntity() instanceof Creeper && rand.m_188503_(26) <= 2 + 2 * looting) {
                this.addDrop(event, new ItemStack((ItemLike)Items.f_42682_));
            } else if (event.getEntity() instanceof Player && rand.m_188503_(11) <= 1 + looting) {
                ItemStack stack = new ItemStack((ItemLike)Items.f_42680_);
                ItemNBTHelper.setString((ItemStack)stack, (String)"SkullOwner", (String)((Player)event.getEntity()).m_36316_().getName());
                this.addDrop(event, stack);
            } else if (event.getEntity() instanceof GaiaGuardianEntity && rand.m_188503_(13) < 1 + looting) {
                this.addDrop(event, new ItemStack((ItemLike)BotaniaBlocks.gaiaHead));
            }
        }
    }

    private void addDrop(LivingDropsEvent event, ItemStack drop) {
        ItemEntity entity = new ItemEntity(event.getEntity().m_9236_(), event.getEntity().f_19790_, event.getEntity().f_19791_, event.getEntity().f_19792_, drop);
        entity.m_32010_(10);
        event.getDrops().add(entity);
    }
}

