/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.block.compactor;

import com.smashingmods.alchemistry.Alchemistry;
import com.smashingmods.alchemistry.Config;
import com.smashingmods.alchemistry.common.block.compactor.CompactorMenu;
import com.smashingmods.alchemistry.common.network.SetRecipePacket;
import com.smashingmods.alchemistry.common.recipe.compactor.CompactorRecipe;
import com.smashingmods.alchemistry.registry.BlockEntityRegistry;
import com.smashingmods.alchemistry.registry.RecipeRegistry;
import com.smashingmods.alchemylib.api.blockentity.processing.AbstractSearchableBlockEntity;
import com.smashingmods.alchemylib.api.recipe.AbstractProcessingRecipe;
import com.smashingmods.alchemylib.api.storage.EnergyStorageHandler;
import com.smashingmods.alchemylib.api.storage.ProcessingSlotHandler;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CompactorBlockEntity
extends AbstractSearchableBlockEntity {
    private CompactorRecipe currentRecipe;
    private ResourceLocation recipeId;

    public CompactorBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super("alchemistry", (BlockEntityType)BlockEntityRegistry.COMPACTOR_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
        this.setEnergyPerTick((Integer)Config.Common.compactorEnergyPerTick.get());
        this.setMaxProgress((Integer)Config.Common.compactorTicksPerOperation.get());
    }

    public void onLoad() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            RecipeRegistry.getCompactorRecipe(recipe -> recipe.m_6423_().equals((Object)this.recipeId), this.f_58857_).ifPresent(this::setRecipe);
        }
        super.onLoad();
    }

    public void updateRecipe() {
        if (!(this.f_58857_ == null || this.f_58857_.m_5776_() || this.getInputHandler().isEmpty() || this.isRecipeLocked())) {
            RecipeRegistry.getCompactorRecipe(recipe -> recipe.getInput().matches(this.getInputHandler().getStackInSlot(0)), this.f_58857_).ifPresent(recipe -> {
                if (this.currentRecipe == null || !((Object)((Object)this.currentRecipe)).equals(recipe)) {
                    this.setProgress(0);
                    this.setRecipe(recipe);
                }
            });
        }
    }

    public boolean canProcessRecipe() {
        if (this.currentRecipe != null) {
            ItemStack input = this.getInputHandler().getStackInSlot(0);
            ItemStack output = this.getOutputHandler().getStackInSlot(0);
            return this.getEnergyHandler().getEnergyStored() >= this.getEnergyPerTick() && this.currentRecipe.getInput().matches(input) && input.m_41613_() >= this.currentRecipe.getInput().getCount() && this.currentRecipe.getOutput().m_41613_() + output.m_41613_() <= this.currentRecipe.getOutput().m_41741_() && (ItemStack.m_150942_((ItemStack)output, (ItemStack)this.currentRecipe.getOutput()) || output.m_41619_());
        }
        return false;
    }

    public void processRecipe() {
        if (this.getProgress() < this.getMaxProgress()) {
            this.incrementProgress();
        } else {
            CompactorRecipe tempRecipe = this.currentRecipe.copy();
            this.setProgress(0);
            this.getOutputHandler().setOrIncrement(0, tempRecipe.getOutput());
            this.getInputHandler().decrementSlot(0, tempRecipe.getInput().getCount());
        }
        this.getEnergyHandler().extractEnergy(this.getEnergyPerTick(), false);
        this.m_6596_();
    }

    public <R extends AbstractProcessingRecipe> void setRecipe(@Nullable R pRecipe) {
        if (pRecipe instanceof CompactorRecipe) {
            CompactorRecipe compactorRecipe;
            this.currentRecipe = compactorRecipe = (CompactorRecipe)pRecipe;
        }
    }

    public CompactorRecipe getRecipe() {
        return this.currentRecipe;
    }

    public LinkedList<CompactorRecipe> getAllRecipes() {
        if (this.f_58857_ != null) {
            return new LinkedList<CompactorRecipe>(RecipeRegistry.getCompactorRecipes(this.f_58857_));
        }
        return new LinkedList<CompactorRecipe>();
    }

    public EnergyStorageHandler initializeEnergyStorage() {
        return new EnergyStorageHandler((Integer)Config.Common.compactorEnergyCapacity.get()){

            protected void onEnergyChanged() {
                CompactorBlockEntity.this.m_6596_();
            }
        };
    }

    public ProcessingSlotHandler initializeInputHandler() {
        return new ProcessingSlotHandler(1){

            protected void onContentsChanged(int slot) {
                CompactorBlockEntity.this.updateRecipe();
                CompactorBlockEntity.this.setCanProcess(CompactorBlockEntity.this.canProcessRecipe());
                CompactorBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int pSlot, @Nonnull ItemStack pItemStack) {
                if (CompactorBlockEntity.this.f_58857_ != null && !CompactorBlockEntity.this.f_58857_.m_5776_() && pSlot == 0 && CompactorBlockEntity.this.currentRecipe != null && CompactorBlockEntity.this.isRecipeLocked()) {
                    return CompactorBlockEntity.this.currentRecipe.getInput().matches(pItemStack);
                }
                return super.isItemValid(pSlot, pItemStack);
            }
        };
    }

    public ProcessingSlotHandler initializeOutputHandler() {
        return new ProcessingSlotHandler(1){

            public boolean isItemValid(int slot, ItemStack stack) {
                return false;
            }
        };
    }

    protected void m_183515_(CompoundTag pTag) {
        if (this.currentRecipe != null) {
            pTag.m_128359_("recipeId", this.currentRecipe.m_6423_().toString());
        }
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.recipeId = ResourceLocation.m_135820_((String)pTag.m_128461_("recipeId"));
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            RecipeRegistry.getCompactorRecipe(recipe -> recipe.m_6423_().equals((Object)this.recipeId), this.f_58857_).ifPresent(recipe -> {
                if (!((Object)recipe).equals((Object)this.currentRecipe)) {
                    this.setRecipe(recipe);
                    Alchemistry.PACKET_HANDLER.sendToServer(new SetRecipePacket(this.m_58899_(), recipe.m_6423_(), recipe.m_6076_()));
                }
            });
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new CompactorMenu(pContainerId, pInventory, (BlockEntity)this);
    }
}

