/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthetweaks.datagen;

import com.thevortex.allthetweaks.datagen.client.ItemModels;
import com.thevortex.allthetweaks.datagen.server.BlockTags;
import com.thevortex.allthetweaks.datagen.server.ItemTags;
import com.thevortex.allthetweaks.datagen.server.LootTables;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class DataGenerators {
    private DataGenerators() {
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) throws IOException {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new ItemModels(generator, fileHelper));
        }
        if (event.includeServer()) {
            BlockTags blockTags = new BlockTags(packOutput, event.getLookupProvider(), fileHelper);
            generator.addProvider(true, (DataProvider)new ItemTags(packOutput, event.getLookupProvider(), blockTags.m_274426_(), fileHelper));
            generator.addProvider(true, (DataProvider)blockTags);
            generator.addProvider(true, (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(LootTables::new, LootContextParamSets.f_81421_))));
        }
    }
}

