/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.config.Actionable;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TypeFilter;
import appeng.api.config.ViewItems;
import appeng.api.features.IGridLinkableHandler;
import appeng.api.implementations.blockentities.IWirelessAccessPoint;
import appeng.api.implementations.menuobjects.IMenuItem;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.networking.IGrid;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableItem;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.upgrades.Upgrades;
import appeng.api.util.IConfigManager;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.core.localization.Tooltips;
import appeng.helpers.WirelessTerminalMenuHost;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.common.MEStorageMenu;
import appeng.util.ConfigManager;
import appeng.util.Platform;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.function.DoubleSupplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WirelessTerminalItem
extends AEBasePoweredItem
implements IMenuItem,
IUpgradeableItem {
    private static final Logger LOG = LoggerFactory.getLogger(WirelessTerminalItem.class);
    public static final IGridLinkableHandler LINKABLE_HANDLER = new LinkableHandler();
    private static final String TAG_ACCESS_POINT_POS = "accessPoint";

    public WirelessTerminalItem(DoubleSupplier powerCapacity, Item.Properties props) {
        super(powerCapacity, props);
    }

    @Override
    public double getChargeRate(ItemStack stack) {
        return 800.0 + 800.0 * (double)Upgrades.getEnergyCardMultiplier(this.getUpgrades(stack));
    }

    public boolean openFromInventory(Player player, int inventorySlot) {
        return this.openFromInventory(player, inventorySlot, false);
    }

    protected boolean openFromInventory(Player player, int inventorySlot, boolean returningFromSubmenu) {
        ItemStack is = player.m_150109_().m_8020_(inventorySlot);
        if (this.checkPreconditions(is, player)) {
            return MenuOpener.open(this.getMenuType(), player, MenuLocators.forInventorySlot(inventorySlot), returningFromSubmenu);
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack is = player.m_21120_(hand);
        if (this.checkPreconditions(is, player) && MenuOpener.open(this.getMenuType(), player, MenuLocators.forHand(player, hand))) {
            return new InteractionResultHolder(InteractionResult.m_19078_((boolean)level.m_5776_()), (Object)is);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)is);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> lines, TooltipFlag advancedTooltips) {
        super.m_7373_(stack, level, lines, advancedTooltips);
        if (this.getLinkedPosition(stack) == null) {
            lines.add((Component)Tooltips.of(GuiText.Unlinked, Tooltips.RED, new Object[0]));
        } else {
            lines.add((Component)Tooltips.of(GuiText.Linked, Tooltips.GREEN, new Object[0]));
        }
    }

    @Nullable
    public GlobalPos getLinkedPosition(ItemStack item) {
        CompoundTag tag = item.m_41783_();
        if (tag != null && tag.m_128425_(TAG_ACCESS_POINT_POS, 10)) {
            return GlobalPos.f_122633_.decode((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_(TAG_ACCESS_POINT_POS)).resultOrPartial(Util.m_137489_((String)"Linked position", arg_0 -> ((Logger)LOG).error(arg_0))).map(Pair::getFirst).orElse(null);
        }
        return null;
    }

    @Nullable
    public IGrid getLinkedGrid(ItemStack item, Level level, @Nullable Player sendMessagesTo) {
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        GlobalPos linkedPos = this.getLinkedPosition(item);
        if (linkedPos == null) {
            if (sendMessagesTo != null) {
                sendMessagesTo.m_5661_((Component)PlayerMessages.DeviceNotLinked.text(), true);
            }
            return null;
        }
        ServerLevel linkedLevel = serverLevel.m_7654_().m_129880_(linkedPos.m_122640_());
        if (linkedLevel == null) {
            if (sendMessagesTo != null) {
                sendMessagesTo.m_5661_((Component)PlayerMessages.LinkedNetworkNotFound.text(), true);
            }
            return null;
        }
        BlockEntity be = Platform.getTickingBlockEntity((Level)linkedLevel, linkedPos.m_122646_());
        if (!(be instanceof IWirelessAccessPoint)) {
            if (sendMessagesTo != null) {
                sendMessagesTo.m_5661_((Component)PlayerMessages.LinkedNetworkNotFound.text(), true);
            }
            return null;
        }
        IWirelessAccessPoint accessPoint = (IWirelessAccessPoint)be;
        IGrid grid = accessPoint.getGrid();
        if (grid == null && sendMessagesTo != null) {
            sendMessagesTo.m_5661_((Component)PlayerMessages.LinkedNetworkNotFound.text(), true);
        }
        return grid;
    }

    public MenuType<?> getMenuType() {
        return MEStorageMenu.WIRELESS_TYPE;
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    @Override
    @Nullable
    public ItemMenuHost getMenuHost(Player player, int inventorySlot, ItemStack stack, @Nullable BlockPos pos) {
        return new WirelessTerminalMenuHost(player, inventorySlot, stack, (p, subMenu) -> this.openFromInventory((Player)p, inventorySlot, true));
    }

    protected boolean checkPreconditions(ItemStack item, Player player) {
        if (item.m_41619_() || item.m_41720_() != this) {
            return false;
        }
        Level level = player.m_20193_();
        if (this.getLinkedGrid(item, player.m_9236_(), player) == null) {
            return false;
        }
        if (!this.hasPower(player, 0.5, item)) {
            player.m_5661_((Component)PlayerMessages.DeviceNotPowered.text(), true);
            return false;
        }
        return true;
    }

    public boolean usePower(Player player, double amount, ItemStack is) {
        return this.extractAEPower(is, amount, Actionable.MODULATE) >= amount - 0.5;
    }

    public boolean hasPower(Player player, double amt, ItemStack is) {
        return this.getAECurrentPower(is) >= amt;
    }

    public IConfigManager getConfigManager(ItemStack target) {
        ConfigManager out = new ConfigManager((manager, settingName) -> manager.writeToNBT(target.m_41784_()));
        out.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        out.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        out.registerSetting(Settings.TYPE_FILTER, TypeFilter.ALL);
        out.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
        out.readFromNBT(target.m_41784_().m_6426_());
        return out;
    }

    @Override
    public IUpgradeInventory getUpgrades(ItemStack stack) {
        return UpgradeInventories.forItem(stack, 2, this::onUpgradesChanged);
    }

    private void onUpgradesChanged(ItemStack stack, IUpgradeInventory upgrades) {
        this.setAEMaxPowerMultiplier(stack, 1 + Upgrades.getEnergyCardMultiplier(upgrades));
    }

    private static class LinkableHandler
    implements IGridLinkableHandler {
        private LinkableHandler() {
        }

        @Override
        public boolean canLink(ItemStack stack) {
            return stack.m_41720_() instanceof WirelessTerminalItem;
        }

        @Override
        public void link(ItemStack itemStack, GlobalPos pos) {
            GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)pos).result().ifPresent(tag -> itemStack.m_41784_().m_128365_(WirelessTerminalItem.TAG_ACCESS_POINT_POS, tag));
        }

        @Override
        public void unlink(ItemStack itemStack) {
            itemStack.m_41749_(WirelessTerminalItem.TAG_ACCESS_POINT_POS);
        }
    }
}

