/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.behaviors.PickupSink;
import appeng.api.behaviors.PickupStrategy;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.stacks.AEItemKey;
import appeng.core.AppEng;
import appeng.core.sync.packets.BlockTransitionEffectPacket;
import appeng.core.sync.packets.ItemTransitionEffectPacket;
import appeng.util.Platform;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class ItemPickupStrategy
implements PickupStrategy {
    public static final ResourceLocation TAG_BLACKLIST = new ResourceLocation("ae2", "blacklisted/annihilation_plane");
    private static final TagKey<Block> BLOCK_BLACKLIST = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)TAG_BLACKLIST);
    private static final TagKey<Item> ITEM_BLACKLIST = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)TAG_BLACKLIST);
    private final ServerLevel level;
    private final BlockPos pos;
    private final Direction side;
    private final Map<Enchantment, Integer> enchantments;
    @Nullable
    private final UUID ownerUuid;
    private boolean isAccepting = true;

    public ItemPickupStrategy(ServerLevel level, BlockPos pos, Direction side, BlockEntity host, Map<Enchantment, Integer> enchantments, @Nullable UUID owningPlayerId) {
        this.level = level;
        this.pos = pos;
        this.side = side;
        this.enchantments = enchantments;
        this.ownerUuid = owningPlayerId;
    }

    @Override
    public void reset() {
        this.isAccepting = true;
    }

    @Override
    public boolean canPickUpEntity(Entity entity) {
        return entity instanceof ItemEntity;
    }

    @Override
    public boolean pickUpEntity(IEnergySource energySource, PickupSink sink, Entity entity) {
        if (!this.isAccepting || !(entity instanceof ItemEntity)) {
            return false;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        if (ItemPickupStrategy.isItemBlacklisted(itemEntity.m_32055_().m_41720_())) {
            return false;
        }
        boolean changed = this.storeEntityItem(sink, itemEntity);
        if (changed) {
            AppEng.instance().sendToAllNearExcept(null, this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_(), 64.0, (Level)this.level, new ItemTransitionEffectPacket(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.side));
        }
        return true;
    }

    @Override
    public PickupStrategy.Result tryPickup(IEnergySource energySource, PickupSink sink) {
        BlockState blockState;
        if (this.isAccepting && this.canHandleBlock(this.level, this.pos, blockState = this.level.m_8055_(this.pos))) {
            List<ItemStack> items = this.obtainBlockDrops(this.level, this.pos);
            float requiredPower = this.calculateEnergyUsage(this.level, this.pos, items);
            boolean hasPower = energySource.extractAEPower(requiredPower, Actionable.SIMULATE, PowerMultiplier.CONFIG) > (double)requiredPower - 0.1;
            boolean canStore = this.canStoreItemStacks(sink, items);
            if (hasPower && canStore) {
                this.completePickup(energySource, sink, items, requiredPower, blockState);
                return PickupStrategy.Result.PICKED_UP;
            }
            return PickupStrategy.Result.CANT_STORE;
        }
        return PickupStrategy.Result.CANT_PICKUP;
    }

    private void completePickup(IEnergySource energySource, PickupSink sink, List<ItemStack> items, float requiredPower, BlockState blockState) {
        if (!this.breakBlockAndStoreExtraItems(sink, this.level, this.pos)) {
            return;
        }
        for (ItemStack item : items) {
            int inserted = this.storeItemStack(sink, item);
            if (inserted >= item.m_41613_()) continue;
            item.m_41774_(inserted);
            Platform.spawnDrops((Level)this.level, this.pos, Collections.singletonList(item));
        }
        energySource.extractAEPower(requiredPower, Actionable.MODULATE, PowerMultiplier.CONFIG);
        AppEng.instance().sendToAllNearExcept(null, this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_(), 64.0, (Level)this.level, new BlockTransitionEffectPacket(this.pos, blockState, this.side, BlockTransitionEffectPacket.SoundMode.NONE));
    }

    private boolean storeEntityItem(PickupSink sink, ItemEntity entityItem) {
        if (entityItem.m_6084_()) {
            int inserted = this.storeItemStack(sink, entityItem.m_32055_());
            return this.handleOverflow(entityItem, inserted);
        }
        return false;
    }

    private int storeItemStack(PickupSink sink, ItemStack item) {
        int amount;
        if (item.m_41619_()) {
            return 0;
        }
        AEItemKey what = AEItemKey.of(item);
        int inserted = (int)sink.insert(what, amount = item.m_41613_(), Actionable.MODULATE);
        this.isAccepting = inserted >= amount;
        return inserted;
    }

    private boolean handleOverflow(ItemEntity entityItem, int inserted) {
        int entityItemCount = entityItem.m_32055_().m_41613_();
        if (inserted >= entityItemCount) {
            entityItem.m_146870_();
            return true;
        }
        int newStackSize = entityItemCount - inserted;
        boolean changed = entityItemCount != newStackSize;
        entityItem.m_32055_().m_41764_(newStackSize);
        return changed;
    }

    private boolean canHandleBlock(ServerLevel level, BlockPos pos, BlockState state) {
        if (state.m_60795_()) {
            return false;
        }
        if (ItemPickupStrategy.isBlockBlacklisted(state.m_60734_())) {
            return false;
        }
        float hardness = state.m_60800_((BlockGetter)level, pos);
        boolean ignoreAirAndFluids = state.m_60795_() || state.m_278721_();
        return !ignoreAirAndFluids && hardness >= 0.0f && level.m_46749_(pos) && level.m_7966_(Platform.getFakePlayer(level, this.ownerUuid), pos);
    }

    protected List<ItemStack> obtainBlockDrops(ServerLevel level, BlockPos pos) {
        Player fakePlayer = Platform.getFakePlayer(level, this.ownerUuid);
        BlockState state = level.m_8055_(pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        HarvestTool harvestTool = this.createHarvestTool(state);
        ItemStack harvestToolItem = harvestTool.item();
        if (!state.m_60834_() && harvestTool.fallback()) {
            harvestToolItem = ItemStack.f_41583_;
        }
        List drops = Block.m_49874_((BlockState)state, (ServerLevel)level, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)fakePlayer, (ItemStack)harvestToolItem);
        return drops.stream().filter(stack -> !stack.m_41619_()).toList();
    }

    protected float calculateEnergyUsage(ServerLevel level, BlockPos pos, List<ItemStack> items) {
        boolean useEnergy = true;
        BlockState state = level.m_8055_(pos);
        float hardness = state.m_60800_((BlockGetter)level, pos);
        float requiredEnergy = 1.0f + hardness;
        for (ItemStack is : items) {
            requiredEnergy += (float)is.m_41613_();
        }
        if (this.enchantments != null) {
            float efficiencyFactor = 1.0f;
            int efficiencyLevel = 0;
            if (this.enchantments.containsKey(Enchantments.f_44984_)) {
                efficiencyLevel = this.enchantments.get(Enchantments.f_44984_);
                efficiencyFactor = (float)((double)efficiencyFactor * Math.pow(0.85, efficiencyLevel));
            }
            if (this.enchantments.containsKey(Enchantments.f_44986_)) {
                int randomNumber = ThreadLocalRandom.current().nextInt(this.enchantments.get(Enchantments.f_44986_) + 1);
                useEnergy = randomNumber == 0;
            }
            int levelSum = this.enchantments.values().stream().reduce(0, Integer::sum) - efficiencyLevel;
            requiredEnergy *= (float)(8 * levelSum) * efficiencyFactor;
        }
        return useEnergy ? requiredEnergy : 0.0f;
    }

    private boolean canStoreItemStacks(PickupSink sink, List<ItemStack> itemStacks) {
        boolean canStore = itemStacks.isEmpty();
        for (ItemStack itemStack : itemStacks) {
            AEItemKey itemToTest = AEItemKey.of(itemStack);
            long inserted = sink.insert(itemToTest, itemStack.m_41613_(), Actionable.SIMULATE);
            if (inserted <= 0L) continue;
            canStore = true;
        }
        this.isAccepting = canStore;
        return canStore;
    }

    private boolean breakBlockAndStoreExtraItems(PickupSink sink, ServerLevel level, BlockPos pos) {
        if (!level.m_46961_(pos, false)) {
            return false;
        }
        AABB box = new AABB(pos).m_82400_(0.2);
        for (ItemEntity itemEntity : level.m_45976_(ItemEntity.class, box)) {
            this.storeEntityItem(sink, itemEntity);
        }
        return true;
    }

    private HarvestTool createHarvestTool(BlockState state) {
        ItemStack tool;
        boolean fallback = false;
        if (state.m_204336_(BlockTags.f_144282_)) {
            tool = new ItemStack((ItemLike)Items.f_42390_, 1);
        } else if (state.m_204336_(BlockTags.f_144280_)) {
            tool = new ItemStack((ItemLike)Items.f_42391_, 1);
        } else if (state.m_204336_(BlockTags.f_144283_)) {
            tool = new ItemStack((ItemLike)Items.f_42389_, 1);
        } else if (state.m_204336_(BlockTags.f_144281_)) {
            tool = new ItemStack((ItemLike)Items.f_42392_, 1);
        } else {
            tool = new ItemStack((ItemLike)Items.f_42390_, 1);
            fallback = true;
        }
        if (this.enchantments != null) {
            EnchantmentHelper.m_44865_(this.enchantments, (ItemStack)tool);
            fallback = false;
        }
        return new HarvestTool(tool, fallback);
    }

    public static boolean isBlockBlacklisted(Block b) {
        return b.m_204297_().m_203656_(BLOCK_BLACKLIST);
    }

    public static boolean isItemBlacklisted(Item i) {
        return i.m_204114_().m_203656_(ITEM_BLACKLIST);
    }

    record HarvestTool(ItemStack item, boolean fallback) {
    }
}

