/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.mages;

import alexthw.ars_elemental.ArsNouveauRegistry;
import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.api.item.ISchoolFocus;
import alexthw.ars_elemental.api.item.ISchoolProvider;
import alexthw.ars_elemental.common.entity.ai.ProjCastingGoal;
import alexthw.ars_elemental.common.entity.ai.SelfCastGoal;
import alexthw.ars_elemental.common.items.armor.ArmorSet;
import alexthw.ars_elemental.registry.ModItems;
import alexthw.ars_elemental.util.ParticleUtil;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.armor.AnimatedMagicArmor;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHarm;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHeal;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodSelf;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityMageBase
extends Monster
implements RangedAttackMob,
ISchoolProvider {
    public final List<Spell> pSpells = new ArrayList<Spell>();
    public final List<Spell> sSpells = new ArrayList<Spell>();
    public SpellSchool school;
    public int castCooldown = 0;

    protected EntityMageBase(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.pSpells.add(new Spell(new AbstractSpellPart[]{MethodProjectile.INSTANCE, EffectHarm.INSTANCE, AugmentAmplify.INSTANCE}));
        this.sSpells.add(new Spell(new AbstractSpellPart[]{MethodSelf.INSTANCE, EffectHeal.INSTANCE, AugmentAmplify.INSTANCE}));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.castCooldown > 0) {
            --this.castCooldown;
        }
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, EntityMageBase.class, true, e -> {
            if (!(e instanceof EntityMageBase)) return false;
            EntityMageBase mage = (EntityMageBase)e;
            if (this.school == mage.school) return false;
            return true;
        }));
        if (((Boolean)ConfigHandler.Common.MAGES_AGGRO.get()).booleanValue()) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, e -> {
                Player player;
                return e instanceof Player && ISchoolFocus.hasFocus((Entity)(player = (Player)e)) != this.school;
            }));
        }
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(10, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true, e -> !(e instanceof EntityMageBase)));
        this.f_21345_.m_25352_(3, new ProjCastingGoal<EntityMageBase>(this, 1.0, 30, 64.0f, () -> this.castCooldown <= 0, 0, 10));
        this.f_21345_.m_25352_(6, new SelfCastGoal<EntityMageBase>(this, 20, 0, () -> this.castCooldown <= 0 && this.m_21223_() < this.m_21233_() / 4.0f, 0, 10));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new FloatGoal((Mob)this));
        super.m_8099_();
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.m_213945_(pLevel.m_213780_(), pDifficulty);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected void m_213945_(@NotNull RandomSource randomSource, @NotNull DifficultyInstance pDifficulty) {
        super.m_213945_(randomSource, pDifficulty);
        if (this.school != null) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                this.m_8061_(slot, EntityMageBase.getArmorForSlot(slot, this.school));
            }
        } else {
            this.m_8061_(EquipmentSlot.HEAD, ((AnimatedMagicArmor)ItemsRegistry.BATTLEMAGE_HOOD.get()).m_7968_());
            this.m_8061_(EquipmentSlot.CHEST, ((AnimatedMagicArmor)ItemsRegistry.BATTLEMAGE_ROBES.get()).m_7968_());
            this.m_8061_(EquipmentSlot.LEGS, ((AnimatedMagicArmor)ItemsRegistry.BATTLEMAGE_LEGGINGS.get()).m_7968_());
            this.m_8061_(EquipmentSlot.FEET, ((AnimatedMagicArmor)ItemsRegistry.BATTLEMAGE_BOOTS.get()).m_7968_());
        }
        this.m_21008_(InteractionHand.MAIN_HAND, ((SpellBook)ItemsRegistry.APPRENTICE_SPELLBOOK.get()).m_7968_());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 16.0);
    }

    public void m_6504_(@NotNull LivingEntity pTarget, float pDistanceFactor) {
        Spell spell = this.pSpells.get(this.f_19796_.m_188503_(this.pSpells.size()));
        ParticleColor color = ParticleUtil.schoolToColor(this.school.getId());
        EntitySpellResolver resolver = new EntitySpellResolver(new SpellContext(this.m_9236_(), spell, (LivingEntity)this, (IWrappedCaster)new LivingCaster((LivingEntity)this)).withColors(color));
        resolver.onCast(ItemStack.f_41583_, this.m_9236_());
        this.castCooldown = 40;
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("cast", this.castCooldown);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.castCooldown = tag.m_128451_("cast");
    }

    protected boolean m_6125_() {
        return false;
    }

    public boolean m_7307_(@NotNull Entity pEntity) {
        return super.m_7307_(pEntity) || this.school.equals(ISchoolFocus.hasFocus(pEntity));
    }

    public int m_5792_() {
        return 1;
    }

    public int m_213860_() {
        return 15;
    }

    protected void m_7472_(@NotNull DamageSource pSource, int pLooting, boolean pRecentlyHit) {
    }

    public static ItemStack getArmorForSlot(EquipmentSlot slot, SpellSchool school) {
        Item item;
        switch (slot) {
            case HEAD: {
                Item item2 = EntityMageBase.getArmorSetFromElement(school).getHat();
                break;
            }
            case CHEST: {
                Item item2 = EntityMageBase.getArmorSetFromElement(school).getChest();
                break;
            }
            case LEGS: {
                Item item2 = EntityMageBase.getArmorSetFromElement(school).getLegs();
                break;
            }
            case FEET: {
                Item item2 = EntityMageBase.getArmorSetFromElement(school).getBoots();
                break;
            }
            default: {
                Item item2 = item = null;
            }
        }
        if (item == null) {
            return ItemStack.f_41583_;
        }
        return item.m_7968_();
    }

    private static ArmorSet getArmorSetFromElement(SpellSchool school) {
        return switch (school.getId()) {
            case "fire" -> ModItems.FIRE_ARMOR;
            case "water" -> ModItems.WATER_ARMOR;
            case "earth" -> ModItems.EARTH_ARMOR;
            case "air" -> ModItems.AIR_ARMOR;
            default -> new ArmorSet("necro", ArsNouveauRegistry.NECROMANCY);
        };
    }

    @Override
    public SpellSchool getSchool() {
        return this.school;
    }
}

