/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.common.glyphs.ElementalAbstractEffect;
import alexthw.ars_elemental.registry.ModPotions;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.IDamageEffect;
import com.hollingsworth.arsnouveau.api.spell.IPotionEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import java.util.Set;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectEnvenom
extends ElementalAbstractEffect
implements IPotionEffect,
IDamageEffect {
    public static EffectEnvenom INSTANCE = new EffectEnvenom();

    public EffectEnvenom() {
        super("envenom", "Envenom");
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        LivingEntity target;
        Entity entity = rayTraceResult.m_82443_();
        if (entity instanceof LivingEntity && this.canDamage(shooter, spellStats, spellContext, resolver, (Entity)(target = (LivingEntity)entity))) {
            MobEffectInstance poison = target.m_21124_(MobEffects.f_19614_);
            if (poison != null) {
                spellStats.setAmpMultiplier((double)((float)poison.m_19564_() / 2.0f) + spellStats.getAmpMultiplier());
                this.applyConfigPotion(target, (MobEffect)ModPotions.VENOM.get(), spellStats);
            } else {
                this.applyConfigPotion(target, MobEffects.f_19614_, spellStats);
            }
        }
    }

    public int getDefaultManaCost() {
        return 20;
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.getPotionAugments();
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.ELEMENTAL_EARTH});
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addPotionConfig(builder, 5);
        this.addExtendTimeConfig(builder, 5);
    }

    public int getBaseDuration() {
        return this.POTION_TIME == null ? 30 : (Integer)this.POTION_TIME.get();
    }

    public int getExtendTimeDuration() {
        return this.EXTEND_TIME == null ? 8 : (Integer)this.EXTEND_TIME.get();
    }
}

