/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.common.glyphs.ElementalAbstractEffect;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.IDamageEffect;
import com.hollingsworth.arsnouveau.api.spell.IPotionEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentRandomize;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectSpark
extends ElementalAbstractEffect
implements IPotionEffect,
IDamageEffect {
    public static EffectSpark INSTANCE = new EffectSpark();

    public EffectSpark() {
        super("spark", "Spark");
    }

    protected int getDefaultManaCost() {
        return 15;
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        LivingEntity target;
        Entity entity = rayTraceResult.m_82443_();
        if (entity instanceof LivingEntity && this.canDamage(shooter, spellStats, spellContext, resolver, (Entity)(target = (LivingEntity)entity))) {
            double damage = (Double)this.DAMAGE.get() + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier() + (double)(target.m_20071_() ? 3 : 0);
            this.attemptDamage(world, shooter, spellStats, spellContext, resolver, (Entity)target, this.buildDamageSource(world, shooter), (float)damage);
            this.applyConfigPotion(target, (MobEffect)ModPotions.SHOCKED_EFFECT.get(), spellStats);
        }
    }

    public DamageSource buildDamageSource(Level world, LivingEntity shooter) {
        shooter = !(shooter instanceof Player) ? ANFakePlayer.getPlayer((ServerLevel)((ServerLevel)world)) : shooter;
        return shooter.m_269291_().m_269548_();
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDamageConfig(builder, 3.0);
        this.addAmpConfig(builder, 2.0);
        this.addPotionConfig(builder, 15);
        this.addExtendTimeConfig(builder, 5);
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE, AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentRandomize.INSTANCE});
    }

    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.ELEMENTAL_AIR});
    }

    public int getBaseDuration() {
        return this.POTION_TIME == null ? 30 : (Integer)this.POTION_TIME.get();
    }

    public int getExtendTimeDuration() {
        return this.EXTEND_TIME == null ? 8 : (Integer)this.EXTEND_TIME.get();
    }

    public SpellTier defaultTier() {
        return SpellTier.ONE;
    }

    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 2);
    }
}

