/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.datagen;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.ArsNouveauRegistry;
import alexthw.ars_elemental.common.entity.familiars.FirenandoHolder;
import alexthw.ars_elemental.common.entity.familiars.MermaidHolder;
import alexthw.ars_elemental.common.items.armor.ArmorSet;
import alexthw.ars_elemental.common.items.armor.ShockPerk;
import alexthw.ars_elemental.common.items.armor.SporePerk;
import alexthw.ars_elemental.common.rituals.AttractionRitual;
import alexthw.ars_elemental.common.rituals.DetectionRitual;
import alexthw.ars_elemental.common.rituals.RepulsionRitual;
import alexthw.ars_elemental.common.rituals.SquirrelRitual;
import alexthw.ars_elemental.common.rituals.TeslaRitual;
import alexthw.ars_elemental.registry.ModItems;
import alexthw.ars_elemental.registry.ModRegistry;
import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.api.familiar.AbstractFamiliarHolder;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.datagen.PatchouliProvider;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.ApparatusPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.CraftingPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.EnchantingPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.EntityPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.GlyphScribePage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.IPatchouliPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.ImbuementPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.PatchouliBuilder;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.SpotlightPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.TextPage;
import com.hollingsworth.arsnouveau.common.items.PerkItem;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class AEPatchouliProvider
extends PatchouliProvider {
    public AEPatchouliProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public void collectJsons(CachedOutput cache) {
        for (AbstractSpellPart spell : ArsNouveauRegistry.registeredSpells) {
            this.addGlyphPage(spell);
        }
        this.addPage(new PatchouliBuilder(GETTING_STARTED, "elemental_tweaks").withIcon((ItemLike)ModItems.DEBUG_ICON.get()).withTextPage("ars_elemental.page.elemental_tweaks").withPage((IPatchouliPage)this.ImbuementPage((ItemLike)ModItems.MARK_OF_MASTERY.get())), this.getPath(GETTING_STARTED, "elemental_tweaks"));
        this.addPage(new PatchouliBuilder(RESOURCES, "flashing_archwood").withIcon((ItemLike)ModItems.FLASHING_ARCHWOOD.get()).withTextPage("ars_elemental.page1.flashing_archwood").withPage((IPatchouliPage)new SpotlightPage((ItemLike)((Block)ModItems.FLASHING_POD.get()).m_5456_()).withText("ars_elemental.page2.flashing_archwood").linkRecipe(true)).withPage((IPatchouliPage)new EntityPage(ArsElemental.prefix("flashing_weald_walker").toString())), this.getPath(RESOURCES, "flashing_archwood"));
        this.addBasicItem((ItemLike)ModItems.WATER_URN.get(), MACHINES, (IPatchouliPage)new ApparatusPage((ItemLike)ModItems.WATER_URN.get()));
        this.addBasicItem((ItemLike)ModItems.WATER_UPSTREAM_BLOCK.get(), MACHINES, (IPatchouliPage)new ApparatusPage((ItemLike)ModItems.WATER_UPSTREAM_BLOCK.get()));
        this.addBasicItem((ItemLike)ModItems.LAVA_UPSTREAM_BLOCK.get(), MACHINES, (IPatchouliPage)new ApparatusPage((ItemLike)ModItems.LAVA_UPSTREAM_BLOCK.get()));
        this.addBasicItem((ItemLike)ModItems.AIR_UPSTREAM_BLOCK.get(), MACHINES, (IPatchouliPage)new ApparatusPage((ItemLike)ModItems.AIR_UPSTREAM_BLOCK.get()));
        this.addBasicItem((ItemLike)ModItems.CURIO_BAG.get(), EQUIPMENT, (IPatchouliPage)new CraftingPage((ItemLike)ModItems.CURIO_BAG.get()));
        this.addBasicItem((ItemLike)ModItems.CASTER_BAG.get(), EQUIPMENT, (IPatchouliPage)new CraftingPage((ItemLike)ModItems.CASTER_BAG.get()));
        this.addBasicItem((ItemLike)ModItems.ENCHANTER_BANGLE.get(), EQUIPMENT, (IPatchouliPage)new ApparatusPage((ItemLike)ModItems.ENCHANTER_BANGLE.get()));
        this.addBasicItem((ItemLike)ModItems.SPELL_MIRROR.get(), AUTOMATION, (IPatchouliPage)new ApparatusPage((ItemLike)ModItems.SPELL_MIRROR.get()));
        this.addPage(new PatchouliBuilder(AUTOMATION, (ItemLike)ModItems.ADVANCED_PRISM.get()).withIcon((ItemLike)ModItems.ADVANCED_PRISM.get()).withTextPage("ars_elemental.page1.advanced_prism").withPage((IPatchouliPage)new CraftingPage((ItemLike)ModItems.ADVANCED_PRISM.get())).withTextPage("ars_elemental.page2.advanced_prism").withPage((IPatchouliPage)this.ImbuementPage((ItemLike)ModItems.ARC_LENS.get())).withPage((IPatchouliPage)this.ImbuementPage((ItemLike)ModItems.HOMING_LENS.get())).withPage((IPatchouliPage)this.ImbuementPage((ItemLike)ModItems.ACC_LENS.get())).withPage((IPatchouliPage)this.ImbuementPage((ItemLike)ModItems.DEC_LENS.get())).withPage((IPatchouliPage)this.ImbuementPage((ItemLike)ModItems.PIERCE_LENS.get())).withPage((IPatchouliPage)this.ImbuementPage((ItemLike)ModItems.RGB_LENS.get())), this.getPath(AUTOMATION, "advanced_prism"));
        this.addPage(new PatchouliBuilder(AUTOMATION, "elemental_turrets").withIcon((ItemLike)ModItems.FIRE_TURRET.get()).withTextPage("ars_elemental.page1.elemental_turrets").withPage((IPatchouliPage)this.ImbuementPage((ItemLike)ModItems.FIRE_TURRET.get())).withPage((IPatchouliPage)this.ImbuementPage((ItemLike)ModItems.WATER_TURRET.get())).withPage((IPatchouliPage)this.ImbuementPage((ItemLike)ModItems.AIR_TURRET.get())).withPage((IPatchouliPage)this.ImbuementPage((ItemLike)ModItems.EARTH_TURRET.get())).withPage((IPatchouliPage)this.ImbuementPage((ItemLike)ModItems.SHAPING_TURRET.get())), this.getPath(AUTOMATION, "elemental_turrets"));
        this.addPage(new PatchouliBuilder(EQUIPMENT, (ItemLike)ModItems.SPELL_HORN.get()).withIcon((ItemLike)ModItems.SPELL_HORN.get()).withTextPage("ars_elemental.page1.spell_horn").withPage((IPatchouliPage)new ApparatusPage((ItemLike)ModItems.SPELL_HORN.get())), this.getPath(EQUIPMENT, "spell_horn"));
        this.addPage(new PatchouliBuilder(EQUIPMENT, (ItemLike)ModItems.NECRO_FOCUS.get()).withIcon((ItemLike)ModItems.NECRO_FOCUS.get()).withTextPage("ars_elemental.page1.necrotic_focus").withPage((IPatchouliPage)this.ImbuementPage((ItemLike)ModItems.ANIMA_ESSENCE.get())).withTextPage("ars_elemental.page2.necrotic_focus").withPage((IPatchouliPage)new ApparatusPage((ItemLike)ModItems.NECRO_FOCUS.get())).withTextPage("ars_elemental.page3.necrotic_focus"), this.getPath(EQUIPMENT, "necrotic_focus"));
        this.addPage(new PatchouliBuilder(EQUIPMENT, (ItemLike)ModItems.FIRE_FOCUS.get()).withIcon((ItemLike)ModItems.FIRE_FOCUS.get()).withTextPage("ars_elemental.page1.fire_focus").withPage((IPatchouliPage)this.ImbuementPage((ItemLike)ModItems.LESSER_FIRE_FOCUS.get())).withPage((IPatchouliPage)new ApparatusPage((ItemLike)ModItems.FIRE_FOCUS.get())).withTextPage("ars_elemental.page2.fire_focus"), this.getPath(EQUIPMENT, "fire_focus"));
        this.addPage(new PatchouliBuilder(EQUIPMENT, (ItemLike)ModItems.FIRE_BANGLE.get()).withIcon((ItemLike)ModItems.FIRE_BANGLE.get()).withTextPage("ars_elemental.page1.fire_bangle").withPage((IPatchouliPage)new ApparatusPage((ItemLike)ModItems.FIRE_BANGLE.get())), this.getPath(EQUIPMENT, "fire_bangle"));
        this.addPage(new PatchouliBuilder(EQUIPMENT, (ItemLike)ModItems.WATER_FOCUS.get()).withIcon((ItemLike)ModItems.WATER_FOCUS.get()).withTextPage("ars_elemental.page1.water_focus").withPage((IPatchouliPage)this.ImbuementPage((ItemLike)ModItems.LESSER_WATER_FOCUS.get())).withPage((IPatchouliPage)new ApparatusPage((ItemLike)ModItems.WATER_FOCUS.get())).withTextPage("ars_elemental.page2.water_focus"), this.getPath(EQUIPMENT, "water_focus"));
        this.addPage(new PatchouliBuilder(EQUIPMENT, (ItemLike)ModItems.WATER_BANGLE.get()).withIcon((ItemLike)ModItems.WATER_BANGLE.get()).withTextPage("ars_elemental.page1.water_bangle").withPage((IPatchouliPage)new ApparatusPage((ItemLike)ModItems.WATER_BANGLE.get())), this.getPath(EQUIPMENT, "water_bangle"));
        this.addPage(new PatchouliBuilder(EQUIPMENT, (ItemLike)ModItems.AIR_FOCUS.get()).withIcon((ItemLike)ModItems.AIR_FOCUS.get()).withTextPage("ars_elemental.page1.air_focus").withPage((IPatchouliPage)this.ImbuementPage((ItemLike)ModItems.LESSER_AIR_FOCUS.get())).withPage((IPatchouliPage)new ApparatusPage((ItemLike)ModItems.AIR_FOCUS.get())).withTextPage("ars_elemental.page2.air_focus"), this.getPath(EQUIPMENT, "air_focus"));
        this.addPage(new PatchouliBuilder(EQUIPMENT, (ItemLike)ModItems.AIR_BANGLE.get()).withIcon((ItemLike)ModItems.AIR_BANGLE.get()).withTextPage("ars_elemental.page1.air_bangle").withPage((IPatchouliPage)new ApparatusPage((ItemLike)ModItems.AIR_BANGLE.get())), this.getPath(EQUIPMENT, "air_bangle"));
        this.addPage(new PatchouliBuilder(EQUIPMENT, (ItemLike)ModItems.EARTH_FOCUS.get()).withIcon((ItemLike)ModItems.EARTH_FOCUS.get()).withTextPage("ars_elemental.page1.earth_focus").withPage((IPatchouliPage)this.ImbuementPage((ItemLike)ModItems.LESSER_EARTH_FOCUS.get())).withPage((IPatchouliPage)new ApparatusPage((ItemLike)ModItems.EARTH_FOCUS.get())).withTextPage("ars_elemental.page2.earth_focus"), this.getPath(EQUIPMENT, "earth_focus"));
        this.addPage(new PatchouliBuilder(EQUIPMENT, (ItemLike)ModItems.EARTH_BANGLE.get()).withIcon((ItemLike)ModItems.EARTH_BANGLE.get()).withTextPage("ars_elemental.page1.earth_bangle").withPage((IPatchouliPage)new ApparatusPage((ItemLike)ModItems.EARTH_BANGLE.get())), this.getPath(EQUIPMENT, "earth_bangle"));
        this.addPage(new PatchouliBuilder(AUTOMATION, (ItemLike)ModItems.SIREN_CHARM.get()).withIcon((ItemLike)ModItems.SIREN_CHARM.get()).withTextPage("ars_elemental.page1.mermaid").withPage((IPatchouliPage)new ApparatusPage((ItemLike)ModItems.SIREN_CHARM.get())).withPage((IPatchouliPage)new EntityPage(ArsElemental.prefix("siren_entity").toString())).withTextPage("ars_elemental.page2.mermaid"), this.getPath(AUTOMATION, "mermaid"));
        this.addPage(new PatchouliBuilder(AUTOMATION, (ItemLike)ModItems.FIRENANDO_CHARM.get()).withIcon((ItemLike)ModItems.FIRENANDO_CHARM.get()).withTextPage("ars_elemental.page1.fire_golem").withPage((IPatchouliPage)new EntityPage(ArsElemental.prefix("firenando_entity").toString())).withPage((IPatchouliPage)new ApparatusPage((ItemLike)ModItems.FIRENANDO_CHARM.get())), this.getPath(AUTOMATION, "fire_golem"));
        this.addPerkPage((IPerk)ShockPerk.INSTANCE);
        this.addPerkPage((IPerk)SporePerk.INSTANCE);
        this.addArmorPage(ModItems.FIRE_ARMOR);
        this.addArmorPage(ModItems.WATER_ARMOR);
        this.addArmorPage(ModItems.AIR_ARMOR);
        this.addArmorPage(ModItems.EARTH_ARMOR);
        this.addFamiliarPage(new MermaidHolder());
        this.addFamiliarPage(new FirenandoHolder());
        this.addRitualPage(new SquirrelRitual());
        this.addRitualPage(new TeslaRitual());
        this.addRitualPage(new AttractionRitual());
        this.addRitualPage(new RepulsionRitual());
        this.addRitualPage(new DetectionRitual());
        this.addEnchantmentPage((Enchantment)ModRegistry.MIRROR.get());
        this.addEnchantmentPage((Enchantment)ModRegistry.SOULBOUND.get());
        this.addPage(new PatchouliBuilder(ENCHANTMENTS, (ItemLike)ItemsRegistry.NOVICE_SPELLBOOK.get()).withTextPage("ars_elemental.page.book_protection").withName("tooltip.ars_nouveau.blessed").withPage((IPatchouliPage)new ApparatusPage(ArsElemental.prefix("invincible_book").toString())), this.getPath(ENCHANTMENTS, "invincible_book"));
        for (PatchouliProvider.PatchouliPage patchouliPage : this.pages) {
            this.saveStable(cache, (JsonElement)patchouliPage.build(), patchouliPage.path());
        }
    }

    private void addArmorPage(ArmorSet armorSet) {
        PatchouliBuilder builder = new PatchouliBuilder(ARMOR, armorSet.getTranslationKey()).withIcon((ItemLike)armorSet.getHat()).withPage((IPatchouliPage)new TextPage("ars_elemental.page.armor_set.wip")).withPage((IPatchouliPage)new TextPage("ars_elemental.page.armor_set." + armorSet.getName())).withPage((IPatchouliPage)new AEPage(armorSet.getHat())).withPage((IPatchouliPage)new AEPage(armorSet.getChest())).withPage((IPatchouliPage)new AEPage(armorSet.getLegs())).withPage((IPatchouliPage)new AEPage(armorSet.getBoots()));
        this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(ARMOR, "armor_" + armorSet.getName())));
    }

    public void addPerkPage(IPerk perk) {
        PerkItem perkItem = (PerkItem)PerkRegistry.getPerkItemMap().get(perk.getRegistryName());
        PatchouliBuilder builder = new PatchouliBuilder(ARMOR, (ItemLike)perkItem).withIcon((ItemLike)perkItem).withTextPage(perk.getDescriptionKey()).withPage((IPatchouliPage)new ApparatusPage((ItemLike)perkItem)).withSortNum(99);
        this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(ARMOR, perk.getRegistryName().m_135815_() + ".json")));
    }

    public PatchouliProvider.PatchouliPage addBasicItem(ItemLike item, ResourceLocation category, IPatchouliPage recipePage) {
        PatchouliBuilder builder = new PatchouliBuilder(category, item.m_5456_().m_5524_()).withIcon((ItemLike)item.m_5456_()).withPage((IPatchouliPage)new TextPage("ars_elemental.page." + this.getRegistryName(item.m_5456_()).m_135815_())).withPage(recipePage);
        PatchouliProvider.PatchouliPage page = new PatchouliProvider.PatchouliPage(builder, this.getPath(category, this.getRegistryName(item.m_5456_()).m_135815_()));
        this.pages.add(page);
        return page;
    }

    public void addFamiliarPage(AbstractFamiliarHolder familiarHolder) {
        PatchouliBuilder builder = new PatchouliBuilder(FAMILIARS, "entity.ars_elemental." + familiarHolder.getRegistryName().m_135815_()).withIcon("ars_elemental:" + familiarHolder.getRegistryName().m_135815_()).withTextPage("ars_elemental.familiar_desc." + familiarHolder.getRegistryName().m_135815_()).withPage((IPatchouliPage)new EntityPage(familiarHolder.getRegistryName().toString()));
        this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(FAMILIARS, familiarHolder.getRegistryName().m_135815_())));
    }

    public void addRitualPage(AbstractRitual ritual) {
        PatchouliBuilder builder = new PatchouliBuilder(RITUALS, "item.ars_elemental." + ritual.getRegistryName().m_135815_()).withIcon(ritual.getRegistryName().toString()).withTextPage(ritual.getDescriptionKey()).withPage((IPatchouliPage)new CraftingPage("ars_elemental:tablet_" + ritual.getRegistryName().m_135815_()));
        this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(RITUALS, ritual.getRegistryName().m_135815_())));
    }

    public void addEnchantmentPage(Enchantment enchantment) {
        PatchouliBuilder builder = new PatchouliBuilder(ENCHANTMENTS, enchantment.m_44704_()).withIcon(this.getRegistryName(Items.f_42690_).toString()).withTextPage("ars_elemental.enchantment_desc." + this.getRegistryName(enchantment).m_135815_());
        for (int i = enchantment.m_44702_(); i <= enchantment.m_6586_(); ++i) {
            builder.withPage((IPatchouliPage)new EnchantingPage("ars_nouveau:" + this.getRegistryName(enchantment).m_135815_() + "_" + i));
        }
        this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(ENCHANTMENTS, this.getRegistryName(enchantment).m_135815_())));
    }

    public void addGlyphPage(AbstractSpellPart spellPart) {
        ResourceLocation category = switch (spellPart.defaultTier().value) {
            case 1 -> GLYPHS_1;
            case 2 -> GLYPHS_2;
            default -> GLYPHS_3;
        };
        PatchouliBuilder builder = new PatchouliBuilder(category, spellPart.getName()).withName("ars_elemental.glyph_name." + spellPart.getRegistryName().m_135815_()).withIcon(spellPart.getRegistryName().toString()).withSortNum(spellPart instanceof AbstractCastMethod ? 1 : (spellPart instanceof AbstractEffect ? 2 : 3)).withPage((IPatchouliPage)new TextPage("ars_elemental.glyph_desc." + spellPart.getRegistryName().m_135815_())).withPage((IPatchouliPage)new GlyphScribePage(spellPart));
        this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(category, spellPart.getRegistryName().m_135815_())));
    }

    public String m_6055_() {
        return "Ars Elemental Patchouli Datagen";
    }

    ImbuementPage ImbuementPage(ItemLike item) {
        return new ImbuementPage("ars_elemental:imbuement_" + this.getRegistryName(item.m_5456_()).m_135815_());
    }

    private ResourceLocation getRegistryName(Item asItem) {
        return ForgeRegistries.ITEMS.getKey((Object)asItem);
    }

    private ResourceLocation getRegistryName(Enchantment enchantment) {
        return ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment);
    }

    static class AEPage
    extends ApparatusPage {
        public AEPage(Item itemLike) {
            super((ItemLike)itemLike);
        }

        public ResourceLocation getType() {
            return new ResourceLocation("ars_nouveau", "elemental_armor_recipe");
        }
    }
}

