/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.camera;

import com.hollingsworth.arsnouveau.api.camera.ICameraMountable;
import com.hollingsworth.arsnouveau.common.entity.ScryerCamera;
import com.hollingsworth.arsnouveau.common.util.CameraUtil;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ars_nouveau")
public class CameraEvents {
    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        Entity entity = player.m_8954_();
        if (entity instanceof ScryerCamera) {
            ScryerCamera cam = (ScryerCamera)entity;
            BlockEntity blockEntity = player.f_19853_.m_7702_(cam.m_20183_());
            if (blockEntity instanceof ICameraMountable) {
                ICameraMountable camBe = (ICameraMountable)blockEntity;
                camBe.stopViewing();
            }
            cam.m_146870_();
        }
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.f_19853_;
        if (!level.f_46443_ && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (CameraUtil.isPlayerMountedOnCamera(entity)) {
                ((ScryerCamera)player.m_8954_()).stopViewing(player);
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (CameraUtil.isPlayerMountedOnCamera((LivingEntity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (CameraUtil.isPlayerMountedOnCamera((LivingEntity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (CameraUtil.isPlayerMountedOnCamera((LivingEntity)event.getEntity())) {
            event.setCanceled(true);
        }
    }
}

