/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;

public class EntityOrbitProjectile
extends EntityProjectileSpell {
    public Entity wardedEntity;
    public int ticksLeft;
    public static final EntityDataAccessor<Integer> OWNER_UUID = SynchedEntityData.m_135353_(EntityOrbitProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> OFFSET = SynchedEntityData.m_135353_(EntityOrbitProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> ACCELERATES = SynchedEntityData.m_135353_(EntityOrbitProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> AOE = SynchedEntityData.m_135353_(EntityOrbitProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> TOTAL = SynchedEntityData.m_135353_(EntityOrbitProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int extendTimes;

    public EntityOrbitProjectile(Level worldIn, double x, double y, double z) {
        super((EntityType<? extends EntityProjectileSpell>)((EntityType)ModEntities.ORBIT_SPELL.get()), worldIn, x, y, z);
    }

    public EntityOrbitProjectile(Level worldIn, LivingEntity shooter) {
        super((EntityType<? extends EntityProjectileSpell>)((EntityType)ModEntities.ORBIT_SPELL.get()), worldIn, shooter);
    }

    public EntityOrbitProjectile(Level world, SpellResolver resolver) {
        super((EntityType<? extends EntityProjectileSpell>)((EntityType)ModEntities.ORBIT_SPELL.get()), world, resolver);
    }

    public EntityOrbitProjectile(EntityType<EntityOrbitProjectile> entityWardProjectileEntityType, Level world) {
        super((EntityType<? extends EntityProjectileSpell>)entityWardProjectileEntityType, world);
    }

    public void setOffset(int offset) {
        this.f_19804_.m_135381_(OFFSET, (Object)offset);
    }

    public int getOffset() {
        int val = 15;
        return (Integer)this.f_19804_.m_135370_(OFFSET) * val;
    }

    public void setTotal(int total) {
        this.f_19804_.m_135381_(TOTAL, (Object)total);
    }

    public int getTotal() {
        return (Integer)this.f_19804_.m_135370_(TOTAL) > 0 ? (Integer)this.f_19804_.m_135370_(TOTAL) : 1;
    }

    public void setAccelerates(int accelerates) {
        this.f_19804_.m_135381_(ACCELERATES, (Object)accelerates);
    }

    public int getAccelerates() {
        return (Integer)this.f_19804_.m_135370_(ACCELERATES);
    }

    public void setAoe(float aoe) {
        this.f_19804_.m_135381_(AOE, (Object)Float.valueOf(aoe));
    }

    public float getAoe() {
        return ((Float)this.f_19804_.m_135370_(AOE)).floatValue();
    }

    public double getRotateSpeed() {
        return 10.0 - (double)this.getAccelerates();
    }

    public double getRadiusMultiplier() {
        return 1.5 + 0.5 * (double)this.getAoe();
    }

    @Override
    public void m_8119_() {
        Entity owner = this.f_19853_.m_6815_(this.getOwnerID());
        if (!this.f_19853_.f_46443_ && owner == null) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (owner == null) {
            return;
        }
        super.m_8119_();
    }

    @Override
    public Vec3 getNextHitPosition() {
        return this.getAngledPosition(this.f_19797_ + 3);
    }

    @Override
    public void tickNextPosition() {
        this.m_146884_(this.getAngledPosition(this.f_19797_));
    }

    public Vec3 getAngledPosition(int nextTick) {
        double rotateSpeed = this.getRotateSpeed();
        double radiusMultiplier = this.getRadiusMultiplier();
        Entity owner = this.f_19853_.m_6815_(this.getOwnerID());
        return new Vec3(owner.m_20185_() - radiusMultiplier * Math.sin((double)nextTick / rotateSpeed + (double)this.getOffset()), owner.m_20186_() + 1.0 - (owner.m_6144_() ? 0.25 : 0.0), owner.m_20189_() - radiusMultiplier * Math.cos((double)nextTick / rotateSpeed + (double)this.getOffset()));
    }

    @Override
    public boolean canTraversePortals() {
        return false;
    }

    @Override
    public int getExpirationTime() {
        return 1200 + 600 * this.extendTimes;
    }

    @Override
    protected void m_6532_(@NotNull HitResult result) {
        if (this.f_19853_.f_46443_ || result.m_6662_() == HitResult.Type.MISS) {
            return;
        }
        if (result.m_6662_() == HitResult.Type.ENTITY) {
            if (((EntityHitResult)result).m_82443_().equals((Object)this.m_19749_())) {
                return;
            }
            if (this.spellResolver != null) {
                this.spellResolver.onResolveEffect(this.f_19853_, result);
                Networking.sendToNearby(this.f_19853_, BlockPos.m_274446_((Position)result.m_82450_()), (Object)new PacketANEffect(PacketANEffect.EffectType.BURST, BlockPos.m_274446_((Position)result.m_82450_()), this.getParticleColor(), new int[0]));
                this.attemptRemoval();
            }
        } else if (this.numSensitive > 0 && result instanceof BlockHitResult) {
            BlockHitResult blockraytraceresult = (BlockHitResult)result;
            if (!this.m_213877_()) {
                if (this.spellResolver != null) {
                    this.spellResolver.onResolveEffect(this.f_19853_, (HitResult)blockraytraceresult);
                }
                Networking.sendToNearby(this.f_19853_, ((BlockHitResult)result).m_82425_(), (Object)new PacketANEffect(PacketANEffect.EffectType.BURST, BlockPos.m_274446_((Position)result.m_82450_()).m_7495_(), this.getParticleColor(), new int[0]));
                this.attemptRemoval();
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_UUID, (Object)0);
        this.f_19804_.m_135372_(OFFSET, (Object)0);
        this.f_19804_.m_135372_(ACCELERATES, (Object)0);
        this.f_19804_.m_135372_(AOE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TOTAL, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("left", this.ticksLeft);
        tag.m_128405_("offset", this.getOffset());
        tag.m_128350_("aoe", this.getAoe());
        tag.m_128405_("accelerate", this.getAccelerates());
        tag.m_128405_("total", this.getTotal());
        tag.m_128405_("ownerID", this.getOwnerID());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.ticksLeft = tag.m_128451_("left");
        this.setOffset(tag.m_128451_("offset"));
        this.setAoe(tag.m_128457_("aoe"));
        this.setAccelerates(tag.m_128451_("accelerate"));
        this.setOwnerID(tag.m_128451_("ownerID"));
        this.setTotal(tag.m_128451_("total"));
    }

    @Override
    public EntityType<?> m_6095_() {
        return (EntityType)ModEntities.ORBIT_SPELL.get();
    }

    @Override
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public EntityOrbitProjectile(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType<? extends EntityProjectileSpell>)((EntityType)ModEntities.ORBIT_SPELL.get()), world);
    }

    public int getOwnerID() {
        return (Integer)this.m_20088_().m_135370_(OWNER_UUID);
    }

    public void setOwnerID(int uuid) {
        this.m_20088_().m_135381_(OWNER_UUID, (Object)uuid);
    }
}

