/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.events;

import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.gui.PatchouliTooltipEvent;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.GuiRadialMenu;
import com.hollingsworth.arsnouveau.common.block.tile.GhostWeaveTile;
import com.hollingsworth.arsnouveau.common.block.tile.SkyBlockTile;
import com.hollingsworth.arsnouveau.common.spell.casters.ReactiveCaster;
import com.hollingsworth.arsnouveau.setup.registry.EnchantmentRegistry;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="ars_nouveau")
public class ClientEvents {
    @SubscribeEvent
    public static void TooltipEvent(RenderTooltipEvent.Pre e) {
        try {
            PatchouliTooltipEvent.onTooltip(e.getGraphics().m_280168_(), e.getItemStack(), e.getX(), e.getY());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void highlightBlockEvent(RenderHighlightEvent.Block e) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            GhostWeaveTile ghostTile;
            SkyBlockTile skyTile;
            BlockEntity be = level.m_7702_(e.getTarget().m_82425_());
            if (be instanceof SkyBlockTile && !(skyTile = (SkyBlockTile)be).showFacade()) {
                e.setCanceled(true);
            }
            if (be instanceof GhostWeaveTile && (ghostTile = (GhostWeaveTile)be).isInvisible()) {
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void overlayEvent(RenderGuiOverlayEvent.Pre event) {
        if (Minecraft.m_91087_().f_91080_ instanceof GuiRadialMenu && event.getOverlay() == VanillaGuiOverlay.CROSSHAIR.type()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)EnchantmentRegistry.REACTIVE_ENCHANTMENT.get()), (ItemStack)stack);
        if (level > 0 && new ReactiveCaster(stack).getSpell().isValid()) {
            Spell spell = new ReactiveCaster(stack).getSpell();
            event.getToolTip().add(Component.m_237113_((String)spell.getDisplayString()));
        }
        Collections.addAll(event.getToolTip(), ClientInfo.storageTooltip);
    }

    public static Component localize(String key, Object ... params) {
        for (int i = 0; i < params.length; ++i) {
            Component component;
            ComponentContents componentContents;
            Object parameter = params[i];
            if (!(parameter instanceof Component) || !((componentContents = (component = (Component)parameter).m_214077_()) instanceof TranslatableContents)) continue;
            TranslatableContents translatableContents = (TranslatableContents)componentContents;
            params[i] = ClientEvents.localize(translatableContents.m_237508_(), translatableContents.m_237523_());
        }
        return Component.m_237110_((String)key, (Object[])params);
    }
}

