/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.mimic;

import artifacts.Artifacts;
import artifacts.client.mimic.model.MimicChestLayerModel;
import artifacts.client.mimic.model.MimicModel;
import artifacts.entity.MimicEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class MimicChestLayer
extends RenderLayer<MimicEntity, MimicModel> {
    public static final ResourceLocation CHEST_ATLAS = new ResourceLocation("textures/atlas/chest.png");
    public static final List<String> QUARK_CHEST_MATERIALS = Arrays.asList("oak", "spruce", "birch", "cherry", "jungle", "acacia", "dark_oak", "warped", "crimson", "azalea", "blossom", "mangrove", "bamboo");
    private final MimicChestLayerModel chestModel;
    public final Material vanillaChestMaterial;
    public final List<Material> chestMaterials;

    public MimicChestLayer(RenderLayerParent<MimicEntity, MimicModel> entityRenderer, EntityModelSet modelSet) {
        super(entityRenderer);
        this.chestModel = new MimicChestLayerModel(modelSet.m_171103_(MimicChestLayerModel.LAYER_LOCATION));
        this.chestMaterials = new ArrayList<Material>();
        boolean isChristmas = MimicChestLayer.isChristmas();
        Material material = this.vanillaChestMaterial = isChristmas ? Sheets.f_110748_ : Sheets.f_110751_;
        if (isChristmas) {
            this.chestMaterials.add(this.vanillaChestMaterial);
            return;
        }
        Material defaultMaterial = this.vanillaChestMaterial;
        if (Platform.isModLoaded((String)"lootr")) {
            ResourceLocation chestLocation = new ResourceLocation("lootr", "chest");
            defaultMaterial = new Material(TextureAtlas.f_118259_, chestLocation);
        } else if (Platform.isModLoaded((String)"myloot")) {
            ResourceLocation chestLocation = new ResourceLocation("myloot", "entity/chest/loot");
            defaultMaterial = new Material(CHEST_ATLAS, chestLocation);
        }
        this.chestMaterials.add(defaultMaterial);
        MimicChestLayer.addQuarkMaterials(this.chestMaterials);
    }

    private static boolean isChristmas() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 11 && calendar.get(5) >= 24 && calendar.get(5) <= 26 || calendar.get(2) == 3 && calendar.get(5) == 1;
    }

    private static void addQuarkMaterials(List<Material> chestMaterials) {
        if (Platform.isModLoaded((String)"quark")) {
            String chestVariant = Platform.isModLoaded((String)"lootr") ? "lootr_normal" : "normal";
            for (String chestMaterial : QUARK_CHEST_MATERIALS) {
                ResourceLocation chestLocation = new ResourceLocation("quark", String.format("quark_variant_chests/%s/%s", chestMaterial, chestVariant));
                chestMaterials.add(new Material(CHEST_ATLAS, chestLocation));
            }
        }
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, MimicEntity mimic, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!mimic.m_20145_()) {
            matrixStack.m_85836_();
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            matrixStack.m_85837_(-0.5, -1.5, -0.5);
            ((MimicModel)this.m_117386_()).m_102624_(this.chestModel);
            this.chestModel.prepareMobModel(mimic, limbSwing, limbSwingAmount, partialTicks);
            this.chestModel.setupAnim(mimic, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            VertexConsumer builder = this.getChestMaterial(mimic).m_119194_(buffer, RenderType::m_110452_);
            this.chestModel.m_7695_(matrixStack, builder, packedLight, LivingEntityRenderer.m_115338_((LivingEntity)mimic, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
        }
    }

    private Material getChestMaterial(MimicEntity mimic) {
        if (!Artifacts.CONFIG.client.useModdedMimicTextures) {
            return this.vanillaChestMaterial;
        }
        if (this.chestMaterials.size() == 1) {
            return this.chestMaterials.get(0);
        }
        return this.chestMaterials.get((int)(Math.abs(mimic.m_20148_().getMostSignificantBits()) % (long)this.chestMaterials.size()));
    }
}

