/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable;

import artifacts.client.ToggleKeyHandler;
import artifacts.item.ArtifactItem;
import artifacts.platform.PlatformServices;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import org.jetbrains.annotations.Nullable;

public abstract class WearableArtifactItem
extends ArtifactItem {
    public boolean isEquippedBy(@Nullable LivingEntity entity) {
        return PlatformServices.platformHelper.isEquippedBy(entity, this);
    }

    public Stream<ItemStack> findAllEquippedBy(LivingEntity entity) {
        return PlatformServices.platformHelper.findAllEquippedBy(entity, this);
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.RARE;
    }

    public void onEquip(LivingEntity entity, ItemStack stack) {
    }

    public void onUnequip(LivingEntity entity, ItemStack stack) {
    }

    public void wornTick(LivingEntity entity, ItemStack stack) {
    }

    public SoundEvent getEquipSound() {
        return SoundEvents.f_11675_;
    }

    public int getFortuneLevel() {
        return 0;
    }

    public int getLootingLevel() {
        return 0;
    }

    public void toggleItem(ServerPlayer player) {
        this.findAllEquippedBy((LivingEntity)player).forEach(stack -> WearableArtifactItem.setActivated(stack, !WearableArtifactItem.isActivated(stack)));
    }

    public static boolean isActivated(ItemStack stack) {
        return !stack.m_41782_() || !stack.m_41784_().m_128441_("isActivated") || stack.m_41784_().m_128471_("isActivated");
    }

    public static void setActivated(ItemStack stack, boolean active) {
        stack.m_41784_().m_128379_("isActivated", active);
    }

    @Override
    protected void addEffectsTooltip(ItemStack stack, List<MutableComponent> tooltip) {
        super.addEffectsTooltip(stack, tooltip);
        KeyMapping key = ToggleKeyHandler.getToggleKey(this);
        if (!(key == null || key.m_90862_() && WearableArtifactItem.isActivated(stack))) {
            tooltip.add(Component.m_237110_((String)"%s.tooltip.toggle_keymapping".formatted("artifacts"), (Object[])new Object[]{key.m_90863_()}));
        }
    }
}

