/*
 * Decompiled with CFR 0.152.
 */
package artifacts.loot;

import artifacts.Artifacts;
import artifacts.registry.ModLootConditions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public record ConfigurableRandomChance(float defaultProbability) implements LootItemCondition
{
    public LootItemConditionType m_7940_() {
        return ModLootConditions.CONFIGURABLE_ARTIFACT_CHANCE.get();
    }

    public boolean test(LootContext context) {
        if (Artifacts.CONFIG.common.getArtifactRarity() > 9999.0) {
            return false;
        }
        float r = (float)Artifacts.CONFIG.common.getArtifactRarity();
        float p = this.defaultProbability;
        float adjustedProbability = p / (p + r - r * p);
        return context.m_230907_().m_188501_() < adjustedProbability;
    }

    public static LootItemCondition.Builder configurableRandomChance(float probability) {
        return () -> new ConfigurableRandomChance(probability);
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<ConfigurableRandomChance> {
        public void serialize(JsonObject object, ConfigurableRandomChance condition, JsonSerializationContext context) {
            object.addProperty("default_probability", (Number)Float.valueOf(condition.defaultProbability));
        }

        public ConfigurableRandomChance deserialize(JsonObject object, JsonDeserializationContext context) {
            return new ConfigurableRandomChance(GsonHelper.m_13915_((JsonObject)object, (String)"default_probability"));
        }
    }
}

