/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.impl.client.models;

import com.google.gson.JsonObject;
import earth.terrarium.athena.api.client.models.AthenaBlockModel;
import earth.terrarium.athena.api.client.models.AthenaModelFactory;
import earth.terrarium.athena.api.client.models.AthenaQuad;
import earth.terrarium.athena.api.client.utils.AppearanceAndTintGetter;
import earth.terrarium.athena.api.client.utils.CtmState;
import earth.terrarium.athena.api.client.utils.CtmUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;

public class ConnectedCarpetBlockModel
implements AthenaBlockModel {
    public static final AthenaModelFactory FACTORY = new Factory();
    private static final List<AthenaQuad> SIDE = List.of(new AthenaQuad(0, 0.0f, 1.0f, 0.0625f, 0.0f, Rotation.NONE, 0.0f));
    private static final List<AthenaQuad> CENTER_TOP = List.of(new AthenaQuad(1, 0.0f, 1.0f, 1.0f, 0.0f, Rotation.NONE, 0.9375f));
    private static final List<AthenaQuad> CENTER_BOTTOM = List.of(new AthenaQuad(1, 0.0f, 1.0f, 1.0f, 0.0f, Rotation.NONE, 0.0625f));
    private final Int2ObjectMap<Material> materials;
    private final BiPredicate<BlockState, BlockState> connectTo;

    public ConnectedCarpetBlockModel(Int2ObjectMap<Material> materials, BiPredicate<BlockState, BlockState> connectTo) {
        this.materials = materials;
        this.connectTo = connectTo;
    }

    @Override
    public List<AthenaQuad> getQuads(AppearanceAndTintGetter level, BlockState blockState, BlockPos pos, Direction direction) {
        if (direction.m_122434_().m_122479_()) {
            return SIDE;
        }
        CtmState state = CtmState.from(level, blockState, pos, direction, CtmUtils.check(level, blockState, pos, direction, this.connectTo));
        if (state.allTrue()) {
            return direction == Direction.UP ? CENTER_TOP : CENTER_BOTTOM;
        }
        float depth = direction == Direction.UP ? 0.9375f : 0.0625f;
        return List.of(AthenaQuad.withState(state.up(), state.left(), state.upLeft(), 0.0f, 0.5f, 1.0f, 0.5f, depth), AthenaQuad.withState(state.up(), state.right(), state.upRight(), 0.5f, 1.0f, 1.0f, 0.5f, depth), AthenaQuad.withState(state.down(), state.left(), state.downLeft(), 0.0f, 0.5f, 0.5f, 0.0f, depth), AthenaQuad.withState(state.down(), state.right(), state.downRight(), 0.5f, 1.0f, 0.5f, 0.0f, depth));
    }

    @Override
    public Map<Direction, List<AthenaQuad>> getDefaultQuads(Direction direction) {
        if (direction == null) {
            return Map.of();
        }
        float depth = direction == Direction.UP ? 0.9375f : 0.0625f;
        return Map.of(direction, List.of(AthenaQuad.withState(false, false, false, 0.0f, 0.5f, 1.0f, 0.5f, depth), AthenaQuad.withState(false, false, false, 0.5f, 1.0f, 1.0f, 0.5f, depth), AthenaQuad.withState(false, false, false, 0.0f, 0.5f, 0.5f, 0.0f, depth), AthenaQuad.withState(false, false, false, 0.5f, 1.0f, 0.5f, 0.0f, depth)));
    }

    @Override
    public Int2ObjectMap<TextureAtlasSprite> getTextures(Function<Material, TextureAtlasSprite> getter) {
        Int2ObjectArrayMap textures = new Int2ObjectArrayMap();
        for (Int2ObjectMap.Entry entry : this.materials.int2ObjectEntrySet()) {
            textures.put(entry.getIntKey(), (Object)getter.apply((Material)entry.getValue()));
        }
        return textures;
    }

    private static class Factory
    implements AthenaModelFactory {
        private Factory() {
        }

        @Override
        public Supplier<AthenaBlockModel> create(JsonObject json) {
            Int2ObjectMap<Material> materials = CtmUtils.parseCtmMaterials(GsonHelper.m_13930_((JsonObject)json, (String)"ctm_textures"));
            BiPredicate<BlockState, BlockState> conditions = CtmUtils.parseCondition(json);
            return () -> new ConnectedCarpetBlockModel(materials, conditions);
        }
    }
}

