/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.util.cursor;

import com.ldtteam.blockui.util.cursor.CursorUtils;
import net.minecraft.resources.ResourceLocation;

@FunctionalInterface
public interface Cursor {
    public static final Cursor DEFAULT = Cursor.named(() -> CursorUtils.setStandardCursor(CursorUtils.StandardCursor.DEFAULT), (Object)CursorUtils.StandardCursor.DEFAULT);
    public static final Cursor ARROW = Cursor.named(() -> CursorUtils.setStandardCursor(CursorUtils.StandardCursor.ARROW), (Object)CursorUtils.StandardCursor.ARROW);
    public static final Cursor TEXT_CURSOR = Cursor.named(() -> CursorUtils.setStandardCursor(CursorUtils.StandardCursor.TEXT_CURSOR), (Object)CursorUtils.StandardCursor.TEXT_CURSOR);
    public static final Cursor CROSSHAIR = Cursor.named(() -> CursorUtils.setStandardCursor(CursorUtils.StandardCursor.CROSSHAIR), (Object)CursorUtils.StandardCursor.CROSSHAIR);
    public static final Cursor HAND = Cursor.named(() -> CursorUtils.setStandardCursor(CursorUtils.StandardCursor.HAND), (Object)CursorUtils.StandardCursor.HAND);
    public static final Cursor HORIZONTAL_RESIZE = Cursor.named(() -> CursorUtils.setStandardCursor(CursorUtils.StandardCursor.HORIZONTAL_RESIZE), (Object)CursorUtils.StandardCursor.HORIZONTAL_RESIZE);
    public static final Cursor VERTICAL_RESIZE = Cursor.named(() -> CursorUtils.setStandardCursor(CursorUtils.StandardCursor.VERTICAL_RESIZE), (Object)CursorUtils.StandardCursor.VERTICAL_RESIZE);
    public static final Cursor RESIZE = Cursor.named(() -> CursorUtils.setStandardCursor(CursorUtils.StandardCursor.RESIZE), (Object)CursorUtils.StandardCursor.RESIZE);

    public static Cursor of(ResourceLocation resLoc) {
        CursorUtils.loadCursorTexture(resLoc);
        return Cursor.named(() -> CursorUtils.setCursorImage(resLoc), resLoc);
    }

    public void apply();

    public static Cursor named(final Runnable applier, final Object name) {
        return new Cursor(){

            @Override
            public void apply() {
                applier.run();
            }

            public String toString() {
                return "Cursor: " + name;
            }
        };
    }
}

