/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.views;

import com.ldtteam.blockui.Alignment;
import com.ldtteam.blockui.BOGuiGraphics;
import com.ldtteam.blockui.Loader;
import com.ldtteam.blockui.MouseEventCallback;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.controls.Tooltip;
import com.ldtteam.blockui.util.records.Pos2i;
import com.ldtteam.blockui.views.BOWindow;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nullable;

public class View
extends Pane {
    protected List<Pane> children = new ArrayList<Pane>();
    protected int padding = 0;

    public View() {
    }

    public View(PaneParams params) {
        super(params);
        if (params.getParentView() != null) {
            if (this.width == 0) {
                this.width = params.getParentView().width - this.x;
            }
            if (this.height == 0) {
                this.height = params.getParentView().height - this.y;
            }
        }
        this.padding = params.getInteger("padding", this.padding);
    }

    public List<Pane> getChildren() {
        return this.children;
    }

    @Override
    public void parseChildren(PaneParams params) {
        List<PaneParams> childNodes = params.getChildren();
        if (childNodes.isEmpty()) {
            return;
        }
        for (PaneParams node : childNodes) {
            Loader.createFromPaneParams(node, this);
        }
    }

    @Override
    public void drawSelf(BOGuiGraphics target, double mx, double my) {
        PoseStack ms = target.m_280168_();
        ms.m_85836_();
        int paddedX = this.x + this.padding;
        int paddedY = this.y + this.padding;
        ms.m_85837_((double)paddedX, (double)paddedY, 0.0);
        double drawX = mx - (double)paddedX;
        double drawY = my - (double)paddedY;
        for (Pane child : this.children) {
            if (this.childIsVisible(child)) {
                child.draw(target, drawX, drawY);
                continue;
            }
            child.drawHidden();
        }
        ms.m_85849_();
    }

    @Override
    public void drawHidden() {
        for (Pane child : this.children) {
            child.drawHidden();
        }
    }

    @Override
    public void drawSelfLast(BOGuiGraphics target, double mx, double my) {
        PoseStack ms = target.m_280168_();
        ms.m_85836_();
        int paddedX = this.x + this.padding;
        int paddedY = this.y + this.padding;
        ms.m_85837_((double)paddedX, (double)paddedY, 0.0);
        double drawX = mx - (double)paddedX;
        double drawY = my - (double)paddedY;
        for (Pane child : this.children) {
            if (!this.childIsVisible(child)) continue;
            child.drawLast(target, drawX, drawY);
        }
        ms.m_85849_();
    }

    @Override
    public boolean scrollInput(double wheel, double mx, double my) {
        return this.mousePointableEventHandler(mx, my, (child, mxChild, myChild) -> child.scrollInput(wheel, mxChild, myChild), null);
    }

    @Override
    @Nullable
    public Pane findPaneByID(String id) {
        if (this.id.equals(id)) {
            return this;
        }
        for (Pane child : this.children) {
            Pane found = child.findPaneByID(id);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Override
    @Nullable
    public <T extends Pane> T findPaneByType(Class<T> type) {
        if (super.findPaneByType(type) != null) {
            return (T)((Pane)type.cast(this));
        }
        for (Pane child : this.children) {
            T found = child.findPaneByType(type);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public void setWindow(BOWindow w) {
        super.setWindow(w);
        for (Pane child : this.children) {
            child.setWindow(w);
        }
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        View p = this.parent;
        if (p == null) {
            return;
        }
        if (this.width == 0) {
            while (p.width == 0 && p.parent != null) {
                p = p.parent;
            }
            this.width = Math.max(0, p.width - this.x);
        }
        if (this.height == 0) {
            while (p.height == 0 && p.parent != null) {
                p = p.parent;
            }
            this.height = Math.max(0, p.height - this.y);
        }
    }

    @Override
    public boolean rightClick(double mx, double my) {
        return this.mouseClickableEventHandler(mx, my, Pane::rightClick);
    }

    @Override
    public boolean click(double mx, double my) {
        return this.mouseClickableEventHandler(mx, my, Pane::click);
    }

    @Nullable
    public Pane findPaneForClick(double mx, double my) {
        AtomicReference result = new AtomicReference();
        this.mouseClickableEventHandler(mx, my, (child, mxChild, myChild) -> {
            result.set(child);
            return true;
        });
        return (Pane)result.get();
    }

    @Override
    public void onUpdate() {
        for (Pane child : new ArrayList<Pane>(this.children)) {
            if (!child.shouldDraw()) continue;
            child.onUpdate();
        }
    }

    protected boolean childIsVisible(Pane child) {
        if (child instanceof Tooltip) {
            return true;
        }
        return child.getX() < this.getInteriorWidth() && child.getY() < this.getInteriorHeight() && child.getX() + child.getWidth() >= 0 && child.getY() + child.getHeight() >= 0;
    }

    public int getInteriorWidth() {
        return this.width - this.padding * 2;
    }

    public int getInteriorHeight() {
        return this.height - this.padding * 2;
    }

    public void addChild(Pane child) {
        this.children.add(child);
        this.postAddChild(child);
    }

    public void addChild(Pane child, int index) {
        this.children.add(index, child);
        this.postAddChild(child);
    }

    protected void postAddChild(Pane child) {
        child.setWindow(this.getWindow());
        this.adjustChild(child);
        child.setParentView(this);
    }

    protected void adjustChild(Pane child) {
        Alignment alignment;
        int childX = child.getX();
        int childY = child.getY();
        int childWidth = child.getWidth();
        int childHeight = child.getHeight();
        if (childWidth < 0) {
            childWidth = Math.max(0, this.getInteriorWidth() + childWidth);
        }
        if ((alignment = child.getAlignment()).isRightAligned()) {
            childX = this.getInteriorWidth() - childWidth - childX;
        } else if (alignment.isHorizontalCentered()) {
            childX = (this.getInteriorWidth() - childWidth) / 2 + childX;
        }
        if (childHeight < 0) {
            childHeight = Math.max(0, this.getInteriorHeight() + childHeight);
        }
        if (alignment.isBottomAligned()) {
            childY = this.getInteriorHeight() - childHeight - childY;
        } else if (alignment.isVerticalCentered()) {
            childY = (this.getInteriorHeight() - childHeight) / 2 + childY;
        }
        child.setSize(childWidth, childHeight);
        child.setPosition(childX, childY);
    }

    public void removeChild(Pane child) {
        this.children.remove(child);
    }

    @Override
    public boolean onMouseDrag(double x, double y, int speed, double deltaX, double deltaY) {
        return this.mousePointableEventHandler(x, y, (child, mxChild, myChild) -> child.onMouseDrag(mxChild, myChild, speed, deltaX, deltaY), null);
    }

    public boolean mouseClickableEventHandler(double mx, double my, MouseEventCallback eventCallback) {
        return this.mouseEventProcessor(mx, my, Pane::canHandleClick, eventCallback, null);
    }

    public boolean mousePointableEventHandler(double mx, double my, MouseEventCallback eventCallbackPositive, @Nullable MouseEventCallback eventCallbackNegative) {
        return this.mouseEventProcessor(mx, my, Pane::isPointInPane, eventCallbackPositive, eventCallbackNegative);
    }

    public boolean mouseEventProcessor(double mx, double my, MouseEventCallback panePredicate, MouseEventCallback eventCallbackPositive, MouseEventCallback eventCallbackNegative) {
        ListIterator<Pane> it = this.children.listIterator(this.children.size());
        double mxChild = mx - (double)this.x - (double)this.padding;
        double myChild = my - (double)this.y - (double)this.padding;
        boolean invokedPositive = false;
        while (it.hasPrevious()) {
            Pane child = it.previous();
            if (panePredicate.accept(child, mxChild, myChild) && !invokedPositive) {
                if (eventCallbackNegative != null) {
                    invokedPositive = eventCallbackPositive.accept(child, mxChild, myChild);
                    continue;
                }
                return eventCallbackPositive.accept(child, mxChild, myChild);
            }
            if (eventCallbackNegative == null) continue;
            eventCallbackNegative.accept(child, mxChild, myChild);
        }
        return invokedPositive;
    }

    protected Pos2i.MutablePos2i accumulatePosition(Pos2i.MutablePos2i accumulator) {
        if (this.parent != null) {
            this.parent.accumulatePosition(accumulator);
        }
        accumulator.x += this.x;
        accumulator.y += this.y;
        return accumulator;
    }

    public Pos2i.ImmutablePos2i getAccumulatedPosition() {
        return this.accumulatePosition(new Pos2i.MutablePos2i()).toImmutable();
    }
}

