/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.client.screens.ScreenBase;
import wayoftime.bloodmagic.common.container.item.ContainerTrainingBracelet;
import wayoftime.bloodmagic.common.item.ItemLivingTrainer;
import wayoftime.bloodmagic.core.living.ILivingContainer;
import wayoftime.bloodmagic.core.living.LivingStats;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.network.LivingTrainerPacket;
import wayoftime.bloodmagic.network.LivingTrainerWhitelistPacket;

public class ScreenTrainingBracelet
extends ScreenBase<ContainerTrainingBracelet> {
    private static final ResourceLocation background = BloodMagic.rl("textures/gui/trainingbracelet.png");
    public Container trainerInventory;
    private Player player;
    private int left;
    private int top;
    private List<String> buttonKeyList = new ArrayList<String>();
    private int whitelistButtonPosX = 24;
    private int whitelistButtonPosY = 55;
    private int numberHoverPosX = 16;
    private int numberHoverPosY = 34;
    private int numberHoverWidth = 36;
    private int numberHoverHeight = 20;
    protected boolean isWhitelist = false;

    public ScreenTrainingBracelet(ContainerTrainingBracelet container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.trainerInventory = container.inventoryTrainer;
        this.f_97726_ = 176;
        this.f_97727_ = 187;
        this.player = playerInventory.f_35978_;
        this.isWhitelist = ((ItemLivingTrainer)container.trainerStack.m_41720_()).getIsWhitelist(container.trainerStack);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.left = (this.f_96543_ - this.f_97726_) / 2;
        this.top = (this.f_96544_ - this.f_97727_) / 2;
        this.buttonKeyList.clear();
        ItemStack filterStack = ((ContainerTrainingBracelet)this.container).trainerStack;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)">"), (Button.OnPress)new IncrementPress(this, 0)).m_252794_(this.left + 62 - 18, this.top + 34).m_253046_(8, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"<"), (Button.OnPress)new IncrementPress(this, 1)).m_252794_(this.left + 34 - 18, this.top + 34).m_253046_(8, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)""), (Button.OnPress)new WhitelistTogglePress(this)).m_252794_(this.left + this.whitelistButtonPosX, this.top + this.whitelistButtonPosY).m_253046_(20, 20).m_253136_());
    }

    private int getCurrentActiveSlotUpgradeLevel() {
        if (((ContainerTrainingBracelet)this.container).lastGhostSlotClicked == -1) {
            return 0;
        }
        ItemStack stack = ((ContainerTrainingBracelet)this.container).m_38853_(((ContainerTrainingBracelet)this.container).lastGhostSlotClicked).m_7993_();
        return this.getStackUpgradeLevel(stack);
    }

    private int setCurrentActiveSlotUpgradeLevel(int level) {
        LivingStats stats;
        if (((ContainerTrainingBracelet)this.container).lastGhostSlotClicked == -1) {
            return 0;
        }
        int slotClicked = ((ContainerTrainingBracelet)this.container).lastGhostSlotClicked;
        ItemStack stack = ((ContainerTrainingBracelet)this.container).m_38853_(slotClicked).m_7993_();
        level = Math.max(0, Math.min(level, this.getMaxUpgradeLevel(stack)));
        if (stack.m_41720_() instanceof ILivingContainer && (stats = ((ILivingContainer)stack.m_41720_()).getLivingStats(stack)) != null) {
            LivingStats newStats = new LivingStats();
            for (Map.Entry<LivingUpgrade, Double> entry : stats.getUpgrades().entrySet()) {
                double exp = level == 0 ? 0.01 : (double)entry.getKey().getLevelExp(level);
                newStats.addExperience(entry.getKey().getKey(), exp);
            }
            ((ILivingContainer)stack.m_41720_()).updateLivingStats(stack, newStats);
            ((ContainerTrainingBracelet)this.container).m_38853_(slotClicked).m_5852_(stack);
            ((ContainerTrainingBracelet)this.container).inventoryTrainer.m_6836_(slotClicked, stack);
            ((ItemLivingTrainer)((ContainerTrainingBracelet)this.container).trainerStack.m_41720_()).setTomeLevel(((ContainerTrainingBracelet)this.container).trainerStack, slotClicked, level);
            return level;
        }
        return 0;
    }

    private int getStackUpgradeLevel(ItemStack stack) {
        Iterator<Map.Entry<LivingUpgrade, Double>> iterator;
        LivingStats stats;
        if (stack.m_41720_() instanceof ILivingContainer && (stats = ((ILivingContainer)stack.m_41720_()).getLivingStats(stack)) != null && (iterator = stats.getUpgrades().entrySet().iterator()).hasNext()) {
            Map.Entry<LivingUpgrade, Double> entry = iterator.next();
            return entry.getKey().getLevel(entry.getValue().intValue());
        }
        return 0;
    }

    private int getMaxUpgradeLevel(ItemStack stack) {
        Iterator<Map.Entry<LivingUpgrade, Double>> iterator;
        LivingStats stats;
        if (stack.m_41720_() instanceof ILivingContainer && (stats = ((ILivingContainer)stack.m_41720_()).getLivingStats(stack)) != null && (iterator = stats.getUpgrades().entrySet().iterator()).hasNext()) {
            Map.Entry<LivingUpgrade, Double> entry = iterator.next();
            return entry.getKey().getLevel(Integer.MAX_VALUE);
        }
        return 0;
    }

    @Override
    public ResourceLocation getBackground() {
        return background;
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        String textEntry = "" + this.getCurrentActiveSlotUpgradeLevel();
        int offset = -3 * textEntry.length();
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)textEntry), 27 + offset + 7, 40, 0xFFFFFF, false);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"container.inventory"), 8, 93, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, ((ContainerTrainingBracelet)this.container).trainerStack.m_41786_(), 8, 4, 0x404040, false);
        int w = 20;
        int h = 20;
        int xl = this.whitelistButtonPosX;
        int yl = this.whitelistButtonPosY;
        guiGraphics.m_280218_(background, xl, yl, 176, this.isWhitelist ? 0 : 20, w, h);
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)background);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(background, x, y, 0, 0, this.f_97726_, this.f_97727_);
        ItemStack held = this.player.m_21120_(InteractionHand.MAIN_HAND);
        if (((ContainerTrainingBracelet)this.container).lastGhostSlotClicked >= 0) {
            guiGraphics.m_280218_(background, 85 + x + 21 * (((ContainerTrainingBracelet)this.container).lastGhostSlotClicked % 4), y + 11 + 21 * (((ContainerTrainingBracelet)this.container).lastGhostSlotClicked / 4), 0, 187, 24, 24);
        }
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        List<Component> components;
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        ArrayList<Component> tooltip = new ArrayList<Component>();
        int w = 20;
        int h = 20;
        int x = this.f_97735_ + this.whitelistButtonPosX;
        int y = this.f_97736_ + this.whitelistButtonPosY;
        if (mouseX >= x && mouseX < x + w && mouseY >= y && mouseY < y + h && (components = this.getHoverTextForWhitelistButton()) != null && !components.isEmpty()) {
            tooltip.addAll(components);
        }
        w = this.numberHoverWidth;
        h = this.numberHoverHeight;
        x = this.f_97735_ + this.numberHoverPosX;
        y = this.f_97736_ + this.numberHoverPosY;
        if (mouseX >= x && mouseX < x + w && mouseY >= y && mouseY < y + h && (components = this.getHoverTextForNumber()) != null && !components.isEmpty()) {
            tooltip.addAll(components);
        }
        if (!tooltip.isEmpty()) {
            guiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    private List<Component> getHoverTextForWhitelistButton() {
        ArrayList<Component> components = new ArrayList<Component>();
        if (this.isWhitelist) {
            components.add((Component)Component.m_237115_((String)"trainer.bloodmagic.whitelist"));
        } else {
            components.add((Component)Component.m_237115_((String)"trainer.bloodmagic.blacklist"));
        }
        return components;
    }

    private List<Component> getHoverTextForNumber() {
        LivingStats stats;
        ArrayList<Component> components = new ArrayList<Component>();
        if (((ContainerTrainingBracelet)this.container).lastGhostSlotClicked == -1) {
            return components;
        }
        int slotClicked = ((ContainerTrainingBracelet)this.container).lastGhostSlotClicked;
        ItemStack stack = ((ContainerTrainingBracelet)this.container).m_38853_(slotClicked).m_7993_();
        if (stack.m_41720_() instanceof ILivingContainer && (stats = ((ILivingContainer)stack.m_41720_()).getLivingStats(stack)) != null) {
            for (Map.Entry<LivingUpgrade, Double> entry : stats.getUpgrades().entrySet()) {
                int level = entry.getKey().getLevel(entry.getValue().intValue());
                if (level > 0) {
                    components.add((Component)Component.m_237110_((String)"trainer.bloodmagic.allowupgrade", (Object[])new Object[]{Component.m_237115_((String)entry.getKey().getTranslationKey()), Component.m_237115_((String)("enchantment.level." + level))}));
                    continue;
                }
                components.add((Component)Component.m_237110_((String)"trainer.bloodmagic.blockupgrade", (Object[])new Object[]{Component.m_237115_((String)entry.getKey().getTranslationKey())}));
            }
        }
        return components;
    }

    public class IncrementPress
    implements Button.OnPress {
        private final ScreenTrainingBracelet screen;
        private final int id;

        public IncrementPress(ScreenTrainingBracelet screen, int id) {
            this.screen = screen;
            this.id = id;
        }

        public void m_93750_(Button button) {
            if (((ContainerTrainingBracelet)this.screen.container).lastGhostSlotClicked == -1) {
                return;
            }
            if (this.id == 0) {
                int currentLevel = ScreenTrainingBracelet.this.getCurrentActiveSlotUpgradeLevel();
                int newLevel = ScreenTrainingBracelet.this.setCurrentActiveSlotUpgradeLevel(currentLevel + 1);
                BloodMagic.packetHandler.sendToServer(new LivingTrainerPacket(ScreenTrainingBracelet.this.player.m_150109_().f_35977_, ((ContainerTrainingBracelet)this.screen.container).lastGhostSlotClicked, newLevel));
            } else if (this.id == 1) {
                int currentLevel = ScreenTrainingBracelet.this.getCurrentActiveSlotUpgradeLevel();
                int newLevel = ScreenTrainingBracelet.this.setCurrentActiveSlotUpgradeLevel(currentLevel - 1);
                BloodMagic.packetHandler.sendToServer(new LivingTrainerPacket(ScreenTrainingBracelet.this.player.m_150109_().f_35977_, ((ContainerTrainingBracelet)this.screen.container).lastGhostSlotClicked, newLevel));
            }
        }
    }

    public class WhitelistTogglePress
    implements Button.OnPress {
        private final ScreenTrainingBracelet screen;

        public WhitelistTogglePress(ScreenTrainingBracelet screen) {
            this.screen = screen;
        }

        public void m_93750_(Button button) {
            boolean newWhitelistState;
            this.screen.isWhitelist = newWhitelistState = !this.screen.isWhitelist;
            ((ItemLivingTrainer)((ContainerTrainingBracelet)this.screen.container).trainerStack.m_41720_()).setIsWhitelist(((ContainerTrainingBracelet)this.screen.container).trainerStack, newWhitelistState);
            BloodMagic.packetHandler.sendToServer(new LivingTrainerWhitelistPacket(ScreenTrainingBracelet.this.player.m_150109_().f_35977_, newWhitelistState));
        }
    }
}

