/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.data.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.crafting.Ingredient;
import wayoftime.bloodmagic.common.data.recipe.BloodMagicRecipeBuilder;
import wayoftime.bloodmagic.potion.BloodMagicPotions;

public class PotionEffectRecipeBuilder
extends BloodMagicRecipeBuilder<PotionEffectRecipeBuilder> {
    private final List<Ingredient> input;
    private final MobEffect outputEffect;
    private final int baseDuration;
    private final int syphon;
    private final int ticks;
    private final int minimumTier;

    protected PotionEffectRecipeBuilder(List<Ingredient> input, MobEffect outputEffect, int baseDuration, int syphon, int ticks, int minimumTier) {
        super(PotionEffectRecipeBuilder.bmSerializer("flask_potioneffect"));
        this.outputEffect = outputEffect;
        this.baseDuration = baseDuration;
        this.input = input;
        this.syphon = syphon;
        this.ticks = ticks;
        this.minimumTier = minimumTier;
    }

    public static PotionEffectRecipeBuilder potionEffect(MobEffect outputEffect, int baseDuration, int syphon, int ticks, int minimumTier) {
        ArrayList<Ingredient> inputList = new ArrayList<Ingredient>();
        return new PotionEffectRecipeBuilder(inputList, outputEffect, baseDuration, syphon, ticks, minimumTier);
    }

    public PotionEffectRecipeBuilder addIngredient(Ingredient ing) {
        if (this.input.size() < 5) {
            this.input.add(ing);
        }
        return this;
    }

    @Override
    protected PotionEffectRecipeResult getResult(ResourceLocation id) {
        return new PotionEffectRecipeResult(id);
    }

    public class PotionEffectRecipeResult
    extends BloodMagicRecipeBuilder.RecipeResult {
        protected PotionEffectRecipeResult(ResourceLocation id) {
            super(id);
        }

        public void m_7917_(@Nonnull JsonObject json) {
            if (PotionEffectRecipeBuilder.this.input.size() > 0) {
                JsonArray mainArray = new JsonArray();
                for (Ingredient ing : PotionEffectRecipeBuilder.this.input) {
                    JsonElement jsonObj = ing.m_43942_();
                    mainArray.add(jsonObj);
                }
                json.add("input", (JsonElement)mainArray);
            }
            json.addProperty("syphon", (Number)PotionEffectRecipeBuilder.this.syphon);
            json.addProperty("ticks", (Number)PotionEffectRecipeBuilder.this.ticks);
            json.addProperty("upgradeLevel", (Number)PotionEffectRecipeBuilder.this.minimumTier);
            json.addProperty("effect", BloodMagicPotions.getRegistryName(PotionEffectRecipeBuilder.this.outputEffect).toString());
            json.addProperty("baseDuration", (Number)PotionEffectRecipeBuilder.this.baseDuration);
        }
    }
}

