/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.IBindable;
import wayoftime.bloodmagic.core.data.Binding;

public class ItemActivationCrystal
extends Item
implements IBindable {
    final CrystalType type;

    public ItemActivationCrystal(CrystalType type) {
        super(new Item.Properties().m_41487_(1));
        this.type = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)("tooltip.bloodmagic.activationcrystal." + this.type.name().toLowerCase(Locale.ROOT))).m_130940_(ChatFormatting.GRAY));
        if (!stack.m_41782_()) {
            return;
        }
        Binding binding = this.getBinding(stack);
        if (binding != null) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.bloodmagic.currentOwner", (Object[])new Object[]{binding.getOwnerName()}).m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(stack, world, tooltip, flag);
    }

    public int getCrystalLevel(ItemStack stack) {
        return this.type.equals((Object)CrystalType.CREATIVE) ? Integer.MAX_VALUE : this.type.ordinal() + 1;
    }

    public static enum CrystalType {
        WEAK,
        AWAKENED,
        CREATIVE;


        @Nonnull
        public static ItemStack getStack(int level) {
            if (level < 0) {
                level = 0;
            }
            switch (level) {
                case 0: {
                    return new ItemStack((ItemLike)BloodMagicItems.WEAK_ACTIVATION_CRYSTAL.get());
                }
                case 1: {
                    return new ItemStack((ItemLike)BloodMagicItems.AWAKENED_ACTIVATION_CRYSTAL.get());
                }
            }
            return new ItemStack((ItemLike)BloodMagicItems.CREATIVE_ACTIVATION_CRYSTAL.get());
        }
    }
}

