/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.routing;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.common.routing.IMasterRoutingNode;
import wayoftime.bloodmagic.common.routing.INodeRenderer;
import wayoftime.bloodmagic.common.routing.IRoutingNode;
import wayoftime.bloodmagic.util.helper.NBTHelper;

public class ItemNodeRouter
extends Item
implements INodeRenderer {
    public ItemNodeRouter() {
        super(new Item.Properties().m_41487_(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        if (!stack.m_41782_()) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        BlockPos coords = this.getBlockPos(stack);
        if (coords != null && tag != null) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.bloodmagic.telepositionfocus.coords", (Object[])new Object[]{coords.m_123341_(), coords.m_123342_(), coords.m_123343_()}));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult m_6225_(UseOnContext context) {
        InteractionHand hand = context.m_43724_();
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        ItemStack stack = player.m_21120_(hand);
        if (world.f_46443_) {
            return InteractionResult.PASS;
        }
        BlockEntity tileHit = world.m_7702_(pos);
        if (!(tileHit instanceof IRoutingNode)) {
            BlockPos containedPos = this.getBlockPos(stack);
            if (containedPos.equals((Object)BlockPos.f_121853_)) return InteractionResult.FAIL;
            this.setBlockPos(stack, BlockPos.f_121853_);
            player.m_5661_((Component)Component.m_237115_((String)"chat.bloodmagic.routing.remove"), true);
            return InteractionResult.FAIL;
        }
        IRoutingNode node = (IRoutingNode)tileHit;
        BlockPos containedPos = this.getBlockPos(stack);
        if (containedPos.equals((Object)BlockPos.f_121853_)) {
            this.setBlockPos(stack, pos);
            player.m_5661_((Component)Component.m_237115_((String)"chat.bloodmagic.routing.set"), true);
            return InteractionResult.SUCCESS;
        }
        if (containedPos.m_123331_((Vec3i)pos) > 256.0) {
            player.m_5661_((Component)Component.m_237115_((String)"chat.bloodmagic.routing.distance"), true);
            return InteractionResult.SUCCESS;
        }
        if (containedPos.equals((Object)pos)) {
            player.m_5661_((Component)Component.m_237115_((String)"chat.bloodmagic.routing.same"), true);
            return InteractionResult.SUCCESS;
        }
        BlockEntity pastTile = world.m_7702_(containedPos);
        if (!(pastTile instanceof IRoutingNode)) return InteractionResult.FAIL;
        IRoutingNode pastNode = (IRoutingNode)pastTile;
        if (pastNode instanceof IMasterRoutingNode) {
            IMasterRoutingNode master = (IMasterRoutingNode)pastNode;
            if (!node.isMaster(master)) {
                if (!node.getMasterPos().equals((Object)BlockPos.f_121853_)) return InteractionResult.FAIL;
                node.connectMasterToRemainingNode(world, new LinkedList<BlockPos>(), master);
                master.addConnection(pos, containedPos);
                master.addNodeToList(node);
                node.addConnection(containedPos);
                player.m_5661_((Component)Component.m_237115_((String)"chat.bloodmagic.routing.link.master"), true);
                this.setBlockPos(stack, BlockPos.f_121853_);
                return InteractionResult.SUCCESS;
            }
            master.addConnection(pos, containedPos);
            node.addConnection(containedPos);
            player.m_5661_((Component)Component.m_237115_((String)"chat.bloodmagic.routing.link.master"), true);
            this.setBlockPos(stack, BlockPos.f_121853_);
            return InteractionResult.SUCCESS;
        }
        if (node instanceof IMasterRoutingNode) {
            IMasterRoutingNode master = (IMasterRoutingNode)node;
            if (!pastNode.isMaster(master)) {
                if (!pastNode.getMasterPos().equals((Object)BlockPos.f_121853_)) return InteractionResult.FAIL;
                pastNode.connectMasterToRemainingNode(world, new LinkedList<BlockPos>(), master);
                master.addConnection(pos, containedPos);
                pastNode.addConnection(pos);
                master.addNodeToList(pastNode);
                player.m_5661_((Component)Component.m_237115_((String)"chat.bloodmagic.routing.link.master"), true);
                this.setBlockPos(stack, BlockPos.f_121853_);
                return InteractionResult.SUCCESS;
            }
            master.addConnection(pos, containedPos);
            pastNode.addConnection(pos);
            player.m_5661_((Component)Component.m_237115_((String)"chat.bloodmagic.routing.link.master"), true);
            this.setBlockPos(stack, BlockPos.f_121853_);
            return InteractionResult.SUCCESS;
        }
        if (pastNode.getMasterPos().equals((Object)node.getMasterPos())) {
            BlockEntity testTile;
            if (!pastNode.getMasterPos().equals((Object)BlockPos.f_121853_) && (testTile = world.m_7702_(pastNode.getMasterPos())) instanceof IMasterRoutingNode) {
                IMasterRoutingNode master = (IMasterRoutingNode)testTile;
                master.addConnection(pos, containedPos);
            }
            pastNode.addConnection(pos);
            node.addConnection(containedPos);
            player.m_5661_((Component)Component.m_237115_((String)"chat.bloodmagic.routing.link"), true);
            this.setBlockPos(stack, BlockPos.f_121853_);
            return InteractionResult.SUCCESS;
        }
        if (pastNode.getMasterPos().equals((Object)BlockPos.f_121853_)) {
            BlockEntity tile = world.m_7702_(node.getMasterPos());
            if (tile instanceof IMasterRoutingNode) {
                IMasterRoutingNode master = (IMasterRoutingNode)tile;
                master.addConnection(pos, containedPos);
                master.addNodeToList(pastNode);
                pastNode.connectMasterToRemainingNode(world, new LinkedList<BlockPos>(), master);
            }
            pastNode.addConnection(pos);
            node.addConnection(containedPos);
            player.m_5661_((Component)Component.m_237115_((String)"chat.bloodmagic.routing.link"), true);
            this.setBlockPos(stack, BlockPos.f_121853_);
            return InteractionResult.SUCCESS;
        }
        if (node.getMasterPos().equals((Object)BlockPos.f_121853_)) {
            BlockEntity tile = world.m_7702_(pastNode.getMasterPos());
            if (tile instanceof IMasterRoutingNode) {
                IMasterRoutingNode master = (IMasterRoutingNode)tile;
                master.addConnection(pos, containedPos);
                master.addNodeToList(node);
                node.connectMasterToRemainingNode(world, new LinkedList<BlockPos>(), master);
            }
            pastNode.addConnection(pos);
            node.addConnection(containedPos);
            player.m_5661_((Component)Component.m_237115_((String)"chat.bloodmagic.routing.link"), true);
            this.setBlockPos(stack, BlockPos.f_121853_);
            return InteractionResult.SUCCESS;
        }
        this.setBlockPos(stack, BlockPos.f_121853_);
        return InteractionResult.SUCCESS;
    }

    public BlockPos getBlockPos(ItemStack stack) {
        stack = NBTHelper.checkNBT(stack);
        return new BlockPos(stack.m_41783_().m_128451_("xCoord"), stack.m_41783_().m_128451_("yCoord"), stack.m_41783_().m_128451_("zCoord"));
    }

    public ItemStack setBlockPos(ItemStack stack, BlockPos pos) {
        NBTHelper.checkNBT(stack);
        CompoundTag itemTag = stack.m_41783_();
        itemTag.m_128405_("xCoord", pos.m_123341_());
        itemTag.m_128405_("yCoord", pos.m_123342_());
        itemTag.m_128405_("zCoord", pos.m_123343_());
        return stack;
    }
}

