/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.event;

import java.util.UUID;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.imperfect.IImperfectRitualStone;
import wayoftime.bloodmagic.ritual.imperfect.ImperfectRitual;

public class RitualEvent
extends Event {
    private final IMasterRitualStone mrs;
    private final UUID ownerId;
    private final Ritual ritual;

    private RitualEvent(IMasterRitualStone mrs, UUID ownerId, Ritual ritual) {
        this.mrs = mrs;
        this.ownerId = ownerId;
        this.ritual = ritual;
    }

    public IMasterRitualStone getRitualStone() {
        return this.mrs;
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }

    public Ritual getRitual() {
        return this.ritual;
    }

    @Cancelable
    public static class ImperfectRitualActivatedEvent
    extends Event {
        private final IImperfectRitualStone ims;
        private final Player activator;
        private final ImperfectRitual imperfectRitual;

        public ImperfectRitualActivatedEvent(IImperfectRitualStone ims, Player activator, ImperfectRitual imperfectRitual) {
            this.ims = ims;
            this.activator = activator;
            this.imperfectRitual = imperfectRitual;
        }

        public IImperfectRitualStone getRitualStone() {
            return this.ims;
        }

        public Player getActivator() {
            return this.activator;
        }

        public ImperfectRitual getImperfectRitual() {
            return this.imperfectRitual;
        }
    }

    public static class RitualStopEvent
    extends RitualEvent {
        private final Ritual.BreakType method;

        public RitualStopEvent(IMasterRitualStone mrs, UUID ownerId, Ritual ritual, Ritual.BreakType method) {
            super(mrs, ownerId, ritual);
            this.method = method;
        }

        public Ritual.BreakType getMethod() {
            return this.method;
        }
    }

    @Cancelable
    public static class RitualRunEvent
    extends RitualEvent {
        public RitualRunEvent(IMasterRitualStone mrs, UUID ownerId, Ritual ritual) {
            super(mrs, ownerId, ritual);
        }
    }

    @Cancelable
    public static class RitualActivatedEvent
    extends RitualEvent {
        private final Player player;
        private final ItemStack crystalStack;
        private final int crystalTier;

        public RitualActivatedEvent(IMasterRitualStone mrs, UUID ownerId, Ritual ritual, Player player, ItemStack activationCrystal, int crystalTier) {
            super(mrs, ownerId, ritual);
            this.player = player;
            this.crystalStack = activationCrystal;
            this.crystalTier = crystalTier;
        }

        public Player getPlayer() {
            return this.player;
        }

        public ItemStack getCrystalStack() {
            return this.crystalStack;
        }

        public int getCrystalTier() {
            return this.crystalTier;
        }
    }
}

