/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.decoration;

import com.teammoeg.caupona.blocks.decoration.CPRoadBlock;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CPRoadSideBlock
extends CPRoadBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.f_61398_;
    protected static final VoxelShape OCTET_NW = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)6.0, (double)24.0, (double)6.0);
    protected static final VoxelShape OCTET_SW = Block.m_49796_((double)0.0, (double)14.0, (double)10.0, (double)6.0, (double)24.0, (double)16.0);
    protected static final VoxelShape OCTET_NE = Block.m_49796_((double)10.0, (double)14.0, (double)0.0, (double)16.0, (double)24.0, (double)6.0);
    protected static final VoxelShape OCTET_SE = Block.m_49796_((double)10.0, (double)14.0, (double)10.0, (double)16.0, (double)24.0, (double)16.0);
    protected static final VoxelShape OCTET_N = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)24.0, (double)6.0);
    protected static final VoxelShape OCTET_W = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)6.0, (double)24.0, (double)16.0);
    protected static final VoxelShape OCTET_E = Block.m_49796_((double)10.0, (double)14.0, (double)0.0, (double)16.0, (double)24.0, (double)16.0);
    protected static final VoxelShape OCTET_S = Block.m_49796_((double)0.0, (double)14.0, (double)10.0, (double)16.0, (double)24.0, (double)16.0);
    protected static final VoxelShape[] BOTTOM_SHAPES = CPRoadSideBlock.makeShapes();
    private static final int[] SHAPE_BY_STATE = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};

    private static VoxelShape[] makeShapes() {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(p_56945_ -> CPRoadSideBlock.makeStairShape(p_56945_)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape makeStairShape(int pBitfield) {
        VoxelShape voxelshape = BASE_AABB;
        if ((pBitfield & 1) != 0) {
            if ((pBitfield & 2) != 0) {
                voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)OCTET_N);
            }
            if ((pBitfield & 4) != 0) {
                voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)OCTET_W);
            }
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)OCTET_NW);
        }
        if ((pBitfield & 8) != 0) {
            if ((pBitfield & 2) != 0) {
                voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)OCTET_E);
            }
            if ((pBitfield & 4) != 0) {
                voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)OCTET_S);
            }
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)OCTET_SE);
        }
        if ((pBitfield & 2) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)OCTET_NE);
        }
        if ((pBitfield & 4) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)OCTET_SW);
        }
        return voxelshape;
    }

    public CPRoadSideBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return BASE_AABB;
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return BOTTOM_SHAPES[SHAPE_BY_STATE[this.getShapeIndex(pState)]];
    }

    public boolean m_7923_(BlockState pState) {
        return true;
    }

    private int getShapeIndex(BlockState pState) {
        return ((StairsShape)pState.m_61143_(SHAPE)).ordinal() * 4 + ((Direction)pState.m_61143_((Property)FACING)).m_122416_();
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos blockpos = pContext.m_8083_();
        BlockState blockstate = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)(pContext.m_43723_().m_6144_() ? pContext.m_8125_() : pContext.m_8125_().m_122424_()));
        return (BlockState)blockstate.m_61124_(SHAPE, (Comparable)CPRoadSideBlock.getStairsShape(blockstate, (BlockGetter)pContext.m_43725_(), blockpos));
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return pFacing.m_122434_().m_122479_() ? (BlockState)pState.m_61124_(SHAPE, (Comparable)CPRoadSideBlock.getStairsShape(pState, (BlockGetter)pLevel, pCurrentPos)) : pState;
    }

    public static boolean isRoadBlock(BlockState pState) {
        return pState.m_60734_() instanceof CPRoadSideBlock;
    }

    private static StairsShape getStairsShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        BlockState blockstate = pLevel.m_8055_(pPos.m_121945_(direction));
        if (CPRoadSideBlock.isRoadBlock(blockstate) && (direction1 = (Direction)blockstate.m_61143_((Property)FACING)).m_122434_() != ((Direction)pState.m_61143_((Property)FACING)).m_122434_() && CPRoadSideBlock.canTakeShape(pState, pLevel, pPos, direction1.m_122424_())) {
            if (direction1 == direction.m_122428_()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = pLevel.m_8055_(pPos.m_121945_(direction.m_122424_()));
        if (CPRoadSideBlock.isRoadBlock(blockstate1) && (direction2 = (Direction)blockstate1.m_61143_((Property)FACING)).m_122434_() != ((Direction)pState.m_61143_((Property)FACING)).m_122434_() && CPRoadSideBlock.canTakeShape(pState, pLevel, pPos, direction2)) {
            if (direction2 == direction.m_122428_()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, Direction pFace) {
        BlockState blockstate = pLevel.m_8055_(pPos.m_121945_(pFace));
        return !CPRoadSideBlock.isRoadBlock(blockstate) || blockstate.m_61143_((Property)FACING) != pState.m_61143_((Property)FACING);
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        StairsShape stairsshape = (StairsShape)pState.m_61143_(SHAPE);
        switch (pMirror) {
            case LEFT_RIGHT: {
                if (direction.m_122434_() != Direction.Axis.Z) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                }
                return pState.m_60717_(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (direction.m_122434_() != Direction.Axis.X) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                    case STRAIGHT: {
                        return pState.m_60717_(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.m_6943_(pState, pMirror);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, SHAPE});
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }
}

