/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.decoration;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SpokedFenceBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty EAST_WALL = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty NORTH_WALL = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty SOUTH_WALL = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty WEST_WALL = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final Map<BlockState, VoxelShape> shapeByIndex;
    private final Map<BlockState, VoxelShape> collisionShapeByIndex;

    public SpokedFenceBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH_WALL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST_WALL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH_WALL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST_WALL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapeByIndex = this.makeShapes(2.0f, 2.0f, 16.0f, 0.0f, 16.0f);
        this.collisionShapeByIndex = this.makeShapes(2.0f, 2.0f, 24.0f, 0.0f, 24.0f);
    }

    private static VoxelShape applyWallShape(VoxelShape pBaseShape, boolean pHeight, VoxelShape pTallShape) {
        if (pHeight) {
            return Shapes.m_83110_((VoxelShape)pBaseShape, (VoxelShape)pTallShape);
        }
        return pBaseShape;
    }

    private Map<BlockState, VoxelShape> makeShapes(float pWidth, float pDepth, float pWallPostHeight, float pWallMinY, float pWallTallHeight) {
        float f = 8.0f - pWidth;
        float f1 = 8.0f + pWidth;
        float f2 = 8.0f - pDepth;
        float f3 = 8.0f + pDepth;
        VoxelShape voxelshape = Block.m_49796_((double)f, (double)0.0, (double)f, (double)f1, (double)pWallPostHeight, (double)f1);
        VoxelShape voxelshape5 = Block.m_49796_((double)f2, (double)pWallMinY, (double)0.0, (double)f3, (double)pWallTallHeight, (double)f3);
        VoxelShape voxelshape6 = Block.m_49796_((double)f2, (double)pWallMinY, (double)f2, (double)f3, (double)pWallTallHeight, (double)16.0);
        VoxelShape voxelshape7 = Block.m_49796_((double)0.0, (double)pWallMinY, (double)f2, (double)f3, (double)pWallTallHeight, (double)f3);
        VoxelShape voxelshape8 = Block.m_49796_((double)f2, (double)pWallMinY, (double)f2, (double)16.0, (double)pWallTallHeight, (double)f3);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Boolean wallside : EAST_WALL.m_6908_()) {
            for (Boolean wallside1 : NORTH_WALL.m_6908_()) {
                for (Boolean wallside2 : WEST_WALL.m_6908_()) {
                    for (Boolean wallside3 : SOUTH_WALL.m_6908_()) {
                        VoxelShape voxelshape9 = voxelshape;
                        voxelshape9 = SpokedFenceBlock.applyWallShape(voxelshape9, wallside, voxelshape8);
                        voxelshape9 = SpokedFenceBlock.applyWallShape(voxelshape9, wallside2, voxelshape7);
                        voxelshape9 = SpokedFenceBlock.applyWallShape(voxelshape9, wallside1, voxelshape5);
                        voxelshape9 = SpokedFenceBlock.applyWallShape(voxelshape9, wallside3, voxelshape6);
                        BlockState blockstate = (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)EAST_WALL, (Comparable)wallside)).m_61124_((Property)WEST_WALL, (Comparable)wallside2)).m_61124_((Property)NORTH_WALL, (Comparable)wallside1)).m_61124_((Property)SOUTH_WALL, (Comparable)wallside3);
                        builder.put((Object)((BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))), (Object)voxelshape9);
                        builder.put((Object)((BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))), (Object)voxelshape9);
                    }
                }
            }
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapeByIndex.get(pState);
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.collisionShapeByIndex.get(pState);
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    private boolean connectsTo(BlockState pState, boolean pSideSolid, Direction pDirection) {
        Block block = pState.m_60734_();
        boolean flag = block instanceof FenceGateBlock && FenceGateBlock.m_53378_((BlockState)pState, (Direction)pDirection);
        return pState.m_204336_(BlockTags.f_13032_) || !SpokedFenceBlock.m_152463_((BlockState)pState) && pSideSolid || block instanceof IronBarsBlock || flag || block instanceof SpokedFenceBlock;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        Level levelreader = pContext.m_43725_();
        BlockPos blockpos = pContext.m_8083_();
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        BlockPos blockpos1 = blockpos.m_122012_();
        BlockPos blockpos2 = blockpos.m_122029_();
        BlockPos blockpos3 = blockpos.m_122019_();
        BlockPos blockpos4 = blockpos.m_122024_();
        BlockState blockstate = levelreader.m_8055_(blockpos1);
        BlockState blockstate1 = levelreader.m_8055_(blockpos2);
        BlockState blockstate2 = levelreader.m_8055_(blockpos3);
        BlockState blockstate3 = levelreader.m_8055_(blockpos4);
        boolean flag = this.connectsTo(blockstate, blockstate.m_60783_((BlockGetter)levelreader, blockpos1, Direction.SOUTH), Direction.SOUTH);
        boolean flag1 = this.connectsTo(blockstate1, blockstate1.m_60783_((BlockGetter)levelreader, blockpos2, Direction.WEST), Direction.WEST);
        boolean flag2 = this.connectsTo(blockstate2, blockstate2.m_60783_((BlockGetter)levelreader, blockpos3, Direction.NORTH), Direction.NORTH);
        boolean flag3 = this.connectsTo(blockstate3, blockstate3.m_60783_((BlockGetter)levelreader, blockpos4, Direction.EAST), Direction.EAST);
        BlockState blockstate5 = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        return this.updateShape(blockstate5, flag, flag1, flag2, flag3);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        if (pFacing == Direction.DOWN) {
            return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        }
        return pFacing == Direction.UP ? this.topUpdate(pState) : this.sideUpdate((LevelReader)pLevel, pState, pFacingPos, pFacingState, pFacing);
    }

    private static boolean isConnected(BlockState pState, BooleanProperty pHeightProperty) {
        return (Boolean)pState.m_61143_((Property)pHeightProperty);
    }

    private BlockState topUpdate(BlockState pState) {
        boolean flag = SpokedFenceBlock.isConnected(pState, NORTH_WALL);
        boolean flag1 = SpokedFenceBlock.isConnected(pState, EAST_WALL);
        boolean flag2 = SpokedFenceBlock.isConnected(pState, SOUTH_WALL);
        boolean flag3 = SpokedFenceBlock.isConnected(pState, WEST_WALL);
        return this.updateShape(pState, flag, flag1, flag2, flag3);
    }

    private BlockState sideUpdate(LevelReader pLevel, BlockState pFirstState, BlockPos pSecondPos, BlockState pSecondState, Direction pDir) {
        Direction direction = pDir.m_122424_();
        boolean flag = pDir == Direction.NORTH ? this.connectsTo(pSecondState, pSecondState.m_60783_((BlockGetter)pLevel, pSecondPos, direction), direction) : SpokedFenceBlock.isConnected(pFirstState, NORTH_WALL);
        boolean flag1 = pDir == Direction.EAST ? this.connectsTo(pSecondState, pSecondState.m_60783_((BlockGetter)pLevel, pSecondPos, direction), direction) : SpokedFenceBlock.isConnected(pFirstState, EAST_WALL);
        boolean flag2 = pDir == Direction.SOUTH ? this.connectsTo(pSecondState, pSecondState.m_60783_((BlockGetter)pLevel, pSecondPos, direction), direction) : SpokedFenceBlock.isConnected(pFirstState, SOUTH_WALL);
        boolean flag3 = pDir == Direction.WEST ? this.connectsTo(pSecondState, pSecondState.m_60783_((BlockGetter)pLevel, pSecondPos, direction), direction) : SpokedFenceBlock.isConnected(pFirstState, WEST_WALL);
        return this.updateShape(pFirstState, flag, flag1, flag2, flag3);
    }

    private BlockState updateShape(BlockState pState, boolean pNorthConnection, boolean pEastConnection, boolean pSouthConnection, boolean pWestConnection) {
        BlockState blockstate = this.updateSides(pState, pNorthConnection, pEastConnection, pSouthConnection, pWestConnection);
        return blockstate;
    }

    private BlockState updateSides(BlockState pState, boolean pNorthConnection, boolean pEastConnection, boolean pSouthConnection, boolean pWestConnection) {
        return (BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_((Property)NORTH_WALL, (Comparable)Boolean.valueOf(pNorthConnection))).m_61124_((Property)EAST_WALL, (Comparable)Boolean.valueOf(pEastConnection))).m_61124_((Property)SOUTH_WALL, (Comparable)Boolean.valueOf(pSouthConnection))).m_61124_((Property)WEST_WALL, (Comparable)Boolean.valueOf(pWestConnection));
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public boolean m_7420_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) == false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{NORTH_WALL, EAST_WALL, WEST_WALL, SOUTH_WALL, WATERLOGGED});
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        switch (pRotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_((Property)NORTH_WALL, (Comparable)((Boolean)pState.m_61143_((Property)SOUTH_WALL)))).m_61124_((Property)EAST_WALL, (Comparable)((Boolean)pState.m_61143_((Property)WEST_WALL)))).m_61124_((Property)SOUTH_WALL, (Comparable)((Boolean)pState.m_61143_((Property)NORTH_WALL)))).m_61124_((Property)WEST_WALL, (Comparable)((Boolean)pState.m_61143_((Property)EAST_WALL)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_((Property)NORTH_WALL, (Comparable)((Boolean)pState.m_61143_((Property)EAST_WALL)))).m_61124_((Property)EAST_WALL, (Comparable)((Boolean)pState.m_61143_((Property)SOUTH_WALL)))).m_61124_((Property)SOUTH_WALL, (Comparable)((Boolean)pState.m_61143_((Property)WEST_WALL)))).m_61124_((Property)WEST_WALL, (Comparable)((Boolean)pState.m_61143_((Property)NORTH_WALL)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_((Property)NORTH_WALL, (Comparable)((Boolean)pState.m_61143_((Property)WEST_WALL)))).m_61124_((Property)EAST_WALL, (Comparable)((Boolean)pState.m_61143_((Property)NORTH_WALL)))).m_61124_((Property)SOUTH_WALL, (Comparable)((Boolean)pState.m_61143_((Property)EAST_WALL)))).m_61124_((Property)WEST_WALL, (Comparable)((Boolean)pState.m_61143_((Property)SOUTH_WALL)));
            }
        }
        return pState;
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        switch (pMirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)pState.m_61124_((Property)NORTH_WALL, (Comparable)((Boolean)pState.m_61143_((Property)SOUTH_WALL)))).m_61124_((Property)SOUTH_WALL, (Comparable)((Boolean)pState.m_61143_((Property)NORTH_WALL)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)pState.m_61124_((Property)EAST_WALL, (Comparable)((Boolean)pState.m_61143_((Property)WEST_WALL)))).m_61124_((Property)WEST_WALL, (Comparable)((Boolean)pState.m_61143_((Property)EAST_WALL)));
            }
        }
        return super.m_6943_(pState, pMirror);
    }
}

