/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.pot;

import com.teammoeg.caupona.blocks.CPRegisteredEntityBlock;
import com.teammoeg.caupona.blocks.pot.StewPotBlockEntity;
import com.teammoeg.caupona.client.CPParticles;
import com.teammoeg.caupona.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.RegistryObject;

public class StewPot
extends CPRegisteredEntityBlock<StewPotBlockEntity>
implements LiquidBlockContainer {
    public static final EnumProperty<Direction.Axis> FACING = BlockStateProperties.f_61364_;
    static final VoxelShape shape = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0);

    public StewPot(BlockBehaviour.Properties blockProps, RegistryObject<BlockEntityType<StewPotBlockEntity>> ste) {
        super(blockProps, ste);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return shape;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        InteractionResult p = super.m_6227_(state, worldIn, pos, player, handIn, hit);
        if (p.m_19077_()) {
            return p;
        }
        StewPotBlockEntity blockEntity = (StewPotBlockEntity)worldIn.m_7702_(pos);
        if (blockEntity.canAddFluid()) {
            ItemStack held = player.m_21120_(handIn);
            if (held.m_41619_() && player.m_6144_()) {
                blockEntity.getTank().setFluid(FluidStack.EMPTY);
                return InteractionResult.SUCCESS;
            }
            FluidStack out = Utils.extractFluid(held);
            if (!out.isEmpty()) {
                if (blockEntity.tryAddFluid(out)) {
                    ItemStack ret = held.getCraftingRemainingItem();
                    held.m_41774_(1);
                    if (!player.m_36356_(ret)) {
                        player.m_36176_(ret, false);
                    }
                }
                return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
            }
            if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)handIn, (IFluidHandler)blockEntity.getTank())) {
                return InteractionResult.SUCCESS;
            }
        }
        if (handIn == InteractionHand.MAIN_HAND) {
            if (!(blockEntity == null || worldIn.f_46443_ || !player.m_150110_().f_35937_ && blockEntity.isInfinite)) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)blockEntity, (BlockPos)blockEntity.m_58899_());
            }
            return InteractionResult.SUCCESS;
        }
        return p;
    }

    public boolean m_6044_(BlockGetter w, BlockPos p, BlockState s, Fluid f) {
        StewPotBlockEntity blockEntity = (StewPotBlockEntity)w.m_7702_(p);
        return blockEntity.canAddFluid(new FluidStack(f, 1000));
    }

    public boolean m_7361_(LevelAccessor w, BlockPos p, BlockState s, FluidState f) {
        StewPotBlockEntity blockEntity = (StewPotBlockEntity)w.m_7702_(p);
        return blockEntity.tryAddFluid(new FluidStack(f.m_76152_(), 1000));
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof StewPotBlockEntity) {
            StewPotBlockEntity pot = (StewPotBlockEntity)blockEntity;
            if (pot.proctype == 2 && pot.working) {
                int count = 2;
                while (--count != 0) {
                    worldIn.m_7106_((ParticleOptions)CPParticles.STEAM.get(), (double)((float)pos.m_123341_() + rand.m_188501_()), (double)(pos.m_123342_() + 1), (double)((float)pos.m_123343_() + rand.m_188501_()), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof StewPotBlockEntity) {
            StewPotBlockEntity pot = (StewPotBlockEntity)blockEntity;
            if (state.m_60734_() != newState.m_60734_()) {
                ItemStack is;
                if (pot.proctype != 2) {
                    for (int i = 0; i < 9; ++i) {
                        is = pot.getInv().getStackInSlot(i);
                        if (is.m_41619_()) continue;
                        CPRegisteredEntityBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)is);
                    }
                }
                for (int i = 9; i < 12; ++i) {
                    is = pot.getInv().getStackInSlot(i);
                    if (is.m_41619_()) continue;
                    CPRegisteredEntityBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)is);
                }
            }
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_(FACING, (Comparable)context.m_8125_().m_122434_());
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        StewPotBlockEntity blockEntity = (StewPotBlockEntity)pLevel.m_7702_(pPos);
        if (blockEntity.proctype == 0) {
            int ret = 1;
            for (int i = 0; i < 9; ++i) {
                ItemStack is = blockEntity.getInv().getStackInSlot(i);
                if (is.m_41619_()) continue;
                ++ret;
            }
            return ret += blockEntity.getTank().getFluidAmount() / 250;
        }
        return 0;
    }
}

