/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.client.util;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;

public class GuiUtils {
    public static Quaternionf rotate90 = new Quaternionf(new AxisAngle4f(1.5707964f, 1.0f, 0.0f, 0.0f));
    private static final Function<ResourceLocation, RenderType> GUI_CUTOUT = Util.m_143827_(texture -> RenderType.m_173215_((String)("gui_" + texture), (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_173292_(RenderStateShard.f_173101_).m_110691_(false)));

    private GuiUtils() {
    }

    public static void handleGuiTank(PoseStack transform, IFluidTank tank, int x, int y, int w, int h) {
        FluidStack fluid = tank.getFluid();
        transform.m_85836_();
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        if (fluid != null && fluid.getFluid() != null) {
            int fluidHeight = (int)((float)h * ((float)fluid.getAmount() / (float)tank.getCapacity()));
            GuiUtils.drawRepeatedFluidSpriteGui(buffer, transform, fluid, x, y + h - fluidHeight, w, fluidHeight);
        }
        buffer.m_109911_();
        transform.m_85849_();
    }

    private static void buildVertex(VertexConsumer bu, PoseStack transform, float r, float g, float b, float a, float p1, float p2, float u0, float u1, int light, int overlay) {
        bu.m_252986_(transform.m_85850_().m_252922_(), p1, p2, 0.0f).m_85950_(r, g, b, a).m_7421_(u0, u1).m_86008_(overlay).m_85969_(light).m_252939_(transform.m_85850_().m_252943_(), 1.0f, 1.0f, 1.0f).m_5752_();
    }

    public static void drawRepeatedFluidSpriteGui(MultiBufferSource.BufferSource buffer, PoseStack transform, FluidStack fluid, float x, float y, float w, float h) {
        RenderType renderType = GUI_CUTOUT.apply(InventoryMenu.f_39692_);
        VertexConsumer builder = buffer.m_6299_(renderType);
        IClientFluidTypeExtensions attr = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        TextureAtlasSprite sprite = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(attr.getStillTexture(fluid));
        int col = attr.getTintColor(fluid);
        GuiUtils.drawRepeatedSprite(builder, transform, x, y, w, h, 16, 16, sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_(), (float)(col >> 16 & 0xFF) / 255.0f, (float)(col >> 8 & 0xFF) / 255.0f, (float)(col & 0xFF) / 255.0f, 0.8f, LightTexture.m_109885_((int)15, (int)15), OverlayTexture.f_118083_);
        buffer.m_109912_(renderType);
    }

    public static void drawRepeatedSprite(VertexConsumer builder, PoseStack transform, float x, float y, float w, float h, int iconWidth, int iconHeight, float uMin, float uMax, float vMin, float vMax, float r, float g, float b, float alpha, int light, int overlay) {
        int iterMaxW = (int)(w / (float)iconWidth);
        int iterMaxH = (int)(h / (float)iconHeight);
        float leftoverW = w % (float)iconWidth;
        float leftoverH = h % (float)iconHeight;
        float leftoverWf = leftoverW / (float)iconWidth;
        float leftoverHf = leftoverH / (float)iconHeight;
        float iconUDif = uMax - uMin;
        float iconVDif = vMax - vMin;
        for (int ww = 0; ww < iterMaxW; ++ww) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                GuiUtils.drawTexturedColoredRect(builder, transform, x + (float)(ww * iconWidth), y + (float)(hh * iconHeight), iconWidth, iconHeight, r, g, b, alpha, uMin, uMax, vMin, vMax, light, overlay);
            }
            GuiUtils.drawTexturedColoredRect(builder, transform, x + (float)(ww * iconWidth), y + (float)(iterMaxH * iconHeight), iconWidth, leftoverH, r, g, b, alpha, uMin, uMax, vMin, vMin + iconVDif * leftoverHf, light, overlay);
        }
        if (leftoverW > 0.0f) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                GuiUtils.drawTexturedColoredRect(builder, transform, x + (float)(iterMaxW * iconWidth), y + (float)(hh * iconHeight), leftoverW, iconHeight, r, g, b, alpha, uMin, uMin + iconUDif * leftoverWf, vMin, vMax, light, overlay);
            }
            GuiUtils.drawTexturedColoredRect(builder, transform, x + (float)(iterMaxW * iconWidth), y + (float)(iterMaxH * iconHeight), leftoverW, leftoverH, r, g, b, alpha, uMin, uMin + iconUDif * leftoverWf, vMin, vMin + iconVDif * leftoverHf, light, overlay);
        }
    }

    public static void drawTexturedColoredRect(VertexConsumer builder, PoseStack transform, float x, float y, float w, float h, float r, float g, float b, float alpha, float u0, float u1, float v0, float v1, int light, int overlay) {
        GuiUtils.buildVertex(builder, transform, r, g, b, alpha, x, y + h, u0, v1, light, overlay);
        GuiUtils.buildVertex(builder, transform, r, g, b, alpha, x + w, y + h, u1, v1, light, overlay);
        GuiUtils.buildVertex(builder, transform, r, g, b, alpha, x + w, y, u1, v0, light, overlay);
        GuiUtils.buildVertex(builder, transform, r, g, b, alpha, x, y, u0, v0, light, overlay);
    }
}

