/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes.numbers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.teammoeg.caupona.data.CachedDataDeserializer;
import com.teammoeg.caupona.data.Deserializer;
import com.teammoeg.caupona.data.recipes.CookIngredients;
import com.teammoeg.caupona.data.recipes.numbers.Add;
import com.teammoeg.caupona.data.recipes.numbers.ConstNumber;
import com.teammoeg.caupona.data.recipes.numbers.ItemIngredient;
import com.teammoeg.caupona.data.recipes.numbers.ItemTag;
import com.teammoeg.caupona.data.recipes.numbers.ItemType;
import com.teammoeg.caupona.data.recipes.numbers.NopNumber;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;

public class Numbers {
    private static CachedDataDeserializer<CookIngredients, JsonElement> numbers = new CachedDataDeserializer<CookIngredients, JsonElement>(){

        @Override
        protected CookIngredients internalOf(JsonElement jsonElement) {
            if (jsonElement == null || jsonElement.isJsonNull()) {
                return NopNumber.INSTANCE;
            }
            if (jsonElement.isJsonPrimitive()) {
                JsonPrimitive jp = jsonElement.getAsJsonPrimitive();
                if (jp.isString()) {
                    return new ItemTag((JsonElement)jp);
                }
                if (jp.isNumber()) {
                    return new ConstNumber((JsonElement)jp);
                }
            }
            if (jsonElement.isJsonArray()) {
                return new Add(jsonElement);
            }
            JsonObject jo = jsonElement.getAsJsonObject();
            if (jo.has("type")) {
                Deserializer factory = this.getDeserializer(jo.get("type").getAsString());
                if (factory == null) {
                    return NopNumber.INSTANCE;
                }
                return (CookIngredients)factory.read(jo);
            }
            if (jo.has("item")) {
                return new ItemType((JsonElement)jo);
            }
            if (jo.has("ingredient")) {
                return new ItemIngredient((JsonElement)jo);
            }
            if (jo.has("types")) {
                return new Add((JsonElement)jo);
            }
            if (jo.has("tag")) {
                return new ItemTag((JsonElement)jo);
            }
            return NopNumber.INSTANCE;
        }
    };

    private Numbers() {
    }

    public static void register(String name, Deserializer<JsonElement, CookIngredients> des) {
        numbers.register(name, des);
    }

    public static void register(String name, Function<JsonElement, CookIngredients> rjson, Function<FriendlyByteBuf, CookIngredients> rpacket) {
        numbers.register(name, rjson, rpacket);
    }

    public static CookIngredients of(JsonElement jsonElement) {
        return numbers.of(jsonElement);
    }

    public static CookIngredients of(FriendlyByteBuf buffer) {
        return numbers.of(buffer);
    }

    public static void write(CookIngredients e, FriendlyByteBuf buffer) {
        buffer.m_130070_(e.getType());
        e.write(buffer);
    }

    public static void clearCache() {
        numbers.clearCache();
    }

    static {
        Numbers.register("add", Add::new, Add::new);
        Numbers.register("ingredient", ItemIngredient::new, ItemIngredient::new);
        Numbers.register("item", ItemType::new, ItemType::new);
        Numbers.register("tag", ItemTag::new, ItemTag::new);
        Numbers.register("nop", NopNumber::of, NopNumber::of);
        Numbers.register("const", ConstNumber::new, ConstNumber::new);
    }
}

