/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.util;

import java.util.function.Supplier;
import net.minecraft.world.level.block.state.BlockState;

public class MaterialType {
    String name;
    Supplier<BlockState> base;
    private boolean hasDeco;
    private int counterGrade;
    private boolean hasPill;
    private boolean hasHypo;
    private boolean hasRoad;

    public MaterialType(String name) {
        this.name = name;
    }

    public MaterialType makeDecoration() {
        this.hasDeco = true;
        return this;
    }

    public MaterialType makeCounter(int grade) {
        this.counterGrade = grade;
        return this;
    }

    public MaterialType makePillar() {
        this.hasPill = true;
        return this;
    }

    public MaterialType makeHypocaust() {
        this.hasHypo = true;
        return this;
    }

    public MaterialType makeRoad() {
        this.hasRoad = true;
        return this;
    }

    public MaterialType setBase(Supplier<BlockState> base) {
        this.base = base;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPillarMaterial() {
        return this.hasPill;
    }

    public boolean isDecorationMaterial() {
        return this.hasDeco;
    }

    public int getCounterGrade() {
        return this.counterGrade;
    }

    public boolean isCounterMaterial() {
        return this.counterGrade != 0;
    }

    public boolean isHypocaustMaterial() {
        return this.hasHypo;
    }

    public boolean isRoadMaterial() {
        return this.hasRoad;
    }

    public Supplier<BlockState> getBase() {
        return this.base;
    }
}

